set sw=2 sts=2 et
setl iskeyword+=-
"setlocal nofoldenable
setlocal formatprg=bibclean\ -align-equals\ -brace-protect\ -delete-empty-values\ -fix-accents\ -quiet

compiler bibertool

function! s:open_bibtex_key() abort
  let s:uri = split(split(expand('<cWORD>'), '{')[1], ',')[0]
  if s:uri !=# ''
    silent exec "!open ~/Documents/papers/'".s:uri."'.* &"
  else
    echo 'No match found.'
  endif
endfunction

command! Bibopen call s:open_bibtex_key()
nnoremap <buffer><silent> gx :Bibopen<cr>

iabbrev <buffer> =a @Article{,<CR>author="",<CR>title="",<CR>journal="",<CR>volume="",<CR>number="",<CR>pages="",<CR>year="",<CR>}
iabbrev <buffer> =b @Book{,<CR>author="",<CR>title="",<CR>year="",<CR>editor=""<CR>}
iabbrev <buffer> =m @Misc{,<CR>author="",<CR>title="",<CR>year="",<CR>howpublished=""<CR>}

