packadd neogen
packadd termdebug

lua <<EOF
require('neogen').setup {}
EOF

setlocal path+=/Library/Developer/CommandLineTools/SDKs/MacOSX.sdk/usr/include

setlocal foldmethod=expr
setlocal foldexpr=v:lua.vim.treesitter.foldexpr()

augroup whitespace
  autocmd!
  " No clear coding guidelines (use either 79 or 80 for max line width)
  au BufWinEnter *.c,*.cpp,*.h let w:m2=matchadd('ColorColumn', '\%80v.', -1)
  au BufWinLeave *.c,*.cpp,*.h call clearmatches()
augroup END

augroup qf
  autocmd!
  autocmd QuickFixCmdPost [^l]* nested cwindow
augroup END

compiler gcc

setlocal conceallevel=2  " LSP hover

nnoremap <buffer> gs :gcc -g3 -ggdb3 -Wall -Wextra -Wdouble-promotion -Wno-unused-function -Wno-unknown-pragmas -fsanitize=undefined -fsanitize-undefined-trap-on-error -o %<<cr>
nnoremap <buffer> <localleader>dd :set number \| :Termdebug<space>

ia <buffer> pp printf("DEBUG:",);<Left><Left>
