setlocal sw=2 sts=2 et
setlocal conceallevel=2  " LSP hover

setlocal foldmethod=expr
setlocal foldexpr=v:lua.vim.treesitter.foldexpr()

compiler stack
" setlocal makeprg=ghc\ -dynamic\ %
" setlocal errorformat=%f:%l:%v:%m

if executable("ormolu")
    setlocal formatprg=ormolu\ --stdin-input-file
elseif executable("fourmolu")
    setlocal formatprg=fourmolu\ --stdin-input-file
endif

setlocal include=^import\\s*\\(qualified\\)\\?\\s*
setlocal includeexpr=substitute(v:fname,'\\.','/','g').'.'
setlocal suffixesadd=.hs

function! JumpHaskellFunction(reverse)
    call search('\C[[:alnum:]]*\s*::', a:reverse ? 'bW' : 'W')
endfunction

"nnoremap <buffer> gs :10 split term://chmod +x % && ./%<cr>:startinsert<cr>
nnoremap <buffer> gs :10 split term://stack run<cr>:startinsert<cr>
nnoremap <buffer> <leader>! :sp term://ghci % \| InitRepl<cr>
nnoremap <buffer> <leader>dd :set number \| :10 split term://ghci %<cr>
nnoremap <buffer> <leader># :-1 read ~/.config/nvim/templates/hs<cr>
nnoremap <buffer><silent> ]] :call JumpHaskellFunction(0)<cr>
nnoremap <buffer><silent> [[ :call JumpHaskellFunction(1)<cr>
