set iskeyword+=$
setlocal formatprg=prettier
setlocal makeprg=yarn

setlocal path-=./node_modules/**,node_modules/**
setlocal path=node_modules

let &l:path .= ',' . join(map(finddir('node_modules', '.;', -1), 'fnamemodify(resolve(v:val), ":p:s?[\\/]$??")'), ',')

setlocal include=\\%(\\<require\\s*(\\s*\\\|\\<import\\\|from\\>[^;\"']*\\)[\"']\\zs[^\"']*
setlocal isfname+=@-@
setlocal suffixesadd=.js,.jsx,.ts,.tsx,.d.ts,.vue,/package.json

" https://github.com/phelipetls/dotfiles/blob/master/.config/nvim/after/ftplugin/javascript.vim
function! JavascriptNodeFind(target, current) abort
  let target = substitute(a:target, '^\~[^/]\@=', '', '')
  if target =~# '^\.\.\=/'
    let target = simplify(fnamemodify(resolve(a:current), ':p:h') . '/' . target)
  endif
  let found = findfile(target)
  if found =~# '[\/]package\.json$' && target !~# '[\/]package\.json$'
    try
      let package = json_decode(join(readfile(found)))
      let target .= '/' . substitute(get(package, 'main', 'index'), '\.js$', '', '')
    catch
    endtry
  endif
  if has('nvim')
    return luaeval("require'tsconfig'.includeexpr(_A)", target)
  endif
  return target
endfunction

setlocal includeexpr=JavascriptNodeFind(v:fname,@%)

let &l:define = '^\s*\('
      \ . '\(export\s\)*\(\w\+\s\)*\(var\|const\|type\|let\|function\|class\|interface\|as\|enum\)\s'
      \ . '\|\(public\|private\|protected\|readonly\|static\|get\s\|set\)\s'
      \ . '\|\(export\sdefault\s\|abstract\sclass\s\)'
      \ . '\|\(async\sfunction\)\s'
      \ . '\|\(\ze\i\+([^)]*).*{$\)'
      \ . '\)'
let &l:define = '^\s*\('
      \ . '\(export\s\)*\(\w\+\s\)*\(var\|const\|type\|let\|function\|class\|interface\|as\|enum\)\s'
      \ . '\|\(public\|private\|protected\|readonly\|static\|get\s\|set\)\s'
      \ . '\|\(export\sdefault\s\|abstract\sclass\s\)'
      \ . '\|\(async\sfunction\)\s'
      \ . '\|\(\ze\i\+([^)]*).*{$\)'
      \ . '\)'

if match(expand('%:p:t'), 'test\.\(js\|ts\|jsx\|tsx\)$') != -1
  compiler jest
elseif !empty(findfile('tsconfig.json', ';.')) || !empty(findfile('jsconfig.json', ';.'))
  compiler tsc
elseif executable('npx')
  compiler eslint
endif

nnoremap <buffer> gs :10 split term://node %<cr>:startinsert<cr>
nnoremap <buffer> <leader>! :sp term://node<cr>
