setl makeprg=ros
setlocal keywordprg=nvim-keywordprg\ lisp
setlocal lispwords+=when-let,if-let

setlocal foldmethod=expr
setlocal foldexpr=v:lua.vim.treesitter.foldexpr()

" Source: https://github.com/jabbourb/visper
let g:lisp_hyper="/Users/chl/.local/share/doc/HyperSpec"
let g:lisp_complete_lower=1
let s:hyper_map="Data/Map_Sym.txt"
let s:reg_bounds='(\|\s\|`\|'''

func! s:CommentOrString()
    return match(synIDattr(synID(line('.'), col('.'), 1), "name"), '\ccomment\|\cstring')>=0
endfunc

"NOTE: Use slimv builtin features instead
"setl omnifunc=LispComplete

func! LispComplete(findstart, base)
    if a:findstart
        if !s:CommentOrString() && search(s:reg_bounds, 'b')
            return col('.')
        endif
        return -1
    else
        let results = []
        if strlen(a:base)
            exe 'noau silent! lvimgrep /^'.a:base.'/j '.g:lisp_hyper.'/'.s:hyper_map
            for line in getloclist(0)
                let text = g:lisp_complete_lower ? tolower(line.text) : line.text
                call add(results, text)
            endfor
        endif
        return results
    endif
endfunc

" https://hg.stevelosh.com/dotfiles/file/e7642253ffde/vim/ftplugin/lisp/lispfolding.vim
function! GetLispFold()
      if getline(v:lnum) =~ '^\s*(defun.*\s'
            return ">1"
      elseif getline(v:lnum) =~ '^\s*(defmacro.*\s'
            return ">1"
      elseif getline(v:lnum) =~ '^\s*(defmethod.*\s'
            return ">1"
      elseif getline(v:lnum) =~ '^\s*(defparameter.*\s'
            return ">1"
      elseif getline(v:lnum) =~ '^\s*(defvar.*\s'
            return ">1"
      elseif getline(v:lnum) =~ '^\s*(defclass.*\s'
            return ">1"
      elseif getline(v:lnum) =~ '^\s*(defstruct.*\s'
            return ">1"
      elseif getline(v:lnum) =~ '^\s*(define-.*\s'
            return ">1"
      elseif getline(v:lnum) =~ '^\s*$'
            let my_lispnum = v:lnum
            let my_lispmax = line("$")

            while (1)
                  let my_lispnum = my_lispnum + 1
                  if my_lispnum > my_lispmax
                        return "<1"
                  endif

                  let my_lispdata = getline(my_lispnum)

                  if my_lispdata =~ '^$'
                        return "<1"
                  else
                        return "="
                  endif
            endwhile
      else
            return "="
      endif
endfunction

function! TurnOnLispFolding()
      setlocal foldexpr=GetLispFold()
      setlocal foldmethod=expr
endfunction

nnoremap <buffer> <silent> gO :lua require("fzf-lua").tags()<cr>
nnoremap <buffer> SS :<C-U>call SlimvEvalDefun()<cr>
nnoremap <buffer> ss :<C-U>call SlimvEvalExp()<cr>
nnoremap <buffer> gs :10 split term://ros -Q -- %<cr>:startinsert<cr>
nnoremap <buffer> <leader>! :sp term://ros run --eval '(ql:quickload :swank)'  --eval '(swank:create-server :dont-close t)' \| InitRepl<cr><C-w><C-w>
nnoremap <buffer> <silent> <leader>cc :call TurnOnLispFolding()<cr>
