packadd vim-table-mode

setlocal textwidth=0
setlocal nospell
setlocal nofoldenable
setlocal formatoptions+=n
setlocal iskeyword-=_

setlocal includeexpr='~/Sites/aliquote/content'.substitute(v:fname,'/\$','','g').'.md'

setlocal keywordprg=:MacDictWord

setlocal foldmethod=expr
setlocal foldexpr=v:lua.vim.treesitter.foldexpr()

compiler quarto
setlocal formatprg=prettier\ --parser=markdown\ --stdin-filepath

let b:match_words = b:match_words . ',^```.\+$:^```$'
let b:table_mode_corner='|'

"https://github.com/seth-brown/formd
function! Formd(option) abort
    :let save_view = winsaveview()
    :let flag = a:option
    :if flag == "-i"
        :%! formd -i
    :else
        :%! formd -r
    :endif
    :call winrestview(save_view)
endfunction

function! MarkdownHeaders() abort
    let l:filename = expand("%")
    let l:lines = getbufline('%', 0, '$')
    let l:lines = map(l:lines, {index, value -> {"lnum": index + 1, "text": value, "filename": l:filename}})
    call filter(l:lines, {_, value -> value.text =~# '^#\+ .*$'})
    call setqflist(l:lines)
    copen
endfunction

iabbrev <buffer> =w []()<Esc><Left><Left><Left><Left>
iabbrev <buffer> =' ``<Esc><Left>
iabbrev <buffer> =" ```<CR><CR>```<Esc>2k3l

nnoremap <buffer> gs :10 split term://pandoc -s
      \ --pdf-engine=lualatex
      \ --resource-path=$HOME/.local/share/csl:$HOME/Documents/notes
      \ -F pandoc-crossref --citeproc --listings %
      \ -o %:r.pdf<cr>:startinsert<cr><cr>
nnoremap <buffer> gS :10 split term://pandoc -s
      \ --pdf-engine=xelatex  --citeproc --listings
      \ -t beamer % $HOME/.local/share/pandoc/slides/header.yaml
      \ -o %:r.pdf<cr>:startinsert<cr><cr>
nnoremap <buffer> gra :call Formd("-r")<cr>
xnoremap <buffer> <silent> grn :!trans :en -brief -<cr>
nnoremap <buffer> gO :call MarkdownHeaders()<CR>
nnoremap <buffer> <silent> gl :!open -a Marked\ 2.app %<cr>
nnoremap <buffer> <leader># :-1 read ~/.config/nvim/templates/md<cr>
