packadd vim-table-mode

setlocal textwidth=0
setlocal nospell
setlocal nofoldenable
setlocal concealcursor=nc
setlocal conceallevel=0
" setlocal formatoptions+=pq
setlocal formatoptions+=n

let b:match_words = '^\#+BEGIN.\+$:^\#+END.\+$'

setlocal keywordprg=:MacDictWord

setlocal foldmethod=expr
setlocal foldexpr=v:lua.vim.treesitter.foldexpr()

function! s:JumpToNextHeading(direction, count)
    let col = col(".")
    silent execute a:direction == "up" ? '?^*' : '/^*'
    if a:count > 1
        silent execute "normal! " . repeat("n", a:direction == "up" && col != 1 ? a:count : a:count - 1)
    endif
    silent execute "normal! " . col . "|"
    unlet col
endfunction

function! SelectCodeBlock(inner) abort
  call search('^#+BEGIN.\+', 'bcW')
  execute 'normal ' . (a:inner ==# 'i' ? 'jv' : 'v')
  call search('^#+END.\+$', 'cW')
  execute 'normal ' . (a:inner ==# 'i' ? 'k$' : '$')
endfunction

nnoremap <buffer> <silent> ]] :<C-u>call <SID>JumpToNextHeading("down", v:count1)<CR>
nnoremap <buffer> <silent> [[ :<C-u>call <SID>JumpToNextHeading("up", v:count1)<CR>
xnoremap <silent> ab :<C-u>call SelectCodeBlock("a")<CR>
onoremap <silent> ab :<C-u>normal vac<CR>
xnoremap <silent> ib :<C-u>call SelectCodeBlock("i")<CR>
onoremap <silent> ib :<C-u>normal vic<CR>

iabbrev <buffer> =q #+BEGIN_QUOTE<CR>#+END_QUOTE<Esc>2k$
iabbrev <buffer> =e #+BEGIN_EXAMPLE<CR>#+END_EXAMPLE<Esc>2k$
iabbrev <buffer> =c #+CAPTION: xxx<CR>#+LABEL: xxx<CR>#+NAME: xxx<CR><Esc>0
iabbrev <buffer> =w [[][]]<Esc>5h
iabbrev <buffer> =" #+BEGIN_SRC <CR>#+END_SRC<Esc>
iabbrev <buffer> =' ==<Esc>2h
iabbrev <buffer> =E \begin{equation*}<CR>\end{equation*}<Esc>2k
iabbrev <buffer> =A \begin{aligned}<CR>\end{aligned}<Esc>2k

nnoremap <buffer> gs :10 split term://pandoc -s --pdf-engine=lualatex --resource-path=$HOME/.local/share/csl:$HOME/Documents/notes -F pandoc-crossref --citeproc % -o %:r.pdf<cr>:startinsert<cr><cr>
nnoremap <buffer> gO :lua require("fzf-lua").tags()<cr>
