packadd neogen

set formatoptions+=cro

lua <<EOF
require('neogen').setup{languages = {python = {template = {annotation_convention = "numpydoc"}}}}
EOF

function! s:docstring(...)
    call search('^\s*def.*\n\s*\zs"""\_s*.', 'bc' . (a:0 ? 'e' : ''))
    normal! m<
    if a:0
        call search('.\ze\_s*"""', 'e')
    else
        call search('"""', 'e')
        call search('"""', 'e')
    endif
    normal! m>
    normal! `<v`>
endfunction

xnoremap <buffer> id :<c-u>call <SID>docstring(1)<cr>gv
xnoremap <buffer> ad :<c-u>call <SID>docstring()<cr>gv
onoremap <buffer> id :normal vid<cr>
onoremap <buffer> ad :normal vad<cr>

augroup qf
  autocmd!
  autocmd QuickFixCmdPost [^l]* nested cwindow
augroup END

augroup whitespace
  " PEP 8 (but also PEP 7) says at most 79 chars :); Black defaults to 88
  au!
  au BufWinEnter *.py let w:m2=matchadd('ColorColumn', '\%88v.', -1)
  au BufWinLeave *.py call clearmatches()
augroup END

compiler pytest
"setlocal formatprg=ruff\ format\ --line-length\ 120\ --stdin-filename\ %\ --quiet
"setlocal formatprg=/usr/bin/python3\ -m\ macchiato
setlocal formatprg=black\ --quiet\ -

setlocal foldmethod=expr
setlocal foldexpr=v:lua.vim.treesitter.foldexpr()

setlocal define=^\\s*\\(class\\\|def\\\)
setlocal path+=./tests,./templates,./tests/conftest.py

setlocal conceallevel=2  " LSP hover

nnoremap <buffer> gs :10 split term://python %<cr>:startinsert<cr>
nnoremap <buffer> <silent> <leader>! :sp term://ipython3 --no-banner \| InitRepl<cr><C-w><C-w>
nnoremap <buffer> <localleader>dd :set number \| :set cursorline \| :10 split term://python -m pdb '%:p'<cr>
nnoremap <buffer> <leader># :-1 read ~/.config/nvim/templates/py<cr>
nnoremap <buffer> <leader>ls :call chansend(g:send_target.term_id, "%whos")<cr>
nnoremap <buffer> <leader>su :call chansend(g:send_target.term_id, "import pyskim; pyskim.skim(" .. expand("<cword>") .. ")\n")<cr>
nnoremap <buffer> <leader>gl :call chansend(g:send_target.term_id, "glimpse(" .. expand("<cword>") .. ")\n")<cr>
nnoremap <buffer> <leader>pp :call chansend(g:send_target.term_id, "princ(" .. expand("<cword>") .. ")\n")<cr>
nnoremap <buffer> <leader>tt :!pytest -q --tb=no --color=no --no-header -p no:cacheprovider %<cr>

ia <buffer> pp print(f"DEBUG:")<Left><Left>
ia <buffer> bb breakpoint()<Esc>mb
