augroup whitespace
  autocmd!
  " No clear coding guidelines (use either 79 or 80 for max line width); Use
  " 120 chars with lintr
  au BufWinEnter *.r,*.R let w:m2=matchadd('ColorColumn', '\%120v.', -1)
  au BufWinLeave *.r,*.R call clearmatches()
augroup END

set sw=2 sts=2
setlocal formatprg=Rscript\ -e\ 'options(styler.quiet\ =\ TRUE);\ library(styler,\ lib.loc="~/.local/lib/R/library");\ style_file(commandArgs(TRUE))'

setlocal foldmethod=indent

compiler testthat

ia <buffer> pp cat("DEBUG:", fill = TRUE)

nnoremap <buffer> gs :10 split term://Rscript %<cr>:startinsert<cr>
nnoremap <buffer> <leader>! :sp term://R -q --no-save --no-restore \| InitRepl<cr><C-w><C-w>
nnoremap <buffer> <leader>ls :call chansend(g:send_target.term_id, "ls()\n")<cr>
nnoremap <buffer> <leader>su :call chansend(g:send_target.term_id, "skimr::skim(" .. expand("<cword>") .. ")\n")<cr>
nnoremap <buffer> <leader>gl :call chansend(g:send_target.term_id, "pillar::glimpse(" .. expand("<cword>") .. ")\n")<cr>
nnoremap <buffer> <leader>pp :call chansend(g:send_target.term_id, "tibble::tibble(" .. expand("<cword>") .. ")\n")<cr>
nnoremap <buffer> <leader>tt :!Rscript --slave --no-restore --no-save -e 'suppressPackageStartupMessages(library(tinytest)); run_test_file("%")'<cr>
