set ft=markdown
runtime! ftplugin/markdown.vim

" The following is stolen from vim-rmarkdown
function! s:MapOT(ot)
    let ot = tolower(a:ot)
    if ot == "" || ot == "pdf" || ot == "html" || ot == "word" || ot == "md"
        if ot == ""
            let output_type = "html_document"
        else
            let output_type = ot . "_document"
        endif
    elseif ot == "beamer" || ot == "revealjs" || ot == "ioslides" || ot == "slidy"
        let output_type = ot . "_presentation"
    elseif ot == "all"
        let output_type = ot
    elseif ot =~ '+'
        let formats = split(ot, '+')
        let output_type = map(formats, 's:MapOT(v:val)')
    else
        throw "rmarkdown:E1"
    endif
    return output_type
endfunction

function! s:MapExt(ot)
    let ot = tolower(a:ot)
    if ot == "" || ot == "html" || ot == "md" || ot == "pdf"
        let ext = ot
    elseif ot == "word"
        let ext = "docx"
    elseif ot == "beamer"
        let ext = "pdf"
    elseif ot == "revealjs" || ot == "ioslides" || ot == "slidy"
        let ext = "html"
    elseif ot == "all"
        let ext = "html"
    elseif ot =~ '+'
        let ext = map(split(ot, '+'), 's:MapOT(v:val)')[0]
    else
        throw "rmarkdown:E1"
    endif
    return ext
endfunction

function! RCommand(args)
    let args_data = split(a:args, " ", 1)
    try
        let output_type = s:MapOT(args_data[0])
        if type(output_type) == type("")
            let output_type_arg = '\"' . output_type . '\"'
        elseif type(output_type) == type([])
            let output_types = map(output_type, '"\\\"".v:val."\\\""')
            let output_type_arg = 'c(' . join(output_types, ",").')'
        endif
    catch /rmarkdown:E1/
        echohl errormsg
        echom "vim-rmarkdown: output type not recognized"
        echohl none
        return
    endtry

    if type(output_type) == type("")
        let opts_data = matchlist(a:args, '\(-\s\)\@<=\(.*\)\(\s-\)\@=\(\(.*-\s\)\(.*$\)\)*')
        if opts_data != []
            let render_opts = ', '. substitute(opts_data[2], '\"', '\\\"', 'g')
            let object_opts = opts_data[6]
            if object_opts != ''
                let output_type_arg = substitute(output_type . "(".object_opts.")", '\"', '\\\"', 'g')
            endif
        else
            let render_opts_data = matchstr(a:args, '\(-\s\)\@<=.*')
            if render_opts_data != ''
                let render_opts  = ', ' .render_opts_data
            else
                let render_opts = ''
                let object_opts = join(args_data[1:], ' ')
                if object_opts != ''
                    let output_type_arg = substitute(output_type . "(" . object_opts . ")" , '\"', '\\\"', 'g')
                endif
            endif
        endif
    else
        let render_opts = ''
    endif

    if output_type == "revealjs_presentation"
        let invocation = 'Rscript -e "library(rmarkdown);library(revealjs);render(\"'.
                    \ expand("%:p") . '\", '.
                    \ 'revealjs_presentation()' .
                    \ render_opts.')"'
    else
        let invocation = 'Rscript -e "library(rmarkdown);render(\"'.
                    \ expand("%:p") . '\", '.
                    \ output_type_arg .
                    \ render_opts.')"'
    endif
    let s:output_file = expand("%:p:r"). '.' .s:MapExt(args_data[0])
    let r_output = systemlist(invocation)
endfunction

function! CommandComplete(a, c, p)
    if len(split(a:c, " ", 1)) < 3
        return join(["pdf", "html", "word", "md", "beamer", "revealjs", "ioslides", "slidy"], "\n")
    else
        return ""
    endif
endfunction

command! -buffer -nargs=* -complete=custom,CommandComplete RMarkdown call RCommand('<args>')

iabbrev <buffer> =" ```{}<CR><CR>```<Esc>2k4l

nnoremap <buffer> gs :w<CR>:cd %:p:h <CR>:!Rscript -e 'library(knitr);knit("%:p")'<CR>:!latexmk -pdf -bibtex-cond -f %:r.tex <CR>:!open %:r.pdf <CR><CR>
