exe 'ru! syntax/chicken.vim'
setl keywordprg=chicken-doc\ scheme
setl makeprg=csc
setl complete+=,k~/.local/share/scheme/words
setl include=\^\(\\(use\\\|require-extension\\)\\s\\+
setl includeexpr=substitute(v:fname,'$','.scm','')
setl path+=/Users/chl/.local/lib/scheme/chicken
setl suffixesadd=.scm
setl lispwords+=condition-case
setl lispwords+=with-input-from-string
setl lispwords+=with-output-to-string
setl lispwords+=handle-exceptions
setl lispwords+=call/cc
setl lispwords+=rec
setl lispwords+=receive
setl lispwords+=call-with-output-file

fun! Scheme_indent_top_sexp()
	let pos = getpos('.')
	silent! exec 'normal! 99[(=%'
	call setpos('.', pos)
endfun

nmap <buffer> <silent> == :call Scheme_indent_top_sexp()<cr>

nnoremap <buffer> gs :10 split term://rlwrap csi -s %<cr>:startinsert<cr>
nnoremap <buffer> <leader>! :sp term://rlwrap csi -quiet -:c \| InitRepl<cr>
nnoremap <buffer> <leader># :-1 read ~/.config/nvim/templates/scm<cr>
nnoremap <buffer> <silent> gO :lua require("fzf-lua").tags()<cr>
