" Vim compiler file
" Compiler: luacheck
" Author: Sean Dewar <https://github.com/seandewar>

if exists('current_compiler')
    finish
endif
let current_compiler = 'luacheck'

let s:save_cpo = &cpoptions
set cpoptions&vim

if exists(':CompilerSet') != 2 " older Vim always used :setlocal
  command -nargs=* CompilerSet setlocal <args>
endif

if exists('g:luacheck_makeprg_type') && g:luacheck_makeprg_type ==# 'cd'
  CompilerSet makeprg=luacheck\ --no-color\ .
elseif exists('g:luacheck_makeprg_type') && g:luacheck_makeprg_type ==# 'cfile'
  CompilerSet makeprg=luacheck\ --no-color\ %:S
else
  CompilerSet makeprg=luacheck\ --no-color
endif

CompilerSet errorformat=%f:%l:%c:\ %m,%-G%.%#

let &cpoptions = s:save_cpo
unlet s:save_cpo
