if exists('current_compiler')
  finish
endif
let current_compiler = 'pytest'

" https://phelipetls.github.io/posts/vim-errorformat-for-pytest/
if exists(':CompilerSet') != 2  " older Vim always used :setlocal
  command -nargs=* CompilerSet setlocal <args>
endif

" NOTE: Use -vv to get a more verbose output; maybe use --tb=line to get an
" even more concise output, but we would need to rewrite the errorformat.
" TODO: Maybe we should also handle or switch to uv run pytest (e.g., check if
" there's a pyproject.toml or if uv tree returns project structure)
if has_key(environ(),"VIRTUAL_ENV")
  CompilerSet makeprg=PYTHONDONTWRITEBYTECODE=1\ python\ -m\ pytest\ --tb=short\ -v\ --no-header\ -p\ no:cacheprovider\ $*
else
  CompilerSet makeprg=PYTHONDONTWRITEBYTECODE=1\ pytest\ --tb=short\ -v\ --no-header\ -p\ no:cacheprovider\ $*
endif
CompilerSet errorformat=
      \%EE\ \ \ \ \ File\ \"%f\"\\,\ line\ %l,
      \%CE\ \ \ %p^,
      \%ZE\ \ \ %[%^\ ]%\\@=%m,
      \%Afile\ %f\\,\ line\ %l,
      \%+ZE\ %mnot\ found,
      \%CE\ %.%#,
      \%-G_%\\+\ ERROR%.%#\ _%\\+,
      \%A_%\\+\ %o\ _%\\+,
      \%C%f:%l:\ in\ %o,
      \%ZE\ %\\{3}%m,
      \%EImportError%.%#\'%f\'\.,
      \%C%.%#,
      \%+G%[=]%\\+\ %*\\d\ passed%.%#,
      \%-G%[%^E]%.%#,
      \%-G

function! FixColumnNumber()
  let qflist = getqflist()
  for i in qflist
    let i.col = i.col + 1
  endfor
  call setqflist(qflist)
endfunction

augroup FixPytestQuickFix
  au!
  autocmd QuickFixCmdPost <buffer> call FixColumnNumber()
augroup END
