-- Borrowed from nvim-lspconfig (except I use a global environment named nvim-lsp
-- To update:
-- julia --project=~/.julia/environments/nvim-lsp -e 'using Pkg; Pkg.update()'
local cmd = {
  "julia",
  "--startup-file=no",
  "--history-file=no",
  "-e",
  [[
    # Load LanguageServer.jl: attempt to load from ~/.julia/environments/nvim-lsp
    # with the regular load path as a fallback
    ls_install_path = joinpath(
        get(DEPOT_PATH, 1, joinpath(homedir(), ".julia")),
        "environments", "nvim-lsp"
    )
    pushfirst!(LOAD_PATH, ls_install_path)
    using LanguageServer
    popfirst!(LOAD_PATH)
    depot_path = get(ENV, "JULIA_DEPOT_PATH", "")
    project_path = let
        dirname(something(
            Base.load_path_expand((
                p = get(ENV, "JULIA_PROJECT", nothing);
                p === nothing ? nothing : isempty(p) ? nothing : p
            )),
            Base.current_project(),
            get(Base.load_path(), 1, nothing),
            Base.load_path_expand("@v#.#"),
        ))
    end
    @info "Running language server" VERSION pwd() project_path depot_path
    server = LanguageServer.LanguageServerInstance(stdin, stdout, project_path, depot_path)
    server.runlinter = true
    run(server)
  ]],
}

vim.lsp.start({
  name = "julials",
  cmd = cmd,
  root_dir = vim.fs.dirname(vim.fs.find({ "Project.toml", ".git" }, { upward = true })[1]),
})
