local root_files = { "setup.py", "ruff.toml", ".ruff.toml", "pyproject.toml", "setup.cfg", "requirements.txt" }
local paths = vim.fs.find(root_files, { upward = true, stop = vim.env.HOME })
local root_dir = vim.fs.dirname(paths[1])

-- HACK: Homebrew basedpyright use my fr_FR locale
vim.cmd("language en_US")

local config = {
  name = "basedpyright",
  cmd = { "basedpyright-langserver", "--stdio" },
  root_dir = root_dir,
  settings = {
    basedpyright = {
      disableOrganizeImports = true,
      analysis = {
        -- ignore = { '*' },
        autoImportCompletions = true,
        autoSearchPaths = true,
        useTypingExtensions = true,
        diagnosticMode = "openFilesOnly",
        typeCheckingMode = "recommended",
        useLibraryCodeForTypes = true,
        diagnosticSeverityOverrides = {
          reportAny = false,
          reportMissingParameterType = false,
          reportUnknownVariableType = false,
          reportUnknownMemberType = false,
          reportUnknownArgumentType = false,
          reportUnknownParameterType = false,
          reportUndefinedVariable = false,
          reportUnusedExpression = false,
          reportAttributeAccessIssue = false,
          reportMissingTypeStubs = false,
          reportGeneralTypeIssues = false,
        },
      },
    },
  },
}

vim.lsp.start(config, {
  reuse_client = function(client, conf)
    return (
      client.name == conf.name
      and (
        client.config.root_dir == conf.root_dir
        or (conf.root_dir == nil and vim.startswith(vim.api.nvim_buf_get_name(0), "/opt/homebrew/lib/python3.13"))
      )
    )
  end,
})

vim.lsp.start({
  name = "ruff_lsp",
  cmd = { "ruff", "server" },
  cmd_env = { RUFF_TRACE = "messages" },
  root_dir = root_dir,
  single_file_support = true,
  init_options = {
    settings = {
      logLevel = "debug",
      lineLength = 88,
      fixAll = true,
      organizeImports = true,
      showSyntaxErrors = true,
      codeAction = {
        disableRuleComment = { enable = true },
        fixViolation = { enable = true }
      },
      lint = {
        enable = true,
        preview = true
      },
      format = {
        enable = true,
        preview = true
      },
    }
  },
  capabilities = {
    general = {
      positionEncodings = { "utf-16" }
    },
  }
})

-- local augroup = vim.api.nvim_create_augroup("PythonFormatting", {})
-- vim.api.nvim_clear_autocmds({ group = augroup, buffer = bufnr })
-- vim.api.nvim_create_autocmd({ "BufWritePre" }, {
--   group = augroup,
--   buffer = bufnr,
--   callback = function()
--     vim.api.nvim_command("call FormatFile()")
--   end,
-- })
