local root_dir = vim.fs.root(0, { "gradlew", ".git", "mvnw", "build.gradle", "pom.xml" })
local working_dir = "/Users/chl/.cache/jdtls/" .. vim.fn.fnamemodify(root_dir, ":p:h:t")

return {
  cmd = {
    "java",
    "-Declipse.application=org.eclipse.jdt.ls.core.id1",
    "-Dosgi.bundles.defaultStartLevel=4",
    "-Declipse.product=org.eclipse.jdt.ls.core.product",
    "-Dlog.protocol=true",
    "-Dlog.level=ALL",
    "-Xmx2g",
    "--add-modules=ALL-SYSTEM",
    "--add-opens", "java.base/java.util=ALL-UNNAMED",
    "--add-opens", "java.base/java.lang=ALL-UNNAMED",
    "-javaagent:/Users/chl/.local/lib/lombok/lombok-1.18.40.jar",
    "-jar", "/opt/homebrew/Cellar/jdtls/1.50.0/libexec/plugins/org.eclipse.equinox.launcher_1.7.0.v20250519-0528.jar",
    "-configuration", "/opt/homebrew/Cellar/jdtls/1.50.0/libexec/config_mac_arm",
    "-data", working_dir,
  },
  root_markers = { ".git", "mvnw", "gradlew", "build.gradle", "pom.xml" },
  filetypes = { "java" },
  settings = {
    java = {
      format = {
        enabled = true,
        settings = {
          url = "/Users/chl/.local/share/eclipse/eclipse-java-google-style.xml",
          profile = "GoogleStyle",
        },
      },
      inlayHints = {
        enabled = true,
        --parameterNames = {
        --   enabled = 'all' -- literals, all, none
        --}
      },
      signatureHelp = { enabled = true },
      contentProvider = { preferred = "fernflower" },
      completion = {
        favoriteStaticMembers = {
          "java.util.Objects.requireNonNull",
          "java.util.Objects.requireNonNullElse",
        },
        filteredTypes = {
          "com.sun.*",
          "java.awt.*",
          "jdk.*", "sun.*",
        },
      },
      implementationsCodeLens = {
        enabled = true,
      },
      referencesCodeLens = {
        enabled = true,
      },
      codeGeneration = {
        toString = {
          template = "${object.className}{${member.name()}=${member.value}, ${otherMembers}}"
        },
        hashCodeEquals = {
          useJava7Objects = true,
        },
        useBlocks = true,
      },
    }
  },
  init_options = {
    bundles = {}
  },
}
