" slimv-clhs.vim:
"               Common Lisp Hyperspec lookup support for Slimv
" Version:      0.5.0
" Last Change:  14 Apr 2009
" Maintainer:   Tamas Kovacs <kovisoft at gmail dot com>
" License:      This file is placed in the public domain.
"               No warranty, express or implied.
"               *** ***   Use At-Your-Own-Risk!   *** ***
" Commentary:   This file is based on SLIME's hyperspec.el created by
"               Erik Naggum (http://common-lisp.net/project/slime/),
"               and the cl-lookup package made by Yuji Minejima
"               (http://homepage1.nifty.com/bmonkey/lisp/index-en.html).
"
" =====================================================================
"
"  Load Once:
if &cp || exists( 'g:slimv_clhs_loaded' )
    finish
endif

let g:slimv_clhs_loaded = 1

" It is possible to lookup the following information:
" symbol                    , e.g. "setf"
" hyperspec-chapters        , e.g. [index], [syntax]
" format-control-characters , e.g. "~C: Character", "~%: Newline"
" reader-macro-characters   , e.g. "(", "#'", "#b", "#+"
" loop                      , e.g. loop:with, loop:collect
" arguments                 , e.g. :test, :key, :eof-error-p
" glossary                  , e.g. {absolute}, {binding}

" Root of the Common Lisp Hyperspec
if !exists( 'g:slimv_clhs_root' )
    let g:slimv_clhs_root = 'http://www.lispworks.com/reference/HyperSpec/Body/'
endif

if !exists( 'g:slimv_clhs_clhs' )
    let g:slimv_clhs_clhs = [
    \["&allow-other-keys", "03_da.htm"],
    \["&aux", "03_da.htm"],
    \["&body", "03_dd.htm"],
    \["&environment", "03_dd.htm"],
    \["&key", "03_da.htm"],
    \["&optional", "03_da.htm"],
    \["&rest", "03_da.htm"],
    \["&whole", "03_dd.htm"],
    \["*", "a_st.htm"],
    \["**", "v__stst_.htm"],
    \["***", "v__stst_.htm"],
    \["*break-on-signals*", "v_break_.htm"],
    \["*compile-file-pathname*", "v_cmp_fi.htm"],
    \["*compile-file-truename*", "v_cmp_fi.htm"],
    \["*compile-print*", "v_cmp_pr.htm"],
    \["*compile-verbose*", "v_cmp_pr.htm"],
    \["*debug-io*", "v_debug_.htm"],
    \["*debugger-hook*", "v_debugg.htm"],
    \["*default-pathname-defaults*", "v_defaul.htm"],
    \["*error-output*", "v_debug_.htm"],
    \["*features*", "v_featur.htm"],
    \["*gensym-counter*", "v_gensym.htm"],
    \["*load-pathname*", "v_ld_pns.htm"],
    \["*load-print*", "v_ld_prs.htm"],
    \["*load-truename*", "v_ld_pns.htm"],
    \["*load-verbose*", "v_ld_prs.htm"],
    \["*macroexpand-hook*", "v_mexp_h.htm"],
    \["*modules*", "v_module.htm"],
    \["*package*", "v_pkg.htm"],
    \["*print-array*", "v_pr_ar.htm"],
    \["*print-base*", "v_pr_bas.htm"],
    \["*print-case*", "v_pr_cas.htm"],
    \["*print-circle*", "v_pr_cir.htm"],
    \["*print-escape*", "v_pr_esc.htm"],
    \["*print-gensym*", "v_pr_gen.htm"],
    \["*print-length*", "v_pr_lev.htm"],
    \["*print-level*", "v_pr_lev.htm"],
    \["*print-lines*", "v_pr_lin.htm"],
    \["*print-miser-width*", "v_pr_mis.htm"],
    \["*print-pprint-dispatch*", "v_pr_ppr.htm"],
    \["*print-pretty*", "v_pr_pre.htm"],
    \["*print-radix*", "v_pr_bas.htm"],
    \["*print-readably*", "v_pr_rda.htm"],
    \["*print-right-margin*", "v_pr_rig.htm"],
    \["*query-io*", "v_debug_.htm"],
    \["*random-state*", "v_rnd_st.htm"],
    \["*read-base*", "v_rd_bas.htm"],
    \["*read-default-float-format*", "v_rd_def.htm"],
    \["*read-eval*", "v_rd_eva.htm"],
    \["*read-suppress*", "v_rd_sup.htm"],
    \["*readtable*", "v_rdtabl.htm"],
    \["*standard-input*", "v_debug_.htm"],
    \["*standard-output*", "v_debug_.htm"],
    \["*terminal-io*", "v_termin.htm"],
    \["*trace-output*", "v_debug_.htm"],
    \["+", "a_pl.htm"],
    \["++", "v_pl_plp.htm"],
    \["+++", "v_pl_plp.htm"],
    \["-", "a__.htm"],
    \["/", "a_sl.htm"],
    \["//", "v_sl_sls.htm"],
    \["///", "v_sl_sls.htm"],
    \["/=", "f_eq_sle.htm"],
    \["1+", "f_1pl_1_.htm"],
    \["1-", "f_1pl_1_.htm"],
    \["<", "f_eq_sle.htm"],
    \["<=", "f_eq_sle.htm"],
    \["=", "f_eq_sle.htm"],
    \[">", "f_eq_sle.htm"],
    \[">=", "f_eq_sle.htm"],
    \["abort", "a_abort.htm"],
    \["abs", "f_abs.htm"],
    \["acons", "f_acons.htm"],
    \["acos", "f_asin_.htm"],
    \["acosh", "f_sinh_.htm"],
    \["add-method", "f_add_me.htm"],
    \["adjoin", "f_adjoin.htm"],
    \["adjust-array", "f_adjust.htm"],
    \["adjustable-array-p", "f_adju_1.htm"],
    \["allocate-instance", "f_alloca.htm"],
    \["alpha-char-p", "f_alpha_.htm"],
    \["alphanumericp", "f_alphan.htm"],
    \["and", "a_and.htm"],
    \["append", "f_append.htm"],
    \["apply", "f_apply.htm"],
    \["apropos", "f_apropo.htm"],
    \["apropos-list", "f_apropo.htm"],
    \["aref", "f_aref.htm"],
    \["arithmetic-error", "e_arithm.htm"],
    \["arithmetic-error-operands", "f_arithm.htm"],
    \["arithmetic-error-operation", "f_arithm.htm"],
    \["array", "t_array.htm"],
    \["array-dimension", "f_ar_dim.htm"],
    \["array-dimension-limit", "v_ar_dim.htm"],
    \["array-dimensions", "f_ar_d_1.htm"],
    \["array-displacement", "f_ar_dis.htm"],
    \["array-element-type", "f_ar_ele.htm"],
    \["array-has-fill-pointer-p", "f_ar_has.htm"],
    \["array-in-bounds-p", "f_ar_in_.htm"],
    \["array-rank", "f_ar_ran.htm"],
    \["array-rank-limit", "v_ar_ran.htm"],
    \["array-row-major-index", "f_ar_row.htm"],
    \["array-total-size", "f_ar_tot.htm"],
    \["array-total-size-limit", "v_ar_tot.htm"],
    \["arrayp", "f_arrayp.htm"],
    \["ash", "f_ash.htm"],
    \["asin", "f_asin_.htm"],
    \["asinh", "f_sinh_.htm"],
    \["assert", "m_assert.htm"],
    \["assoc", "f_assocc.htm"],
    \["assoc-if", "f_assocc.htm"],
    \["assoc-if-not", "f_assocc.htm"],
    \["atan", "f_asin_.htm"],
    \["atanh", "f_sinh_.htm"],
    \["atom", "a_atom.htm"],
    \["base-char", "t_base_c.htm"],
    \["base-string", "t_base_s.htm"],
    \["bignum", "t_bignum.htm"],
    \["bit", "a_bit.htm"],
    \["bit-and", "f_bt_and.htm"],
    \["bit-andc1", "f_bt_and.htm"],
    \["bit-andc2", "f_bt_and.htm"],
    \["bit-eqv", "f_bt_and.htm"],
    \["bit-ior", "f_bt_and.htm"],
    \["bit-nand", "f_bt_and.htm"],
    \["bit-nor", "f_bt_and.htm"],
    \["bit-not", "f_bt_and.htm"],
    \["bit-orc1", "f_bt_and.htm"],
    \["bit-orc2", "f_bt_and.htm"],
    \["bit-vector", "t_bt_vec.htm"],
    \["bit-vector-p", "f_bt_vec.htm"],
    \["bit-xor", "f_bt_and.htm"],
    \["block", "s_block.htm"],
    \["boole", "f_boole.htm"],
    \["boole-1", "v_b_1_b.htm"],
    \["boole-2", "v_b_1_b.htm"],
    \["boole-and", "v_b_1_b.htm"],
    \["boole-andc1", "v_b_1_b.htm"],
    \["boole-andc2", "v_b_1_b.htm"],
    \["boole-c1", "v_b_1_b.htm"],
    \["boole-c2", "v_b_1_b.htm"],
    \["boole-clr", "v_b_1_b.htm"],
    \["boole-eqv", "v_b_1_b.htm"],
    \["boole-ior", "v_b_1_b.htm"],
    \["boole-nand", "v_b_1_b.htm"],
    \["boole-nor", "v_b_1_b.htm"],
    \["boole-orc1", "v_b_1_b.htm"],
    \["boole-orc2", "v_b_1_b.htm"],
    \["boole-set", "v_b_1_b.htm"],
    \["boole-xor", "v_b_1_b.htm"],
    \["boolean", "t_ban.htm"],
    \["both-case-p", "f_upper_.htm"],
    \["boundp", "f_boundp.htm"],
    \["break", "f_break.htm"],
    \["broadcast-stream", "t_broadc.htm"],
    \["broadcast-stream-streams", "f_broadc.htm"],
    \["built-in-class", "t_built_.htm"],
    \["butlast", "f_butlas.htm"],
    \["byte", "f_by_by.htm"],
    \["byte-position", "f_by_by.htm"],
    \["byte-size", "f_by_by.htm"],
    \["caaaar", "f_car_c.htm"],
    \["caaadr", "f_car_c.htm"],
    \["caaar", "f_car_c.htm"],
    \["caadar", "f_car_c.htm"],
    \["caaddr", "f_car_c.htm"],
    \["caadr", "f_car_c.htm"],
    \["caar", "f_car_c.htm"],
    \["cadaar", "f_car_c.htm"],
    \["cadadr", "f_car_c.htm"],
    \["cadar", "f_car_c.htm"],
    \["caddar", "f_car_c.htm"],
    \["cadddr", "f_car_c.htm"],
    \["caddr", "f_car_c.htm"],
    \["cadr", "f_car_c.htm"],
    \["call-arguments-limit", "v_call_a.htm"],
    \["call-method", "m_call_m.htm"],
    \["call-next-method", "f_call_n.htm"],
    \["car", "f_car_c.htm"],
    \["case", "m_case_.htm"],
    \["catch", "s_catch.htm"],
    \["ccase", "m_case_.htm"],
    \["cdaaar", "f_car_c.htm"],
    \["cdaadr", "f_car_c.htm"],
    \["cdaar", "f_car_c.htm"],
    \["cdadar", "f_car_c.htm"],
    \["cdaddr", "f_car_c.htm"],
    \["cdadr", "f_car_c.htm"],
    \["cdar", "f_car_c.htm"],
    \["cddaar", "f_car_c.htm"],
    \["cddadr", "f_car_c.htm"],
    \["cddar", "f_car_c.htm"],
    \["cdddar", "f_car_c.htm"],
    \["cddddr", "f_car_c.htm"],
    \["cdddr", "f_car_c.htm"],
    \["cddr", "f_car_c.htm"],
    \["cdr", "f_car_c.htm"],
    \["ceiling", "f_floorc.htm"],
    \["cell-error", "e_cell_e.htm"],
    \["cell-error-name", "f_cell_e.htm"],
    \["cerror", "f_cerror.htm"],
    \["change-class", "f_chg_cl.htm"],
    \["char", "f_char_.htm"],
    \["char-code", "f_char_c.htm"],
    \["char-code-limit", "v_char_c.htm"],
    \["char-downcase", "f_char_u.htm"],
    \["char-equal", "f_chareq.htm"],
    \["char-greaterp", "f_chareq.htm"],
    \["char-int", "f_char_i.htm"],
    \["char-lessp", "f_chareq.htm"],
    \["char-name", "f_char_n.htm"],
    \["char-not-equal", "f_chareq.htm"],
    \["char-not-greaterp", "f_chareq.htm"],
    \["char-not-lessp", "f_chareq.htm"],
    \["char-upcase", "f_char_u.htm"],
    \["char/=", "f_chareq.htm"],
    \["char<", "f_chareq.htm"],
    \["char<=", "f_chareq.htm"],
    \["char=", "f_chareq.htm"],
    \["char>", "f_chareq.htm"],
    \["char>=", "f_chareq.htm"],
    \["character", "a_ch.htm"],
    \["characterp", "f_chp.htm"],
    \["check-type", "m_check_.htm"],
    \["cis", "f_cis.htm"],
    \["class", "t_class.htm"],
    \["class-name", "f_class_.htm"],
    \["class-of", "f_clas_1.htm"],
    \["clear-input", "f_clear_.htm"],
    \["clear-output", "f_finish.htm"],
    \["close", "f_close.htm"],
    \["clrhash", "f_clrhas.htm"],
    \["code-char", "f_code_c.htm"],
    \["coerce", "f_coerce.htm"],
    \["compilation-speed", "d_optimi.htm"],
    \["compile", "f_cmp.htm"],
    \["compile-file", "f_cmp_fi.htm"],
    \["compile-file-pathname", "f_cmp__1.htm"],
    \["compiled-function", "t_cmpd_f.htm"],
    \["compiled-function-p", "f_cmpd_f.htm"],
    \["compiler-macro", "f_docume.htm"],
    \["compiler-macro-function", "f_cmp_ma.htm"],
    \["complement", "f_comple.htm"],
    \["complex", "a_comple.htm"],
    \["complexp", "f_comp_3.htm"],
    \["compute-applicable-methods", "f_comput.htm"],
    \["compute-restarts", "f_comp_1.htm"],
    \["concatenate", "f_concat.htm"],
    \["concatenated-stream", "t_concat.htm"],
    \["concatenated-stream-streams", "f_conc_1.htm"],
    \["cond", "m_cond.htm"],
    \["condition", "e_cnd.htm"],
    \["conjugate", "f_conjug.htm"],
    \["cons", "a_cons.htm"],
    \["consp", "f_consp.htm"],
    \["constantly", "f_cons_1.htm"],
    \["constantp", "f_consta.htm"],
    \["continue", "a_contin.htm"],
    \["control-error", "e_contro.htm"],
    \["copy-alist", "f_cp_ali.htm"],
    \["copy-list", "f_cp_lis.htm"],
    \["copy-pprint-dispatch", "f_cp_ppr.htm"],
    \["copy-readtable", "f_cp_rdt.htm"],
    \["copy-seq", "f_cp_seq.htm"],
    \["copy-structure", "f_cp_stu.htm"],
    \["copy-symbol", "f_cp_sym.htm"],
    \["copy-tree", "f_cp_tre.htm"],
    \["cos", "f_sin_c.htm"],
    \["cosh", "f_sinh_.htm"],
    \["count", "f_countc.htm"],
    \["count-if", "f_countc.htm"],
    \["count-if-not", "f_countc.htm"],
    \["ctypecase", "m_tpcase.htm"],
    \["debug", "d_optimi.htm"],
    \["decf", "m_incf_.htm"],
    \["declaim", "m_declai.htm"],
    \["declaration", "d_declar.htm"],
    \["declare", "s_declar.htm"],
    \["decode-float", "f_dec_fl.htm"],
    \["decode-universal-time", "f_dec_un.htm"],
    \["defclass", "m_defcla.htm"],
    \["defconstant", "m_defcon.htm"],
    \["defgeneric", "m_defgen.htm"],
    \["define-compiler-macro", "m_define.htm"],
    \["define-condition", "m_defi_5.htm"],
    \["define-method-combination", "m_defi_4.htm"],
    \["define-modify-macro", "m_defi_2.htm"],
    \["define-setf-expander", "m_defi_3.htm"],
    \["define-symbol-macro", "m_defi_1.htm"],
    \["defmacro", "m_defmac.htm"],
    \["defmethod", "m_defmet.htm"],
    \["defpackage", "m_defpkg.htm"],
    \["defparameter", "m_defpar.htm"],
    \["defsetf", "m_defset.htm"],
    \["defstruct", "m_defstr.htm"],
    \["deftype", "m_deftp.htm"],
    \["defun", "m_defun.htm"],
    \["defvar", "m_defpar.htm"],
    \["delete", "f_rm_rm.htm"],
    \["delete-duplicates", "f_rm_dup.htm"],
    \["delete-file", "f_del_fi.htm"],
    \["delete-if", "f_rm_rm.htm"],
    \["delete-if-not", "f_rm_rm.htm"],
    \["delete-package", "f_del_pk.htm"],
    \["denominator", "f_numera.htm"],
    \["deposit-field", "f_deposi.htm"],
    \["describe", "f_descri.htm"],
    \["describe-object", "f_desc_1.htm"],
    \["destructuring-bind", "m_destru.htm"],
    \["digit-char", "f_digit_.htm"],
    \["digit-char-p", "f_digi_1.htm"],
    \["directory", "f_dir.htm"],
    \["directory-namestring", "f_namest.htm"],
    \["disassemble", "f_disass.htm"],
    \["division-by-zero", "e_divisi.htm"],
    \["do", "m_do_do.htm"],
    \["do*", "m_do_do.htm"],
    \["do-all-symbols", "m_do_sym.htm"],
    \["do-external-symbols", "m_do_sym.htm"],
    \["do-symbols", "m_do_sym.htm"],
    \["documentation", "f_docume.htm"],
    \["dolist", "m_dolist.htm"],
    \["dotimes", "m_dotime.htm"],
    \["double-float", "t_short_.htm"],
    \["double-float-epsilon", "v_short_.htm"],
    \["double-float-negative-epsilon", "v_short_.htm"],
    \["dpb", "f_dpb.htm"],
    \["dribble", "f_dribbl.htm"],
    \["dynamic-extent", "d_dynami.htm"],
    \["ecase", "m_case_.htm"],
    \["echo-stream", "t_echo_s.htm"],
    \["echo-stream-input-stream", "f_echo_s.htm"],
    \["echo-stream-output-stream", "f_echo_s.htm"],
    \["ed", "f_ed.htm"],
    \["eighth", "f_firstc.htm"],
    \["elt", "f_elt.htm"],
    \["encode-universal-time", "f_encode.htm"],
    \["end-of-file", "e_end_of.htm"],
    \["endp", "f_endp.htm"],
    \["enough-namestring", "f_namest.htm"],
    \["ensure-directories-exist", "f_ensu_1.htm"],
    \["ensure-generic-function", "f_ensure.htm"],
    \["eq", "f_eq.htm"],
    \["eql", "a_eql.htm"],
    \["equal", "f_equal.htm"],
    \["equalp", "f_equalp.htm"],
    \["error", "a_error.htm"],
    \["etypecase", "m_tpcase.htm"],
    \["eval", "f_eval.htm"],
    \["eval-when", "s_eval_w.htm"],
    \["evenp", "f_evenpc.htm"],
    \["every", "f_everyc.htm"],
    \["exp", "f_exp_e.htm"],
    \["export", "f_export.htm"],
    \["expt", "f_exp_e.htm"],
    \["extended-char", "t_extend.htm"],
    \["fboundp", "f_fbound.htm"],
    \["fceiling", "f_floorc.htm"],
    \["fdefinition", "f_fdefin.htm"],
    \["ffloor", "f_floorc.htm"],
    \["fifth", "f_firstc.htm"],
    \["file-author", "f_file_a.htm"],
    \["file-error", "e_file_e.htm"],
    \["file-error-pathname", "f_file_e.htm"],
    \["file-length", "f_file_l.htm"],
    \["file-namestring", "f_namest.htm"],
    \["file-position", "f_file_p.htm"],
    \["file-stream", "t_file_s.htm"],
    \["file-string-length", "f_file_s.htm"],
    \["file-write-date", "f_file_w.htm"],
    \["fill", "f_fill.htm"],
    \["fill-pointer", "f_fill_p.htm"],
    \["find", "f_find_.htm"],
    \["find-all-symbols", "f_find_a.htm"],
    \["find-class", "f_find_c.htm"],
    \["find-if", "f_find_.htm"],
    \["find-if-not", "f_find_.htm"],
    \["find-method", "f_find_m.htm"],
    \["find-package", "f_find_p.htm"],
    \["find-restart", "f_find_r.htm"],
    \["find-symbol", "f_find_s.htm"],
    \["finish-output", "f_finish.htm"],
    \["first", "f_firstc.htm"],
    \["fixnum", "t_fixnum.htm"],
    \["flet", "s_flet_.htm"],
    \["float", "a_float.htm"],
    \["float-digits", "f_dec_fl.htm"],
    \["float-precision", "f_dec_fl.htm"],
    \["float-radix", "f_dec_fl.htm"],
    \["float-sign", "f_dec_fl.htm"],
    \["floating-point-inexact", "e_floa_1.htm"],
    \["floating-point-invalid-operation", "e_floati.htm"],
    \["floating-point-overflow", "e_floa_2.htm"],
    \["floating-point-underflow", "e_floa_3.htm"],
    \["floatp", "f_floatp.htm"],
    \["floor", "f_floorc.htm"],
    \["fmakunbound", "f_fmakun.htm"],
    \["force-output", "f_finish.htm"],
    \["format", "f_format.htm"],
    \["formatter", "m_format.htm"],
    \["fourth", "f_firstc.htm"],
    \["fresh-line", "f_terpri.htm"],
    \["fround", "f_floorc.htm"],
    \["ftruncate", "f_floorc.htm"],
    \["ftype", "d_ftype.htm"],
    \["funcall", "f_funcal.htm"],
    \["function", "a_fn.htm"],
    \["function-keywords", "f_fn_kwd.htm"],
    \["function-lambda-expression", "f_fn_lam.htm"],
    \["functionp", "f_fnp.htm"],
    \["gcd", "f_gcd.htm"],
    \["generic-function", "t_generi.htm"],
    \["gensym", "f_gensym.htm"],
    \["gentemp", "f_gentem.htm"],
    \["get", "f_get.htm"],
    \["get-decoded-time", "f_get_un.htm"],
    \["get-dispatch-macro-character", "f_set__1.htm"],
    \["get-internal-real-time", "f_get_in.htm"],
    \["get-internal-run-time", "f_get__1.htm"],
    \["get-macro-character", "f_set_ma.htm"],
    \["get-output-stream-string", "f_get_ou.htm"],
    \["get-properties", "f_get_pr.htm"],
    \["get-setf-expansion", "f_get_se.htm"],
    \["get-universal-time", "f_get_un.htm"],
    \["getf", "f_getf.htm"],
    \["gethash", "f_gethas.htm"],
    \["go", "s_go.htm"],
    \["graphic-char-p", "f_graphi.htm"],
    \["handler-bind", "m_handle.htm"],
    \["handler-case", "m_hand_1.htm"],
    \["hash-table", "t_hash_t.htm"],
    \["hash-table-count", "f_hash_1.htm"],
    \["hash-table-p", "f_hash_t.htm"],
    \["hash-table-rehash-size", "f_hash_2.htm"],
    \["hash-table-rehash-threshold", "f_hash_3.htm"],
    \["hash-table-size", "f_hash_4.htm"],
    \["hash-table-test", "f_hash_5.htm"],
    \["host-namestring", "f_namest.htm"],
    \["identity", "f_identi.htm"],
    \["if", "s_if.htm"],
    \["ignorable", "d_ignore.htm"],
    \["ignore", "d_ignore.htm"],
    \["ignore-errors", "m_ignore.htm"],
    \["imagpart", "f_realpa.htm"],
    \["import", "f_import.htm"],
    \["in-package", "m_in_pkg.htm"],
    \["incf", "m_incf_.htm"],
    \["initialize-instance", "f_init_i.htm"],
    \["inline", "d_inline.htm"],
    \["input-stream-p", "f_in_stm.htm"],
    \["inspect", "f_inspec.htm"],
    \["integer", "t_intege.htm"],
    \["integer-decode-float", "f_dec_fl.htm"],
    \["integer-length", "f_intege.htm"],
    \["integerp", "f_inte_1.htm"],
    \["interactive-stream-p", "f_intera.htm"],
    \["intern", "f_intern.htm"],
    \["internal-time-units-per-second", "v_intern.htm"],
    \["intersection", "f_isec_.htm"],
    \["invalid-method-error", "f_invali.htm"],
    \["invoke-debugger", "f_invoke.htm"],
    \["invoke-restart", "f_invo_1.htm"],
    \["invoke-restart-interactively", "f_invo_2.htm"],
    \["isqrt", "f_sqrt_.htm"],
    \["keyword", "t_kwd.htm"],
    \["keywordp", "f_kwdp.htm"],
    \["labels", "s_flet_.htm"],
    \["lambda", "a_lambda.htm"],
    \["lambda-list-keywords", "v_lambda.htm"],
    \["lambda-parameters-limit", "v_lamb_1.htm"],
    \["last", "f_last.htm"],
    \["lcm", "f_lcm.htm"],
    \["ldb", "f_ldb.htm"],
    \["ldb-test", "f_ldb_te.htm"],
    \["ldiff", "f_ldiffc.htm"],
    \["least-negative-double-float", "v_most_1.htm"],
    \["least-negative-long-float", "v_most_1.htm"],
    \["least-negative-normalized-double-float", "v_most_1.htm"],
    \["least-negative-normalized-long-float", "v_most_1.htm"],
    \["least-negative-normalized-short-float", "v_most_1.htm"],
    \["least-negative-normalized-single-float", "v_most_1.htm"],
    \["least-negative-short-float", "v_most_1.htm"],
    \["least-negative-single-float", "v_most_1.htm"],
    \["least-positive-double-float", "v_most_1.htm"],
    \["least-positive-long-float", "v_most_1.htm"],
    \["least-positive-normalized-double-float", "v_most_1.htm"],
    \["least-positive-normalized-long-float", "v_most_1.htm"],
    \["least-positive-normalized-short-float", "v_most_1.htm"],
    \["least-positive-normalized-single-float", "v_most_1.htm"],
    \["least-positive-short-float", "v_most_1.htm"],
    \["least-positive-single-float", "v_most_1.htm"],
    \["length", "f_length.htm"],
    \["let", "s_let_l.htm"],
    \["let*", "s_let_l.htm"],
    \["lisp-implementation-type", "f_lisp_i.htm"],
    \["lisp-implementation-version", "f_lisp_i.htm"],
    \["list", "a_list.htm"],
    \["list*", "f_list_.htm"],
    \["list-all-packages", "f_list_a.htm"],
    \["list-length", "f_list_l.htm"],
    \["listen", "f_listen.htm"],
    \["listp", "f_listp.htm"],
    \["load", "f_load.htm"],
    \["load-logical-pathname-translations", "f_ld_log.htm"],
    \["load-time-value", "s_ld_tim.htm"],
    \["locally", "s_locall.htm"],
    \["log", "f_log.htm"],
    \["logand", "f_logand.htm"],
    \["logandc1", "f_logand.htm"],
    \["logandc2", "f_logand.htm"],
    \["logbitp", "f_logbtp.htm"],
    \["logcount", "f_logcou.htm"],
    \["logeqv", "f_logand.htm"],
    \["logical-pathname", "a_logica.htm"],
    \["logical-pathname-translations", "f_logica.htm"],
    \["logior", "f_logand.htm"],
    \["lognand", "f_logand.htm"],
    \["lognor", "f_logand.htm"],
    \["lognot", "f_logand.htm"],
    \["logorc1", "f_logand.htm"],
    \["logorc2", "f_logand.htm"],
    \["logtest", "f_logtes.htm"],
    \["logxor", "f_logand.htm"],
    \["long-float", "t_short_.htm"],
    \["long-float-epsilon", "v_short_.htm"],
    \["long-float-negative-epsilon", "v_short_.htm"],
    \["long-site-name", "f_short_.htm"],
    \["loop", "m_loop.htm"],
    \["loop-finish", "m_loop_f.htm"],
    \["lower-case-p", "f_upper_.htm"],
    \["machine-instance", "f_mach_i.htm"],
    \["machine-type", "f_mach_t.htm"],
    \["machine-version", "f_mach_v.htm"],
    \["macro-function", "f_macro_.htm"],
    \["macroexpand", "f_mexp_.htm"],
    \["macroexpand-1", "f_mexp_.htm"],
    \["macrolet", "s_flet_.htm"],
    \["make-array", "f_mk_ar.htm"],
    \["make-broadcast-stream", "f_mk_bro.htm"],
    \["make-concatenated-stream", "f_mk_con.htm"],
    \["make-condition", "f_mk_cnd.htm"],
    \["make-dispatch-macro-character", "f_mk_dis.htm"],
    \["make-echo-stream", "f_mk_ech.htm"],
    \["make-hash-table", "f_mk_has.htm"],
    \["make-instance", "f_mk_ins.htm"],
    \["make-instances-obsolete", "f_mk_i_1.htm"],
    \["make-list", "f_mk_lis.htm"],
    \["make-load-form", "f_mk_ld_.htm"],
    \["make-load-form-saving-slots", "f_mk_l_1.htm"],
    \["make-method", "m_call_m.htm"],
    \["make-package", "f_mk_pkg.htm"],
    \["make-pathname", "f_mk_pn.htm"],
    \["make-random-state", "f_mk_rnd.htm"],
    \["make-sequence", "f_mk_seq.htm"],
    \["make-string", "f_mk_stg.htm"],
    \["make-string-input-stream", "f_mk_s_1.htm"],
    \["make-string-output-stream", "f_mk_s_2.htm"],
    \["make-symbol", "f_mk_sym.htm"],
    \["make-synonym-stream", "f_mk_syn.htm"],
    \["make-two-way-stream", "f_mk_two.htm"],
    \["makunbound", "f_makunb.htm"],
    \["map", "f_map.htm"],
    \["map-into", "f_map_in.htm"],
    \["mapc", "f_mapc_.htm"],
    \["mapcan", "f_mapc_.htm"],
    \["mapcar", "f_mapc_.htm"],
    \["mapcon", "f_mapc_.htm"],
    \["maphash", "f_maphas.htm"],
    \["mapl", "f_mapc_.htm"],
    \["maplist", "f_mapc_.htm"],
    \["mask-field", "f_mask_f.htm"],
    \["max", "f_max_m.htm"],
    \["member", "a_member.htm"],
    \["member-if", "f_mem_m.htm"],
    \["member-if-not", "f_mem_m.htm"],
    \["merge", "f_merge.htm"],
    \["merge-pathnames", "f_merge_.htm"],
    \["method", "t_method.htm"],
    \["method-combination", "a_method.htm"],
    \["method-combination-error", "f_meth_1.htm"],
    \["method-qualifiers", "f_method.htm"],
    \["min", "f_max_m.htm"],
    \["minusp", "f_minusp.htm"],
    \["mismatch", "f_mismat.htm"],
    \["mod", "a_mod.htm"],
    \["most-negative-double-float", "v_most_1.htm"],
    \["most-negative-fixnum", "v_most_p.htm"],
    \["most-negative-long-float", "v_most_1.htm"],
    \["most-negative-short-float", "v_most_1.htm"],
    \["most-negative-single-float", "v_most_1.htm"],
    \["most-positive-double-float", "v_most_1.htm"],
    \["most-positive-fixnum", "v_most_p.htm"],
    \["most-positive-long-float", "v_most_1.htm"],
    \["most-positive-short-float", "v_most_1.htm"],
    \["most-positive-single-float", "v_most_1.htm"],
    \["muffle-warning", "a_muffle.htm"],
    \["multiple-value-bind", "m_multip.htm"],
    \["multiple-value-call", "s_multip.htm"],
    \["multiple-value-list", "m_mult_1.htm"],
    \["multiple-value-prog1", "s_mult_1.htm"],
    \["multiple-value-setq", "m_mult_2.htm"],
    \["multiple-values-limit", "v_multip.htm"],
    \["name-char", "f_name_c.htm"],
    \["namestring", "f_namest.htm"],
    \["nbutlast", "f_butlas.htm"],
    \["nconc", "f_nconc.htm"],
    \["next-method-p", "f_next_m.htm"],
    \["nil", "a_nil.htm"],
    \["nintersection", "f_isec_.htm"],
    \["ninth", "f_firstc.htm"],
    \["no-applicable-method", "f_no_app.htm"],
    \["no-next-method", "f_no_nex.htm"],
    \["not", "a_not.htm"],
    \["notany", "f_everyc.htm"],
    \["notevery", "f_everyc.htm"],
    \["notinline", "d_inline.htm"],
    \["nreconc", "f_revapp.htm"],
    \["nreverse", "f_revers.htm"],
    \["nset-difference", "f_set_di.htm"],
    \["nset-exclusive-or", "f_set_ex.htm"],
    \["nstring-capitalize", "f_stg_up.htm"],
    \["nstring-downcase", "f_stg_up.htm"],
    \["nstring-upcase", "f_stg_up.htm"],
    \["nsublis", "f_sublis.htm"],
    \["nsubst", "f_substc.htm"],
    \["nsubst-if", "f_substc.htm"],
    \["nsubst-if-not", "f_substc.htm"],
    \["nsubstitute", "f_sbs_s.htm"],
    \["nsubstitute-if", "f_sbs_s.htm"],
    \["nsubstitute-if-not", "f_sbs_s.htm"],
    \["nth", "f_nth.htm"],
    \["nth-value", "m_nth_va.htm"],
    \["nthcdr", "f_nthcdr.htm"],
    \["null", "a_null.htm"],
    \["number", "t_number.htm"],
    \["numberp", "f_nump.htm"],
    \["numerator", "f_numera.htm"],
    \["nunion", "f_unionc.htm"],
    \["oddp", "f_evenpc.htm"],
    \["open", "f_open.htm"],
    \["open-stream-p", "f_open_s.htm"],
    \["optimize", "d_optimi.htm"],
    \["or", "a_or.htm"],
    \["otherwise", "m_case_.htm"],
    \["output-stream-p", "f_in_stm.htm"],
    \["package", "t_pkg.htm"],
    \["package-error", "e_pkg_er.htm"],
    \["package-error-package", "f_pkg_er.htm"],
    \["package-name", "f_pkg_na.htm"],
    \["package-nicknames", "f_pkg_ni.htm"],
    \["package-shadowing-symbols", "f_pkg_sh.htm"],
    \["package-use-list", "f_pkg_us.htm"],
    \["package-used-by-list", "f_pkg__1.htm"],
    \["packagep", "f_pkgp.htm"],
    \["pairlis", "f_pairli.htm"],
    \["parse-error", "e_parse_.htm"],
    \["parse-integer", "f_parse_.htm"],
    \["parse-namestring", "f_pars_1.htm"],
    \["pathname", "a_pn.htm"],
    \["pathname-device", "f_pn_hos.htm"],
    \["pathname-directory", "f_pn_hos.htm"],
    \["pathname-host", "f_pn_hos.htm"],
    \["pathname-match-p", "f_pn_mat.htm"],
    \["pathname-name", "f_pn_hos.htm"],
    \["pathname-type", "f_pn_hos.htm"],
    \["pathname-version", "f_pn_hos.htm"],
    \["pathnamep", "f_pnp.htm"],
    \["peek-char", "f_peek_c.htm"],
    \["phase", "f_phase.htm"],
    \["pi", "v_pi.htm"],
    \["plusp", "f_minusp.htm"],
    \["pop", "m_pop.htm"],
    \["position", "f_pos_p.htm"],
    \["position-if", "f_pos_p.htm"],
    \["position-if-not", "f_pos_p.htm"],
    \["pprint", "f_wr_pr.htm"],
    \["pprint-dispatch", "f_ppr_di.htm"],
    \["pprint-exit-if-list-exhausted", "m_ppr_ex.htm"],
    \["pprint-fill", "f_ppr_fi.htm"],
    \["pprint-indent", "f_ppr_in.htm"],
    \["pprint-linear", "f_ppr_fi.htm"],
    \["pprint-logical-block", "m_ppr_lo.htm"],
    \["pprint-newline", "f_ppr_nl.htm"],
    \["pprint-pop", "m_ppr_po.htm"],
    \["pprint-tab", "f_ppr_ta.htm"],
    \["pprint-tabular", "f_ppr_fi.htm"],
    \["prin1", "f_wr_pr.htm"],
    \["prin1-to-string", "f_wr_to_.htm"],
    \["princ", "f_wr_pr.htm"],
    \["princ-to-string", "f_wr_to_.htm"],
    \["print", "f_wr_pr.htm"],
    \["print-not-readable", "e_pr_not.htm"],
    \["print-not-readable-object", "f_pr_not.htm"],
    \["print-object", "f_pr_obj.htm"],
    \["print-unreadable-object", "m_pr_unr.htm"],
    \["probe-file", "f_probe_.htm"],
    \["proclaim", "f_procla.htm"],
    \["prog", "m_prog_.htm"],
    \["prog*", "m_prog_.htm"],
    \["prog1", "m_prog1c.htm"],
    \["prog2", "m_prog1c.htm"],
    \["progn", "s_progn.htm"],
    \["program-error", "e_progra.htm"],
    \["progv", "s_progv.htm"],
    \["provide", "f_provid.htm"],
    \["psetf", "m_setf_.htm"],
    \["psetq", "m_psetq.htm"],
    \["push", "m_push.htm"],
    \["pushnew", "m_pshnew.htm"],
    \["quote", "s_quote.htm"],
    \["random", "f_random.htm"],
    \["random-state", "t_rnd_st.htm"],
    \["random-state-p", "f_rnd_st.htm"],
    \["rassoc", "f_rassoc.htm"],
    \["rassoc-if", "f_rassoc.htm"],
    \["rassoc-if-not", "f_rassoc.htm"],
    \["ratio", "t_ratio.htm"],
    \["rational", "a_ration.htm"],
    \["rationalize", "f_ration.htm"],
    \["rationalp", "f_rati_1.htm"],
    \["read", "f_rd_rd.htm"],
    \["read-byte", "f_rd_by.htm"],
    \["read-char", "f_rd_cha.htm"],
    \["read-char-no-hang", "f_rd_c_1.htm"],
    \["read-delimited-list", "f_rd_del.htm"],
    \["read-from-string", "f_rd_fro.htm"],
    \["read-line", "f_rd_lin.htm"],
    \["read-preserving-whitespace", "f_rd_rd.htm"],
    \["read-sequence", "f_rd_seq.htm"],
    \["reader-error", "e_rder_e.htm"],
    \["readtable", "t_rdtabl.htm"],
    \["readtable-case", "f_rdtabl.htm"],
    \["readtablep", "f_rdta_1.htm"],
    \["real", "t_real.htm"],
    \["realp", "f_realp.htm"],
    \["realpart", "f_realpa.htm"],
    \["reduce", "f_reduce.htm"],
    \["reinitialize-instance", "f_reinit.htm"],
    \["rem", "f_mod_r.htm"],
    \["remf", "m_remf.htm"],
    \["remhash", "f_remhas.htm"],
    \["remove", "f_rm_rm.htm"],
    \["remove-duplicates", "f_rm_dup.htm"],
    \["remove-if", "f_rm_rm.htm"],
    \["remove-if-not", "f_rm_rm.htm"],
    \["remove-method", "f_rm_met.htm"],
    \["remprop", "f_rempro.htm"],
    \["rename-file", "f_rn_fil.htm"],
    \["rename-package", "f_rn_pkg.htm"],
    \["replace", "f_replac.htm"],
    \["require", "f_provid.htm"],
    \["rest", "f_rest.htm"],
    \["restart", "t_rst.htm"],
    \["restart-bind", "m_rst_bi.htm"],
    \["restart-case", "m_rst_ca.htm"],
    \["restart-name", "f_rst_na.htm"],
    \["return", "m_return.htm"],
    \["return-from", "s_ret_fr.htm"],
    \["revappend", "f_revapp.htm"],
    \["reverse", "f_revers.htm"],
    \["room", "f_room.htm"],
    \["rotatef", "m_rotate.htm"],
    \["round", "f_floorc.htm"],
    \["row-major-aref", "f_row_ma.htm"],
    \["rplaca", "f_rplaca.htm"],
    \["rplacd", "f_rplaca.htm"],
    \["safety", "d_optimi.htm"],
    \["satisfies", "t_satisf.htm"],
    \["sbit", "f_bt_sb.htm"],
    \["scale-float", "f_dec_fl.htm"],
    \["schar", "f_char_.htm"],
    \["search", "f_search.htm"],
    \["second", "f_firstc.htm"],
    \["sequence", "t_seq.htm"],
    \["serious-condition", "e_seriou.htm"],
    \["set", "f_set.htm"],
    \["set-difference", "f_set_di.htm"],
    \["set-dispatch-macro-character", "f_set__1.htm"],
    \["set-exclusive-or", "f_set_ex.htm"],
    \["set-macro-character", "f_set_ma.htm"],
    \["set-pprint-dispatch", "f_set_pp.htm"],
    \["set-syntax-from-char", "f_set_sy.htm"],
    \["setf", "a_setf.htm"],
    \["setq", "s_setq.htm"],
    \["seventh", "f_firstc.htm"],
    \["shadow", "f_shadow.htm"],
    \["shadowing-import", "f_shdw_i.htm"],
    \["shared-initialize", "f_shared.htm"],
    \["shiftf", "m_shiftf.htm"],
    \["short-float", "t_short_.htm"],
    \["short-float-epsilon", "v_short_.htm"],
    \["short-float-negative-epsilon", "v_short_.htm"],
    \["short-site-name", "f_short_.htm"],
    \["signal", "f_signal.htm"],
    \["signed-byte", "t_sgn_by.htm"],
    \["signum", "f_signum.htm"],
    \["simple-array", "t_smp_ar.htm"],
    \["simple-base-string", "t_smp_ba.htm"],
    \["simple-bit-vector", "t_smp_bt.htm"],
    \["simple-bit-vector-p", "f_smp_bt.htm"],
    \["simple-condition", "e_smp_cn.htm"],
    \["simple-condition-format-arguments", "f_smp_cn.htm"],
    \["simple-condition-format-control", "f_smp_cn.htm"],
    \["simple-error", "e_smp_er.htm"],
    \["simple-string", "t_smp_st.htm"],
    \["simple-string-p", "f_smp_st.htm"],
    \["simple-type-error", "e_smp_tp.htm"],
    \["simple-vector", "t_smp_ve.htm"],
    \["simple-vector-p", "f_smp_ve.htm"],
    \["simple-warning", "e_smp_wa.htm"],
    \["sin", "f_sin_c.htm"],
    \["single-float", "t_short_.htm"],
    \["single-float-epsilon", "v_short_.htm"],
    \["single-float-negative-epsilon", "v_short_.htm"],
    \["sinh", "f_sinh_.htm"],
    \["sixth", "f_firstc.htm"],
    \["sleep", "f_sleep.htm"],
    \["slot-boundp", "f_slt_bo.htm"],
    \["slot-exists-p", "f_slt_ex.htm"],
    \["slot-makunbound", "f_slt_ma.htm"],
    \["slot-missing", "f_slt_mi.htm"],
    \["slot-unbound", "f_slt_un.htm"],
    \["slot-value", "f_slt_va.htm"],
    \["software-type", "f_sw_tpc.htm"],
    \["software-version", "f_sw_tpc.htm"],
    \["some", "f_everyc.htm"],
    \["sort", "f_sort_.htm"],
    \["space", "d_optimi.htm"],
    \["special", "d_specia.htm"],
    \["special-operator-p", "f_specia.htm"],
    \["speed", "d_optimi.htm"],
    \["sqrt", "f_sqrt_.htm"],
    \["stable-sort", "f_sort_.htm"],
    \["standard", "07_ffb.htm"],
    \["standard-char", "t_std_ch.htm"],
    \["standard-char-p", "f_std_ch.htm"],
    \["standard-class", "t_std_cl.htm"],
    \["standard-generic-function", "t_std_ge.htm"],
    \["standard-method", "t_std_me.htm"],
    \["standard-object", "t_std_ob.htm"],
    \["step", "m_step.htm"],
    \["storage-condition", "e_storag.htm"],
    \["store-value", "a_store_.htm"],
    \["stream", "t_stream.htm"],
    \["stream-element-type", "f_stm_el.htm"],
    \["stream-error", "e_stm_er.htm"],
    \["stream-error-stream", "f_stm_er.htm"],
    \["stream-external-format", "f_stm_ex.htm"],
    \["streamp", "f_stmp.htm"],
    \["string", "a_string.htm"],
    \["string-capitalize", "f_stg_up.htm"],
    \["string-downcase", "f_stg_up.htm"],
    \["string-equal", "f_stgeq_.htm"],
    \["string-greaterp", "f_stgeq_.htm"],
    \["string-left-trim", "f_stg_tr.htm"],
    \["string-lessp", "f_stgeq_.htm"],
    \["string-not-equal", "f_stgeq_.htm"],
    \["string-not-greaterp", "f_stgeq_.htm"],
    \["string-not-lessp", "f_stgeq_.htm"],
    \["string-right-trim", "f_stg_tr.htm"],
    \["string-stream", "t_stg_st.htm"],
    \["string-trim", "f_stg_tr.htm"],
    \["string-upcase", "f_stg_up.htm"],
    \["string/=", "f_stgeq_.htm"],
    \["string<", "f_stgeq_.htm"],
    \["string<=", "f_stgeq_.htm"],
    \["string=", "f_stgeq_.htm"],
    \["string>", "f_stgeq_.htm"],
    \["string>=", "f_stgeq_.htm"],
    \["stringp", "f_stgp.htm"],
    \["structure", "f_docume.htm"],
    \["structure-class", "t_stu_cl.htm"],
    \["structure-object", "t_stu_ob.htm"],
    \["style-warning", "e_style_.htm"],
    \["sublis", "f_sublis.htm"],
    \["subseq", "f_subseq.htm"],
    \["subsetp", "f_subset.htm"],
    \["subst", "f_substc.htm"],
    \["subst-if", "f_substc.htm"],
    \["subst-if-not", "f_substc.htm"],
    \["substitute", "f_sbs_s.htm"],
    \["substitute-if", "f_sbs_s.htm"],
    \["substitute-if-not", "f_sbs_s.htm"],
    \["subtypep", "f_subtpp.htm"],
    \["svref", "f_svref.htm"],
    \["sxhash", "f_sxhash.htm"],
    \["symbol", "t_symbol.htm"],
    \["symbol-function", "f_symb_1.htm"],
    \["symbol-macrolet", "s_symbol.htm"],
    \["symbol-name", "f_symb_2.htm"],
    \["symbol-package", "f_symb_3.htm"],
    \["symbol-plist", "f_symb_4.htm"],
    \["symbol-value", "f_symb_5.htm"],
    \["symbolp", "f_symbol.htm"],
    \["synonym-stream", "t_syn_st.htm"],
    \["synonym-stream-symbol", "f_syn_st.htm"],
    \["t", "a_t.htm"],
    \["tagbody", "s_tagbod.htm"],
    \["tailp", "f_ldiffc.htm"],
    \["tan", "f_sin_c.htm"],
    \["tanh", "f_sinh_.htm"],
    \["tenth", "f_firstc.htm"],
    \["terpri", "f_terpri.htm"],
    \["the", "s_the.htm"],
    \["third", "f_firstc.htm"],
    \["throw", "s_throw.htm"],
    \["time", "m_time.htm"],
    \["trace", "m_tracec.htm"],
    \["translate-logical-pathname", "f_tr_log.htm"],
    \["translate-pathname", "f_tr_pn.htm"],
    \["tree-equal", "f_tree_e.htm"],
    \["truename", "f_tn.htm"],
    \["truncate", "f_floorc.htm"],
    \["two-way-stream", "t_two_wa.htm"],
    \["two-way-stream-input-stream", "f_two_wa.htm"],
    \["two-way-stream-output-stream", "f_two_wa.htm"],
    \["type", "a_type.htm"],
    \["type-error", "e_tp_err.htm"],
    \["type-error-datum", "f_tp_err.htm"],
    \["type-error-expected-type", "f_tp_err.htm"],
    \["type-of", "f_tp_of.htm"],
    \["typecase", "m_tpcase.htm"],
    \["typep", "f_typep.htm"],
    \["unbound-slot", "e_unboun.htm"],
    \["unbound-slot-instance", "f_unboun.htm"],
    \["unbound-variable", "e_unbo_1.htm"],
    \["undefined-function", "e_undefi.htm"],
    \["unexport", "f_unexpo.htm"],
    \["unintern", "f_uninte.htm"],
    \["union", "f_unionc.htm"],
    \["unless", "m_when_.htm"],
    \["unread-char", "f_unrd_c.htm"],
    \["unsigned-byte", "t_unsgn_.htm"],
    \["untrace", "m_tracec.htm"],
    \["unuse-package", "f_unuse_.htm"],
    \["unwind-protect", "s_unwind.htm"],
    \["update-instance-for-different-class", "f_update.htm"],
    \["update-instance-for-redefined-class", "f_upda_1.htm"],
    \["upgraded-array-element-type", "f_upgr_1.htm"],
    \["upgraded-complex-part-type", "f_upgrad.htm"],
    \["upper-case-p", "f_upper_.htm"],
    \["use-package", "f_use_pk.htm"],
    \["use-value", "a_use_va.htm"],
    \["user-homedir-pathname", "f_user_h.htm"],
    \["values", "a_values.htm"],
    \["values-list", "f_vals_l.htm"],
    \["variable", "f_docume.htm"],
    \["vector", "a_vector.htm"],
    \["vector-pop", "f_vec_po.htm"],
    \["vector-push", "f_vec_ps.htm"],
    \["vector-push-extend", "f_vec_ps.htm"],
    \["vectorp", "f_vecp.htm"],
    \["warn", "f_warn.htm"],
    \["warning", "e_warnin.htm"],
    \["when", "m_when_.htm"],
    \["wild-pathname-p", "f_wild_p.htm"],
    \["with-accessors", "m_w_acce.htm"],
    \["with-compilation-unit", "m_w_comp.htm"],
    \["with-condition-restarts", "m_w_cnd_.htm"],
    \["with-hash-table-iterator", "m_w_hash.htm"],
    \["with-input-from-string", "m_w_in_f.htm"],
    \["with-open-file", "m_w_open.htm"],
    \["with-open-stream", "m_w_op_1.htm"],
    \["with-output-to-string", "m_w_out_.htm"],
    \["with-package-iterator", "m_w_pkg_.htm"],
    \["with-simple-restart", "m_w_smp_.htm"],
    \["with-slots", "m_w_slts.htm"],
    \["with-standard-io-syntax", "m_w_std_.htm"],
    \["write", "f_wr_pr.htm"],
    \["write-byte", "f_wr_by.htm"],
    \["write-char", "f_wr_cha.htm"],
    \["write-line", "f_wr_stg.htm"],
    \["write-sequence", "f_wr_seq.htm"],
    \["write-string", "f_wr_stg.htm"],
    \["write-to-string", "f_wr_to_.htm"],
    \["y-or-n-p", "f_y_or_n.htm"],
    \["yes-or-no-p", "f_y_or_n.htm"],
    \["zerop", "f_zerop.htm"]]
endif

if !exists( 'g:slimv_clhs_issues' )
    let g:slimv_clhs_issues = [
    \["&environment-binding-order:first", "iss001.htm"],
    \["access-error-name", "iss002.htm"],
    \["adjust-array-displacement", "iss003.htm"],
    \["adjust-array-fill-pointer", "iss004.htm"],
    \["adjust-array-not-adjustable:implicit-copy", "iss005.htm"],
    \["allocate-instance:add", "iss006.htm"],
    \["allow-local-inline:inline-notinline", "iss007.htm"],
    \["allow-other-keys-nil:permit", "iss008.htm"],
    \["aref-1d", "iss009.htm"],
    \["argument-mismatch-error-again:consistent", "iss010.htm"],
    \["argument-mismatch-error-moon:fix", "iss011.htm"],
    \["argument-mismatch-error:more-clarifications", "iss012.htm"],
    \["arguments-underspecified:specify", "iss013.htm"],
    \["array-dimension-limit-implications:all-fixnum", "iss014.htm"],
    \["array-type-element-type-semantics:unify-upgrading", "iss015.htm"],
    \["assert-error-type:error", "iss016.htm"],
    \["assoc-rassoc-if-key", "iss017.htm"],
    \["assoc-rassoc-if-key:yes", "iss018.htm"],
    \["boa-aux-initialization:error-on-read", "iss019.htm"],
    \["break-on-warnings-obsolete:remove", "iss020.htm"],
    \["broadcast-stream-return-values:clarify-minimally", "iss021.htm"],
    \["butlast-negative:should-signal", "iss022.htm"],
    \["change-class-initargs:permit", "iss023.htm"],
    \["char-name-case:x3j13-mar-91", "iss024.htm"],
    \["character-loose-ends:fix", "iss025.htm"],
    \["character-proposal:2", "iss026.htm"],
    \["character-proposal:2-1-1", "iss027.htm"],
    \["character-proposal:2-1-2", "iss028.htm"],
    \["character-proposal:2-2-1", "iss029.htm"],
    \["character-proposal:2-3-1", "iss030.htm"],
    \["character-proposal:2-3-2", "iss031.htm"],
    \["character-proposal:2-3-3", "iss032.htm"],
    \["character-proposal:2-3-4", "iss033.htm"],
    \["character-proposal:2-3-5", "iss034.htm"],
    \["character-proposal:2-3-6", "iss035.htm"],
    \["character-proposal:2-4-1", "iss036.htm"],
    \["character-proposal:2-4-2", "iss037.htm"],
    \["character-proposal:2-4-3", "iss038.htm"],
    \["character-proposal:2-5-2", "iss039.htm"],
    \["character-proposal:2-5-6", "iss040.htm"],
    \["character-proposal:2-5-7", "iss041.htm"],
    \["character-proposal:2-6-1", "iss042.htm"],
    \["character-proposal:2-6-2", "iss043.htm"],
    \["character-proposal:2-6-3", "iss044.htm"],
    \["character-proposal:2-6-5", "iss045.htm"],
    \["character-vs-char:less-inconsistent-short", "iss046.htm"],
    \["class-object-specializer:affirm", "iss047.htm"],
    \["clos-conditions-again:allow-subset", "iss048.htm"],
    \["clos-conditions:integrate", "iss049.htm"],
    \["clos-error-checking-order:no-applicable-method-first", "iss050.htm"],
    \["clos-macro-compilation:minimal", "iss051.htm"],
    \["close-constructed-stream:argument-stream-only", "iss052.htm"],
    \["closed-stream-operations:allow-inquiry", "iss053.htm"],
    \["coercing-setf-name-to-function:all-function-names", "iss054.htm"],
    \["colon-number", "iss055.htm"],
    \["common-features:specify", "iss056.htm"],
    \["common-type:remove", "iss057.htm"],
    \["compile-argument-problems-again:fix", "iss058.htm"],
    \["compile-file-handling-of-top-level-forms:clarify", "iss059.htm"],
    \["compile-file-output-file-defaults:input-file", "iss060.htm"],
    \["compile-file-package", "iss061.htm"],
    \["compile-file-pathname-arguments:make-consistent", "iss062.htm"],
    \["compile-file-symbol-handling:new-require-consistency", "iss063.htm"],
    \["compiled-function-requirements:tighten", "iss064.htm"],
    \["compiler-diagnostics:use-handler", "iss065.htm"],
    \["compiler-let-confusion:eliminate", "iss066.htm"],
    \["compiler-verbosity:like-load", "iss067.htm"],
    \["compiler-warning-stream", "iss068.htm"],
    \["complex-atan-branch-cut:tweak", "iss069.htm"],
    \["complex-atanh-bogus-formula:tweak-more", "iss070.htm"],
    \["complex-rational-result:extend", "iss071.htm"],
    \["compute-applicable-methods:generic", "iss072.htm"],
    \["concatenate-sequence:signal-error", "iss073.htm"],
    \["condition-accessors-setfable:no", "iss074.htm"],
    \["condition-restarts:buggy", "iss075.htm"],
    \["condition-restarts:permit-association", "iss076.htm"],
    \["condition-slots:hidden", "iss077.htm"],
    \["cons-type-specifier:add", "iss078.htm"],
    \["constant-circular-compilation:yes", "iss079.htm"],
    \["constant-collapsing:generalize", "iss080.htm"],
    \["constant-compilable-types:specify", "iss081.htm"],
    \["constant-function-compilation:no", "iss082.htm"],
    \["constant-modification:disallow", "iss083.htm"],
    \["constantp-definition:intentional", "iss084.htm"],
    \["constantp-environment:add-arg", "iss085.htm"],
    \["contagion-on-numerical-comparisons:transitive", "iss086.htm"],
    \["copy-symbol-copy-plist:copy-list", "iss087.htm"],
    \["copy-symbol-print-name:equal", "iss088.htm"],
    \["data-io:add-support", "iss089.htm"],
    \["data-types-hierarchy-underspecified", "iss090.htm"],
    \["debugger-hook-vs-break:clarify", "iss091.htm"],
    \["declaration-scope:no-hoisting", "iss092.htm"],
    \["declare-array-type-element-references:restrictive", "iss093.htm"],
    \["declare-function-ambiguity:delete-ftype-abbreviation", "iss094.htm"],
    \["declare-macros:flush", "iss095.htm"],
    \["declare-type-free:lexical", "iss096.htm"],
    \["decls-and-doc", "iss097.htm"],
    \["decode-universal-time-daylight:like-encode", "iss098.htm"],
    \["defconstant-special:no", "iss099.htm"],
    \["defgeneric-declare:allow-multiple", "iss100.htm"],
    \["define-compiler-macro:x3j13-nov89", "iss101.htm"],
    \["define-condition-syntax:incompatibly-more-like-defclass+emphasize-read-only", "iss102.htm"],
    \["define-method-combination-behavior:clarify", "iss103.htm"],
    \["defining-macros-non-top-level:allow", "iss104.htm"],
    \["defmacro-block-scope:excludes-bindings", "iss105.htm"],
    \["defmacro-lambda-list:tighten-description", "iss106.htm"],
    \["defmethod-declaration-scope:corresponds-to-bindings", "iss107.htm"],
    \["defpackage:addition", "iss108.htm"],
    \["defstruct-constructor-key-mixture:allow-key", "iss109.htm"],
    \["defstruct-constructor-options:explicit", "iss110.htm"],
    \["defstruct-constructor-slot-variables:not-bound", "iss111.htm"],
    \["defstruct-copier-argument-type:restrict", "iss112.htm"],
    \["defstruct-copier:argument-type", "iss113.htm"],
    \["defstruct-default-value-evaluation:iff-needed", "iss114.htm"],
    \["defstruct-include-deftype:explicitly-undefined", "iss115.htm"],
    \["defstruct-print-function-again:x3j13-mar-93", "iss116.htm"],
    \["defstruct-print-function-inheritance:yes", "iss117.htm"],
    \["defstruct-redefinition:error", "iss118.htm"],
    \["defstruct-slots-constraints-name:duplicates-error", "iss119.htm"],
    \["defstruct-slots-constraints-number", "iss120.htm"],
    \["deftype-destructuring:yes", "iss121.htm"],
    \["deftype-key:allow", "iss122.htm"],
    \["defvar-documentation:unevaluated", "iss123.htm"],
    \["defvar-init-time:not-delayed", "iss124.htm"],
    \["defvar-initialization:conservative", "iss125.htm"],
    \["deprecation-position:limited", "iss126.htm"],
    \["describe-interactive:no", "iss127.htm"],
    \["describe-underspecified:describe-object", "iss128.htm"],
    \["destructive-operations:specify", "iss129.htm"],
    \["destructuring-bind:new-macro", "iss130.htm"],
    \["disassemble-side-effect:do-not-install", "iss131.htm"],
    \["displaced-array-predicate:add", "iss132.htm"],
    \["do-symbols-block-scope:entire-form", "iss133.htm"],
    \["do-symbols-duplicates", "iss134.htm"],
    \["documentation-function-bugs:fix", "iss135.htm"],
    \["documentation-function-tangled:require-argument", "iss136.htm"],
    \["dotimes-ignore:x3j13-mar91", "iss137.htm"],
    \["dotted-list-arguments:clarify", "iss138.htm"],
    \["dotted-macro-forms:allow", "iss139.htm"],
    \["dribble-technique", "iss140.htm"],
    \["dynamic-extent-function:extend", "iss141.htm"],
    \["dynamic-extent:new-declaration", "iss142.htm"],
    \["equal-structure:maybe-status-quo", "iss143.htm"],
    \["error-terminology-warning:might", "iss144.htm"],
    \["eval-other:self-evaluate", "iss145.htm"],
    \["eval-top-level:load-like-compile-file", "iss146.htm"],
    \["eval-when-non-top-level:generalize-eval-new-keywords", "iss147.htm"],
    \["eval-when-obsolete-keywords:x3j13-mar-1993", "iss148.htm"],
    \["evalhook-step-confusion:fix", "iss149.htm"],
    \["evalhook-step-confusion:x3j13-nov-89", "iss150.htm"],
    \["exit-extent-and-condition-system:like-dynamic-bindings", "iss151.htm"],
    \["exit-extent:minimal", "iss152.htm"],
    \["expt-ratio:p.211", "iss153.htm"],
    \["extensions-position:documentation", "iss154.htm"],
    \["external-format-for-every-file-connection:minimum", "iss155.htm"],
    \["extra-return-values:no", "iss156.htm"],
    \["file-open-error:signal-file-error", "iss157.htm"],
    \["fixnum-non-portable:tighten-definition", "iss158.htm"],
    \["flet-declarations", "iss159.htm"],
    \["flet-declarations:allow", "iss160.htm"],
    \["flet-implicit-block:yes", "iss161.htm"],
    \["float-underflow:add-variables", "iss162.htm"],
    \["floating-point-condition-names:x3j13-nov-89", "iss163.htm"],
    \["format-atsign-colon", "iss164.htm"],
    \["format-colon-uparrow-scope", "iss165.htm"],
    \["format-comma-interval", "iss166.htm"],
    \["format-e-exponent-sign:force-sign", "iss167.htm"],
    \["format-op-c", "iss168.htm"],
    \["format-pretty-print:yes", "iss169.htm"],
    \["format-string-arguments:specify", "iss170.htm"],
    \["function-call-evaluation-order:more-unspecified", "iss171.htm"],
    \["function-composition:jan89-x3j13", "iss172.htm"],
    \["function-definition:jan89-x3j13", "iss173.htm"],
    \["function-name:large", "iss174.htm"],
    \["function-type", "iss175.htm"],
    \["function-type-argument-type-semantics:restrictive", "iss176.htm"],
    \["function-type-key-name:specify-keyword", "iss177.htm"],
    \["function-type-rest-list-element:use-actual-argument-type", "iss178.htm"],
    \["function-type:x3j13-march-88", "iss179.htm"],
    \["generalize-pretty-printer:unify", "iss180.htm"],
    \["generic-flet-poorly-designed:delete", "iss181.htm"],
    \["gensym-name-stickiness:like-teflon", "iss182.htm"],
    \["gentemp-bad-idea:deprecate", "iss183.htm"],
    \["get-macro-character-readtable:nil-standard", "iss184.htm"],
    \["get-setf-method-environment:add-arg", "iss185.htm"],
    \["hash-table-access:x3j13-mar-89", "iss186.htm"],
    \["hash-table-key-modification:specify", "iss187.htm"],
    \["hash-table-package-generators:add-with-wrapper", "iss188.htm"],
    \["hash-table-rehash-size-integer", "iss189.htm"],
    \["hash-table-size:intended-entries", "iss190.htm"],
    \["hash-table-tests:add-equalp", "iss191.htm"],
    \["ieee-atan-branch-cut:split", "iss192.htm"],
    \["ignore-use-terminology:value-only", "iss193.htm"],
    \["import-setf-symbol-package", "iss194.htm"],
    \["in-package-functionality:mar89-x3j13", "iss195.htm"],
    \["in-syntax:minimal", "iss196.htm"],
    \["initialization-function-keyword-checking", "iss197.htm"],
    \["iso-compatibility:add-substrate", "iss198.htm"],
    \["jun90-trivial-issues:11", "iss199.htm"],
    \["jun90-trivial-issues:14", "iss200.htm"],
    \["jun90-trivial-issues:24", "iss201.htm"],
    \["jun90-trivial-issues:25", "iss202.htm"],
    \["jun90-trivial-issues:27", "iss203.htm"],
    \["jun90-trivial-issues:3", "iss204.htm"],
    \["jun90-trivial-issues:4", "iss205.htm"],
    \["jun90-trivial-issues:5", "iss206.htm"],
    \["jun90-trivial-issues:9", "iss207.htm"],
    \["keyword-argument-name-package:any", "iss208.htm"],
    \["last-n", "iss209.htm"],
    \["lcm-no-arguments:1", "iss210.htm"],
    \["lexical-construct-global-definition:undefined", "iss211.htm"],
    \["lisp-package-name:common-lisp", "iss212.htm"],
    \["lisp-symbol-redefinition-again:more-fixes", "iss213.htm"],
    \["lisp-symbol-redefinition:mar89-x3j13", "iss214.htm"],
    \["load-objects:make-load-form", "iss215.htm"],
    \["load-time-eval:r**2-new-special-form", "iss216.htm"],
    \["load-time-eval:r**3-new-special-form", "iss217.htm"],
    \["load-truename:new-pathname-variables", "iss218.htm"],
    \["locally-top-level:special-form", "iss219.htm"],
    \["loop-and-discrepancy:no-reiteration", "iss220.htm"],
    \["loop-for-as-on-typo:fix-typo", "iss221.htm"],
    \["loop-initform-environment:partial-interleaving-vague", "iss222.htm"],
    \["loop-miscellaneous-repairs:fix", "iss223.htm"],
    \["loop-named-block-nil:override", "iss224.htm"],
    \["loop-present-symbols-typo:flush-wrong-words", "iss225.htm"],
    \["loop-syntax-overhaul:repair", "iss226.htm"],
    \["macro-as-function:disallow", "iss227.htm"],
    \["macro-declarations:make-explicit", "iss228.htm"],
    \["macro-environment-extent:dynamic", "iss229.htm"],
    \["macro-function-environment", "iss230.htm"],
    \["macro-function-environment:yes", "iss231.htm"],
    \["macro-subforms-top-level-p:add-constraints", "iss232.htm"],
    \["macroexpand-hook-default:explicitly-vague", "iss233.htm"],
    \["macroexpand-hook-initial-value:implementation-dependent", "iss234.htm"],
    \["macroexpand-return-value:true", "iss235.htm"],
    \["make-load-form-confusion:rewrite", "iss236.htm"],
    \["make-load-form-saving-slots:no-initforms", "iss237.htm"],
    \["make-package-use-default:implementation-dependent", "iss238.htm"],
    \["map-into:add-function", "iss239.htm"],
    \["mapping-destructive-interaction:explicitly-vague", "iss240.htm"],
    \["metaclass-of-system-class:unspecified", "iss241.htm"],
    \["method-combination-arguments:clarify", "iss242.htm"],
    \["method-initform:forbid-call-next-method", "iss243.htm"],
    \["muffle-warning-condition-argument", "iss244.htm"],
    \["multiple-value-setq-order:like-setf-of-values", "iss245.htm"],
    \["multiple-values-limit-on-variables:undefined", "iss246.htm"],
    \["nintersection-destruction", "iss247.htm"],
    \["nintersection-destruction:revert", "iss248.htm"],
    \["not-and-null-return-value:x3j13-mar-93", "iss249.htm"],
    \["nth-value:add", "iss250.htm"],
    \["optimize-debug-info:new-quality", "iss251.htm"],
    \["package-clutter:reduce", "iss252.htm"],
    \["package-deletion:new-function", "iss253.htm"],
    \["package-function-consistency:more-permissive", "iss254.htm"],
    \["parse-error-stream:split-types", "iss255.htm"],
    \["pathname-component-case:keyword-argument", "iss256.htm"],
    \["pathname-component-value:specify", "iss257.htm"],
    \["pathname-host-parsing:recognize-logical-host-names", "iss258.htm"],
    \["pathname-logical:add", "iss259.htm"],
    \["pathname-print-read:sharpsign-p", "iss260.htm"],
    \["pathname-stream", "iss261.htm"],
    \["pathname-stream:files-or-synonym", "iss262.htm"],
    \["pathname-subdirectory-list:new-representation", "iss263.htm"],
    \["pathname-symbol", "iss264.htm"],
    \["pathname-syntax-error-time:explicitly-vague", "iss265.htm"],
    \["pathname-unspecific-component:new-token", "iss266.htm"],
    \["pathname-wild:new-functions", "iss267.htm"],
    \["peek-char-read-char-echo:first-read-char", "iss268.htm"],
    \["plist-duplicates:allow", "iss269.htm"],
    \["pretty-print-interface", "iss270.htm"],
    \["princ-readably:x3j13-dec-91", "iss271.htm"],
    \["print-case-behavior:clarify", "iss272.htm"],
    \["print-case-print-escape-interaction:vertical-bar-rule-no-upcase", "iss273.htm"],
    \["print-circle-shared:respect-print-circle", "iss274.htm"],
    \["print-circle-structure:user-functions-work", "iss275.htm"],
    \["print-readably-behavior:clarify", "iss276.htm"],
    \["printer-whitespace:just-one-space", "iss277.htm"],
    \["proclaim-etc-in-compile-file:new-macro", "iss278.htm"],
    \["push-evaluation-order:first-item", "iss279.htm"],
    \["push-evaluation-order:item-first", "iss280.htm"],
    \["pushnew-store-required:unspecified", "iss281.htm"],
    \["quote-semantics:no-copying", "iss282.htm"],
    \["range-of-count-keyword:nil-or-integer", "iss283.htm"],
    \["range-of-start-and-end-parameters:integer-and-integer-nil", "iss284.htm"],
    \["read-and-write-bytes:new-functions", "iss285.htm"],
    \["read-case-sensitivity:readtable-keywords", "iss286.htm"],
    \["read-modify-write-evaluation-order:delayed-access-stores", "iss287.htm"],
    \["read-suppress-confusing:generalize", "iss288.htm"],
    \["reader-error:new-type", "iss289.htm"],
    \["real-number-type:x3j13-mar-89", "iss290.htm"],
    \["recursive-deftype:explicitly-vague", "iss291.htm"],
    \["reduce-argument-extraction", "iss292.htm"],
    \["remf-destruction-unspecified:x3j13-mar-89", "iss293.htm"],
    \["require-pathname-defaults-again:x3j13-dec-91", "iss294.htm"],
    \["require-pathname-defaults-yet-again:restore-argument", "iss295.htm"],
    \["require-pathname-defaults:eliminate", "iss296.htm"],
    \["rest-list-allocation:may-share", "iss297.htm"],
    \["result-lists-shared:specify", "iss298.htm"],
    \["return-values-unspecified:specify", "iss299.htm"],
    \["room-default-argument:new-value", "iss300.htm"],
    \["self-modifying-code:forbid", "iss301.htm"],
    \["sequence-type-length:must-match", "iss302.htm"],
    \["setf-apply-expansion:ignore-expander", "iss303.htm"],
    \["setf-find-class:allow-nil", "iss304.htm"],
    \["setf-functions-again:minimal-changes", "iss305.htm"],
    \["setf-get-default:evaluated-but-ignored", "iss306.htm"],
    \["setf-macro-expansion:last", "iss307.htm"],
    \["setf-method-vs-setf-method:rename-old-terms", "iss308.htm"],
    \["setf-multiple-store-variables:allow", "iss309.htm"],
    \["setf-of-apply:only-aref-and-friends", "iss310.htm"],
    \["setf-of-values:add", "iss311.htm"],
    \["setf-sub-methods:delayed-access-stores", "iss312.htm"],
    \["shadow-already-present", "iss313.htm"],
    \["shadow-already-present:works", "iss314.htm"],
    \["sharp-comma-confusion:remove", "iss315.htm"],
    \["sharp-o-foobar:consequences-undefined", "iss316.htm"],
    \["sharp-star-delimiter:normal-delimiter", "iss317.htm"],
    \["sharpsign-plus-minus-package:keyword", "iss318.htm"],
    \["slot-missing-values:specify", "iss319.htm"],
    \["slot-value-metaclasses:less-minimal", "iss320.htm"],
    \["special-form-p-misnomer:rename", "iss321.htm"],
    \["special-type-shadowing:clarify", "iss322.htm"],
    \["standard-input-initial-binding:defined-contracts", "iss323.htm"],
    \["standard-repertoire-gratuitous:rename", "iss324.htm"],
    \["step-environment:current", "iss325.htm"],
    \["step-minimal:permit-progn", "iss326.htm"],
    \["stream-access:add-types-accessors", "iss327.htm"],
    \["stream-capabilities:interactive-stream-p", "iss328.htm"],
    \["string-coercion:make-consistent", "iss329.htm"],
    \["string-output-stream-bashing:undefined", "iss330.htm"],
    \["structure-read-print-syntax:keywords", "iss331.htm"],
    \["subseq-out-of-bounds", "iss332.htm"],
    \["subseq-out-of-bounds:is-an-error", "iss333.htm"],
    \["subsetting-position:none", "iss334.htm"],
    \["subtypep-environment:add-arg", "iss335.htm"],
    \["subtypep-too-vague:clarify-more", "iss336.htm"],
    \["sxhash-definition:similar-for-sxhash", "iss337.htm"],
    \["symbol-macrolet-declare:allow", "iss338.htm"],
    \["symbol-macrolet-semantics:special-form", "iss339.htm"],
    \["symbol-macrolet-type-declaration:no", "iss340.htm"],
    \["symbol-macros-and-proclaimed-specials:signals-an-error", "iss341.htm"],
    \["symbol-print-escape-behavior:clarify", "iss342.htm"],
    \["syntactic-environment-access:retracted-mar91", "iss343.htm"],
    \["tagbody-tag-expansion:no", "iss344.htm"],
    \["tailp-nil:t", "iss345.htm"],
    \["test-not-if-not:flush-all", "iss346.htm"],
    \["the-ambiguity:for-declaration", "iss347.htm"],
    \["the-values:return-number-received", "iss348.htm"],
    \["time-zone-non-integer:allow", "iss349.htm"],
    \["type-declaration-abbreviation:allow-all", "iss350.htm"],
    \["type-of-and-predefined-classes:type-of-handles-floats", "iss351.htm"],
    \["type-of-and-predefined-classes:unify-and-extend", "iss352.htm"],
    \["type-of-underconstrained:add-constraints", "iss353.htm"],
    \["type-specifier-abbreviation:x3j13-jun90-guess", "iss354.htm"],
    \["undefined-variables-and-functions:compromise", "iss355.htm"],
    \["uninitialized-elements:consequences-undefined", "iss356.htm"],
    \["unread-char-after-peek-char:dont-allow", "iss357.htm"],
    \["unsolicited-messages:not-to-system-user-streams", "iss358.htm"],
    \["variable-list-asymmetry:symmetrize", "iss359.htm"],
    \["with-added-methods:delete", "iss360.htm"],
    \["with-compilation-unit:new-macro", "iss361.htm"],
    \["with-open-file-does-not-exist:stream-is-nil", "iss362.htm"],
    \["with-open-file-setq:explicitly-vague", "iss363.htm"],
    \["with-open-file-stream-extent:dynamic-extent", "iss364.htm"],
    \["with-output-to-string-append-style:vector-push-extend", "iss365.htm"],
    \["with-standard-io-syntax-readtable:x3j13-mar-91", "iss366.htm"]]
endif
 
if !exists( 'g:slimv_clhs_chapters' )
    let g:slimv_clhs_chapters = [
    \["[index]", "../Front/Contents.htm"],
    \["[introduction]", "01_.htm"],
    \["[syntax]", "02_.htm"],
    \["[evaluation and compilation]", "03_.htm"],
    \["[types and classes]", "04_.htm"],
    \["[data and control flow]", "05_.htm"],
    \["[iteration]", "06_.htm"],
    \["[objects]", "07_.htm"],
    \["[structures]", "08_.htm"],
    \["[conditions]", "09_.htm"],
    \["[symbols]", "10_.htm"],
    \["[packages]", "11_.htm"],
    \["[numbers]", "12_.htm"],
    \["[characters]", "13_.htm"],
    \["[conses]", "14_.htm"],
    \["[arrays]", "15_.htm"],
    \["[strings]", "16_.htm"],
    \["[sequences]", "17_.htm"],
    \["[hash tables]", "18_.htm"],
    \["[filenames]", "19_.htm"],
    \["[files]", "20_.htm"],
    \["[streams]", "21_.htm"],
    \["[printer]", "22_.htm"],
    \["[reader]", "23_.htm"],
    \["[system construction]", "24_.htm"],
    \["[environment]", "25_.htm"],
    \["[glossary]", "26_.htm"]]
endif

if !exists( 'g:slimv_clhs_control_chars' )
    let g:slimv_clhs_control_chars = [
    \["~C: Character", "22_caa.htm"],
    \["~%: Newline", "22_cab.htm"],
    \["~&: Freshline", "22_cac.htm"],
    \["~|: Page", "22_cad.htm"],
    \["~~: Tilde", "22_cae.htm"],
    \["~R: Radix", "22_cba.htm"],
    \["~D: Decimal", "22_cbb.htm"],
    \["~B: Binary", "22_cbc.htm"],
    \["~O: Octal", "22_cbd.htm"],
    \["~X: Hexadecimal", "22_cbe.htm"],
    \["~F: Fixed-Format Floating-Point", "22_cca.htm"],
    \["~E: Exponential Floating-Point", "22_ccb.htm"],
    \["~G: General Floating-Point", "22_ccc.htm"],
    \["~$: Monetary Floating-Point", "22_ccd.htm"],
    \["~A: Aesthetic", "22_cda.htm"],
    \["~S: Standard", "22_cdb.htm"],
    \["~W: Write", "22_cdc.htm"],
    \["~_: Conditional Newline", "22_cea.htm"],
    \["~<: Logical Block", "22_ceb.htm"],
    \["~I: Indent", "22_cec.htm"],
    \["~/: Call Function", "22_ced.htm"],
    \["~T: Tabulate", "22_cfa.htm"],
    \["~<: Justification", "22_cfb.htm"],
    \["~>: End of Justification", "22_cfc.htm"],
    \["~*: Go-To", "22_cga.htm"],
    \["~[: Conditional Expression", "22_cgb.htm"],
    \["~]: End of Conditional Expression", "22_cgc.htm"],
    \["~{: Iteration", "22_cgd.htm"],
    \["~}: End of Iteration", "22_cge.htm"],
    \["~?: Recursive Processing", "22_cgf.htm"],
    \["~(: Case Conversion", "22_cha.htm"],
    \["~): End of Case Conversion", "22_chb.htm"],
    \["~P: Plural", "22_chc.htm"],
    \["~;: Clause Separator", "22_cia.htm"],
    \["~^: Escape Upward", "22_cib.htm"],
    \["~NEWLINE: Ignored Newline", "22_cic.htm"]]
endif

if !exists( 'g:slimv_clhs_macro_chars' )
    let g:slimv_clhs_macro_chars = [
    \["(", "02_da.htm"],
    \[")", "02_db.htm"],
    \["'", "02_dc.htm"],
    \[";", "02_dd.htm"],
    \['"', "02_de.htm"],
    \["`", "02_df.htm"],
    \[",", "02_dg.htm"],
    \["#", "02_dh.htm"],
    \["#\\", "02_dha.htm"],
    \["#'", "02_dhb.htm"],
    \["#(", "02_dhc.htm"],
    \["#*", "02_dhd.htm"],
    \["#:", "02_dhe.htm"],
    \["#.", "02_dhf.htm"],
    \["#b", "02_dhg.htm"],
    \["#o", "02_dhh.htm"],
    \["#x", "02_dhi.htm"],
    \["#r", "02_dhj.htm"],
    \["#c", "02_dhk.htm"],
    \["#a", "02_dhl.htm"],
    \["#s", "02_dhm.htm"],
    \["#p", "02_dhn.htm"],
    \["#=", "02_dho.htm"],
    \["##", "02_dhp.htm"],
    \["#+", "02_dhq.htm"],
    \["#-", "02_dhr.htm"],
    \["#|", "02_dhs.htm"],
    \["#<", "02_dht.htm"]]
endif

if !exists( 'g:slimv_clhs_loop' )
    let g:slimv_clhs_loop = [
    \["loop:with", "06_abb.htm"],
    \["loop:for-as", "06_aba.htm"],
    \["loop:for-as-arithmetic", "06_abaa.htm"],
    \["loop:for-as-in-list", "06_abab.htm"],
    \["loop:for-as-on-list", "06_abac.htm"],
    \["loop:for-as-equals-then", "06_abad.htm"],
    \["loop:for-as-across", "06_abae.htm"],
    \["loop:for-as-hash", "06_abaf.htm"],
    \["loop:for-as-package", "06_abag.htm"],
    \["loop:collect", "06_ac.htm"],
    \["loop:append", "06_ac.htm"],
    \["loop:nconc", "06_ac.htm"],
    \["loop:count", "06_ac.htm"],
    \["loop:maximize", "06_ac.htm"],
    \["loop:minimize", "06_ac.htm"],
    \["loop:sum", "06_ac.htm"],
    \["loop:repeat", "06_ad.htm"],
    \["loop:always", "06_ad.htm"],
    \["loop:never", "06_ad.htm"],
    \["loop:thereis", "06_ad.htm"],
    \["loop:while", "06_ad.htm"],
    \["loop:until", "06_ad.htm"],
    \["loop:do", "06_ae.htm"],
    \["loop:return", "06_ae.htm"],
    \["loop:if", "06_af.htm"],
    \["loop:when", "06_af.htm"],
    \["loop:unless", "06_af.htm"],
    \["loop:else", "06_af.htm"],
    \["loop:it", "06_af.htm"],
    \["loop:end", "06_af.htm"],
    \["loop:named", "06_aga.htm"],
    \["loop:initially", "06_agb.htm"],
    \["loop:finally", "06_agb.htm"]]
endif
            
if !exists( 'g:slimv_clhs_arguments' )
    let g:slimv_clhs_arguments = [
    \[":test", "17_ba.htm"],
    \[":test-not", "17_ba.htm"],
    \[":key", "17_bb.htm"],
    \[":eof-error-p", "23_aca.htm"],
    \[":recursive-p", "23_acb.htm"],
    \[":case", "19_bbab.htm"],
    \["&allow-other-keys", "03_dada.htm"],
    \[":allow-other-keys", "03_dada.htm"]]
endif

if !exists( 'g:slimv_clhs_glossary' )
    let g:slimv_clhs_glossary = [
    \["{()}", "26_glo_9.htm\\#OPCP"],
    \["{absolute}", "26_glo_a.htm\\#absolute"],
    \["{access}", "26_glo_a.htm\\#access"],
    \["{accessibility}", "26_glo_a.htm\\#accessibility"],
    \["{accessible}", "26_glo_a.htm\\#accessible"],
    \["{accessor}", "26_glo_a.htm\\#accessor"],
    \["{active}", "26_glo_a.htm\\#active"],
    \["{actual adjustability}", "26_glo_a.htm\\#actual_adjustability"],
    \["{actual argument}", "26_glo_a.htm\\#actual_argument"],
    \["{actual array element type}", "26_glo_a.htm\\#actual_array_element_type"],
    \["{actual complex part type}", "26_glo_a.htm\\#actual_complex_part_type"],
    \["{actual parameter}", "26_glo_a.htm\\#actual_parameter"],
    \["{actually adjustable}", "26_glo_a.htm\\#actually_adjustable"],
    \["{adjustability}", "26_glo_a.htm\\#adjustability"],
    \["{adjustable}", "26_glo_a.htm\\#adjustable"],
    \["{after method}", "26_glo_a.htm\\#after_method"],
    \["{alist}", "26_glo_a.htm\\#alist"],
    \["{alphabetic}", "26_glo_a.htm\\#alphabetic"],
    \["{alphanumeric}", "26_glo_a.htm\\#alphanumeric"],
    \["{ampersand}", "26_glo_a.htm\\#ampersand"],
    \["{anonymous}", "26_glo_a.htm\\#anonymous"],
    \["{apparently uninterned}", "26_glo_a.htm\\#apparently_uninterned"],
    \["{applicable}", "26_glo_a.htm\\#applicable"],
    \["{applicable handler}", "26_glo_a.htm\\#applicable_handler"],
    \["{applicable method}", "26_glo_a.htm\\#applicable_method"],
    \["{applicable restart}", "26_glo_a.htm\\#applicable_restart"],
    \["{apply}", "26_glo_a.htm\\#apply"],
    \["{argument}", "26_glo_a.htm\\#argument"],
    \["{argument evaluation order}", "26_glo_a.htm\\#argument_evaluation_order"],
    \["{argument precedence order}", "26_glo_a.htm\\#argument_precedence_order"],
    \["{around method}", "26_glo_a.htm\\#around_method"],
    \["{array}", "26_glo_a.htm\\#array"],
    \["{array element type}", "26_glo_a.htm\\#array_element_type"],
    \["{array total size}", "26_glo_a.htm\\#array_total_size"],
    \["{assign}", "26_glo_a.htm\\#assign"],
    \["{association list}", "26_glo_a.htm\\#association_list"],
    \["{asterisk}", "26_glo_a.htm\\#asterisk"],
    \["{at-sign}", "26_glo_a.htm\\#at-sign"],
    \["{atom}", "26_glo_a.htm\\#atom"],
    \["{atomic}", "26_glo_a.htm\\#atomic"],
    \["{atomic type specifier}", "26_glo_a.htm\\#atomic_type_specifier"],
    \["{attribute}", "26_glo_a.htm\\#attribute"],
    \["{aux variable}", "26_glo_a.htm\\#aux_variable"],
    \["{auxiliary method}", "26_glo_a.htm\\#auxiliary_method"],
    \["{backquote}", "26_glo_b.htm\\#backquote"],
    \["{backslash}", "26_glo_b.htm\\#backslash"],
    \["{base character}", "26_glo_b.htm\\#base_character"],
    \["{base string}", "26_glo_b.htm\\#base_string"],
    \["{before method}", "26_glo_b.htm\\#before_method"],
    \["{bidirectional}", "26_glo_b.htm\\#bidirectional"],
    \["{binary}", "26_glo_b.htm\\#binary"],
    \["{bind}", "26_glo_b.htm\\#bind"],
    \["{binding}", "26_glo_b.htm\\#binding"],
    \["{bit}", "26_glo_b.htm\\#bit"],
    \["{bit array}", "26_glo_b.htm\\#bit_array"],
    \["{bit vector}", "26_glo_b.htm\\#bit_vector"],
    \["{bit-wise logical operation specifier}", "26_glo_b.htm\\#bit-wise_logical_operation_specifier"],
    \["{block}", "26_glo_b.htm\\#block"],
    \["{block tag}", "26_glo_b.htm\\#block_tag"],
    \["{boa lambda list}", "26_glo_b.htm\\#boa_lambda_list"],
    \["{body parameter}", "26_glo_b.htm\\#body_parameter"],
    \["{boolean}", "26_glo_b.htm\\#boolean"],
    \["{boolean equivalent}", "26_glo_b.htm\\#boolean_equivalent"],
    \["{bound}", "26_glo_b.htm\\#bound"],
    \["{bound declaration}", "26_glo_b.htm\\#bound_declaration"],
    \["{bounded}", "26_glo_b.htm\\#bounded"],
    \["{bounding index}", "26_glo_b.htm\\#bounding_index"],
    \["{bounding index designator}", "26_glo_b.htm\\#bounding_index_designator"],
    \["{break loop}", "26_glo_b.htm\\#break_loop"],
    \["{broadcast stream}", "26_glo_b.htm\\#broadcast_stream"],
    \["{built-in class}", "26_glo_b.htm\\#built-in_class"],
    \["{built-in type}", "26_glo_b.htm\\#built-in_type"],
    \["{byte}", "26_glo_b.htm\\#byte"],
    \["{byte specifier}", "26_glo_b.htm\\#byte_specifier"],
    \["{cadr}", "26_glo_c.htm\\#cadr"],
    \["{call}", "26_glo_c.htm\\#call"],
    \["{captured initialization form}", "26_glo_c.htm\\#captured_initialization_form"],
    \["{car}", "26_glo_c.htm\\#car"],
    \["{case}", "26_glo_c.htm\\#case"],
    \["{case sensitivity mode}", "26_glo_c.htm\\#case_sensitivity_mode"],
    \["{catch}", "26_glo_c.htm\\#catch"],
    \["{catch tag}", "26_glo_c.htm\\#catch_tag"],
    \["{cddr}", "26_glo_c.htm\\#cddr"],
    \["{cdr}", "26_glo_c.htm\\#cdr"],
    \["{cell}", "26_glo_c.htm\\#cell"],
    \["{character}", "26_glo_c.htm\\#character"],
    \["{character code}", "26_glo_c.htm\\#character_code"],
    \["{character designator}", "26_glo_c.htm\\#character_designator"],
    \["{circular}", "26_glo_c.htm\\#circular"],
    \["{circular list}", "26_glo_c.htm\\#circular_list"],
    \["{class}", "26_glo_c.htm\\#class"],
    \["{class designator}", "26_glo_c.htm\\#class_designator"],
    \["{class precedence list}", "26_glo_c.htm\\#class_precedence_list"],
    \["{close}", "26_glo_c.htm\\#close"],
    \["{closed}", "26_glo_c.htm\\#closed"],
    \["{closure}", "26_glo_c.htm\\#closure"],
    \["{coalesce}", "26_glo_c.htm\\#coalesce"],
    \["{code}", "26_glo_c.htm\\#code"],
    \["{coerce}", "26_glo_c.htm\\#coerce"],
    \["{colon}", "26_glo_c.htm\\#colon"],
    \["{comma}", "26_glo_c.htm\\#comma"],
    \["{compilation}", "26_glo_c.htm\\#compilation"],
    \["{compilation environment}", "26_glo_c.htm\\#compilation_environment"],
    \["{compilation unit}", "26_glo_c.htm\\#compilation_unit"],
    \["{compile}", "26_glo_c.htm\\#compile"],
    \["{compile time}", "26_glo_c.htm\\#compile_time"],
    \["{compile time definition}", "26_glo_c.htm\\#compile-time_definition"],
    \["{compiled code}", "26_glo_c.htm\\#compiled_code"],
    \["{compiled file}", "26_glo_c.htm\\#compiled_file"],
    \["{compiled function}", "26_glo_c.htm\\#compiled_function"],
    \["{compiler}", "26_glo_c.htm\\#compiler"],
    \["{compiler macro}", "26_glo_c.htm\\#compiler_macro"],
    \["{compiler macro expansion}", "26_glo_c.htm\\#compiler_macro_expansion"],
    \["{compiler macro form}", "26_glo_c.htm\\#compiler_macro_form"],
    \["{compiler macro function}", "26_glo_c.htm\\#compiler_macro_function"],
    \["{complex}", "26_glo_c.htm\\#complex"],
    \["{complex float}", "26_glo_c.htm\\#complex_float"],
    \["{complex part type}", "26_glo_c.htm\\#complex_part_type"],
    \["{complex rational}", "26_glo_c.htm\\#complex_rational"],
    \["{complex single float}", "26_glo_c.htm\\#complex_single_float"],
    \["{composite stream}", "26_glo_c.htm\\#composite_stream"],
    \["{compound form}", "26_glo_c.htm\\#compound_form"],
    \["{compound type specifier}", "26_glo_c.htm\\#compound_type_specifier"],
    \["{concatenated stream}", "26_glo_c.htm\\#concatenated_stream"],
    \["{condition}", "26_glo_c.htm\\#condition"],
    \["{condition designator}", "26_glo_c.htm\\#condition_designator"],
    \["{condition handler}", "26_glo_c.htm\\#condition_handler"],
    \["{condition reporter}", "26_glo_c.htm\\#condition_reporter"],
    \["{conditional newline}", "26_glo_c.htm\\#conditional_newline"],
    \["{conformance}", "26_glo_c.htm\\#conformance"],
    \["{conforming code}", "26_glo_c.htm\\#conforming_code"],
    \["{conforming implementation}", "26_glo_c.htm\\#conforming_implementation"],
    \["{conforming processor}", "26_glo_c.htm\\#conforming_processor"],
    \["{conforming program}", "26_glo_c.htm\\#conforming_program"],
    \["{congruent}", "26_glo_c.htm\\#congruent"],
    \["{cons}", "26_glo_c.htm\\#cons"],
    \["{constant}", "26_glo_c.htm\\#constant"],
    \["{constant form}", "26_glo_c.htm\\#constant_form"],
    \["{constant object}", "26_glo_c.htm\\#constant_object"],
    \["{constant variable}", "26_glo_c.htm\\#constant_variable"],
    \["{constituent}", "26_glo_c.htm\\#constituent"],
    \["{constituent trait}", "26_glo_c.htm\\#constituent_trait"],
    \["{constructed stream}", "26_glo_c.htm\\#constructed_stream"],
    \["{contagion}", "26_glo_c.htm\\#contagion"],
    \["{continuable}", "26_glo_c.htm\\#continuable"],
    \["{control form}", "26_glo_c.htm\\#control_form"],
    \["{copy}", "26_glo_c.htm\\#copy"],
    \["{correctable}", "26_glo_c.htm\\#correctable"],
    \["{current input base}", "26_glo_c.htm\\#current_input_base"],
    \["{current logical block}", "26_glo_c.htm\\#current_logical_block"],
    \["{current output base}", "26_glo_c.htm\\#current_output_base"],
    \["{current package}", "26_glo_c.htm\\#current_package"],
    \["{current pprint dispatch table}", "26_glo_c.htm\\#current_pprint_dispatch_table"],
    \["{current random state}", "26_glo_c.htm\\#current_random_state"],
    \["{current readtable}", "26_glo_c.htm\\#current_readtable"],
    \["{data type}", "26_glo_d.htm\\#data_type"],
    \["{debug I/O}", "26_glo_d.htm\\#debug_iSLo"],
    \["{debugger}", "26_glo_d.htm\\#debugger"],
    \["{declaration}", "26_glo_d.htm\\#declaration"],
    \["{declaration identifier}", "26_glo_d.htm\\#declaration_identifier"],
    \["{declaration specifier}", "26_glo_d.htm\\#declaration_specifier"],
    \["{declare}", "26_glo_d.htm\\#declare"],
    \["{decline}", "26_glo_d.htm\\#decline"],
    \["{decoded time}", "26_glo_d.htm\\#decoded_time"],
    \["{default method}", "26_glo_d.htm\\#default_method"],
    \["{defaulted initialization argument list}", "26_glo_d.htm\\#defaulted_initialization_argument_list"],
    \["{define-method-combination arguments lambda list}", "26_glo_d.htm\\#define-method-combination_arguments_lambda_list"],
    \["{define-modify-macro lambda list}", "26_glo_d.htm\\#define-modify-macro_lambda_list"],
    \["{defined name}", "26_glo_d.htm\\#defined_name"],
    \["{defining form}", "26_glo_d.htm\\#defining_form"],
    \["{defsetf lambda list}", "26_glo_d.htm\\#defsetf_lambda_list"],
    \["{deftype lambda list}", "26_glo_d.htm\\#deftype_lambda_list"],
    \["{denormalized}", "26_glo_d.htm\\#denormalized"],
    \["{derived type}", "26_glo_d.htm\\#derived_type"],
    \["{derived type specifier}", "26_glo_d.htm\\#derived_type_specifier"],
    \["{designator}", "26_glo_d.htm\\#designator"],
    \["{destructive}", "26_glo_d.htm\\#destructive"],
    \["{destructuring lambda list}", "26_glo_d.htm\\#destructuring_lambda_list"],
    \["{different}", "26_glo_d.htm\\#different"],
    \["{digit}", "26_glo_d.htm\\#digit"],
    \["{dimension}", "26_glo_d.htm\\#dimension"],
    \["{direct instance}", "26_glo_d.htm\\#direct_instance"],
    \["{direct subclass}", "26_glo_d.htm\\#direct_subclass"],
    \["{direct superclass}", "26_glo_d.htm\\#direct_superclass"],
    \["{disestablish}", "26_glo_d.htm\\#disestablish"],
    \["{disjoint}", "26_glo_d.htm\\#disjoint"],
    \["{dispatching macro character}", "26_glo_d.htm\\#dispatching_macro_character"],
    \["{displaced array}", "26_glo_d.htm\\#displaced_array"],
    \["{distinct}", "26_glo_d.htm\\#distinct"],
    \["{documentation string}", "26_glo_d.htm\\#documentation_string"],
    \["{dot}", "26_glo_d.htm\\#dot"],
    \["{dotted list}", "26_glo_d.htm\\#dotted_list"],
    \["{dotted pair}", "26_glo_d.htm\\#dotted_pair"],
    \["{double float}", "26_glo_d.htm\\#double_float"],
    \["{double-quote}", "26_glo_d.htm\\#double-quote"],
    \["{dynamic binding}", "26_glo_d.htm\\#dynamic_binding"],
    \["{dynamic environment}", "26_glo_d.htm\\#dynamic_environment"],
    \["{dynamic extent}", "26_glo_d.htm\\#dynamic_extent"],
    \["{dynamic scope}", "26_glo_d.htm\\#dynamic_scope"],
    \["{dynamic variable}", "26_glo_d.htm\\#dynamic_variable"],
    \["{echo stream}", "26_glo_e.htm\\#echo_stream"],
    \["{effective method}", "26_glo_e.htm\\#effective_method"],
    \["{element}", "26_glo_e.htm\\#element"],
    \["{element type}", "26_glo_e.htm\\#element_type"],
    \["{em}", "26_glo_e.htm\\#em"],
    \["{empty list}", "26_glo_e.htm\\#empty_list"],
    \["{empty type}", "26_glo_e.htm\\#empty_type"],
    \["{end of file}", "26_glo_e.htm\\#end_of_file"],
    \["{environment}", "26_glo_e.htm\\#environment"],
    \["{environment object}", "26_glo_e.htm\\#environment_object"],
    \["{environment parameter}", "26_glo_e.htm\\#environment_parameter"],
    \["{error}", "26_glo_e.htm\\#error"],
    \["{error output}", "26_glo_e.htm\\#error_output"],
    \["{escape}", "26_glo_e.htm\\#escape"],
    \["{establish}", "26_glo_e.htm\\#establish"],
    \["{evaluate}", "26_glo_e.htm\\#evaluate"],
    \["{evaluation}", "26_glo_e.htm\\#evaluation"],
    \["{evaluation environment}", "26_glo_e.htm\\#evaluation_environment"],
    \["{execute}", "26_glo_e.htm\\#execute"],
    \["{execution time}", "26_glo_e.htm\\#execution_time"],
    \["{exhaustive partition}", "26_glo_e.htm\\#exhaustive_partition"],
    \["{exhaustive union}", "26_glo_e.htm\\#exhaustive_union"],
    \["{exit point}", "26_glo_e.htm\\#exit_point"],
    \["{explicit return}", "26_glo_e.htm\\#explicit_return"],
    \["{explicit use}", "26_glo_e.htm\\#explicit_use"],
    \["{exponent marker}", "26_glo_e.htm\\#exponent_marker"],
    \["{export}", "26_glo_e.htm\\#export"],
    \["{exported}", "26_glo_e.htm\\#exported"],
    \["{expressed adjustability}", "26_glo_e.htm\\#expressed_adjustability"],
    \["{expressed array element type}", "26_glo_e.htm\\#expressed_array_element_type"],
    \["{expressed complex part type}", "26_glo_e.htm\\#expressed_complex_part_type"],
    \["{expression}", "26_glo_e.htm\\#expression"],
    \["{expressly adjustable}", "26_glo_e.htm\\#expressly_adjustable"],
    \["{extended character}", "26_glo_e.htm\\#extended_character"],
    \["{extended function designator}", "26_glo_e.htm\\#extended_function_designator"],
    \["{extended lambda list}", "26_glo_e.htm\\#extended_lambda_list"],
    \["{extension}", "26_glo_e.htm\\#extension"],
    \["{extent}", "26_glo_e.htm\\#extent"],
    \["{external file format}", "26_glo_e.htm\\#external_file_format"],
    \["{external file format designator}", "26_glo_e.htm\\#external_file_format_designator"],
    \["{external symbol}", "26_glo_e.htm\\#external_symbol"],
    \["{externalizable object}", "26_glo_e.htm\\#externalizable_object"],
    \["{false}", "26_glo_f.htm\\#false"],
    \["{fbound}", "26_glo_f.htm\\#fbound"],
    \["{feature}", "26_glo_f.htm\\#feature"],
    \["{feature expression}", "26_glo_f.htm\\#feature_expression"],
    \["{features list}", "26_glo_f.htm\\#features_list"],
    \["{file}", "26_glo_f.htm\\#file"],
    \["{file compiler}", "26_glo_f.htm\\#file_compiler"],
    \["{file position}", "26_glo_f.htm\\#file_position"],
    \["{file position designator}", "26_glo_f.htm\\#file_position_designator"],
    \["{file stream}", "26_glo_f.htm\\#file_stream"],
    \["{file system}", "26_glo_f.htm\\#file_system"],
    \["{filename}", "26_glo_f.htm\\#filename"],
    \["{fill pointer}", "26_glo_f.htm\\#fill_pointer"],
    \["{finite}", "26_glo_f.htm\\#finite"],
    \["{fixnum}", "26_glo_f.htm\\#fixnum"],
    \["{float}", "26_glo_f.htm\\#float"],
    \["{for-value}", "26_glo_f.htm\\#for-value"],
    \["{form}", "26_glo_f.htm\\#form"],
    \["{formal argument}", "26_glo_f.htm\\#formal_argument"],
    \["{formal parameter}", "26_glo_f.htm\\#formal_parameter"],
    \["{format}", "26_glo_f.htm\\#format"],
    \["{format argument}", "26_glo_f.htm\\#format_argument"],
    \["{format control}", "26_glo_f.htm\\#format_control"],
    \["{format directive}", "26_glo_f.htm\\#format_directive"],
    \["{format string}", "26_glo_f.htm\\#format_string"],
    \["{free declaration}", "26_glo_f.htm\\#free_declaration"],
    \["{fresh}", "26_glo_f.htm\\#fresh"],
    \["{freshline}", "26_glo_f.htm\\#freshline"],
    \["{funbound}", "26_glo_f.htm\\#funbound"],
    \["{function}", "26_glo_f.htm\\#function"],
    \["{function block name}", "26_glo_f.htm\\#function_block_name"],
    \["{function cell}", "26_glo_f.htm\\#function_cell"],
    \["{function designator}", "26_glo_f.htm\\#function_designator"],
    \["{function form}", "26_glo_f.htm\\#function_form"],
    \["{function name}", "26_glo_f.htm\\#function_name"],
    \["{functional evaluation}", "26_glo_f.htm\\#functional_evaluation"],
    \["{functional value}", "26_glo_f.htm\\#functional_value"],
    \["{further compilation}", "26_glo_f.htm\\#further_compilation"],
    \["{general}", "26_glo_g.htm\\#general"],
    \["{generalized boolean}", "26_glo_g.htm\\#generalized_boolean"],
    \["{generalized instance}", "26_glo_g.htm\\#generalized_instance"],
    \["{generalized reference}", "26_glo_g.htm\\#generalized_reference"],
    \["{generalized synonym stream}", "26_glo_g.htm\\#generalized_synonym_stream"],
    \["{generic function}", "26_glo_g.htm\\#generic_function"],
    \["{generic function lambda list}", "26_glo_g.htm\\#generic_function_lambda_list"],
    \["{gensym}", "26_glo_g.htm\\#gensym"],
    \["{global declaration}", "26_glo_g.htm\\#global_declaration"],
    \["{global environment}", "26_glo_g.htm\\#global_environment"],
    \["{global variable}", "26_glo_g.htm\\#global_variable"],
    \["{glyph}", "26_glo_g.htm\\#glyph"],
    \["{go}", "26_glo_g.htm\\#go"],
    \["{go point}", "26_glo_g.htm\\#go_point"],
    \["{go tag}", "26_glo_g.htm\\#go_tag"],
    \["{graphic}", "26_glo_g.htm\\#graphic"],
    \["{handle}", "26_glo_h.htm\\#handle"],
    \["{handler}", "26_glo_h.htm\\#handler"],
    \["{hash table}", "26_glo_h.htm\\#hash_table"],
    \["{home package}", "26_glo_h.htm\\#home_package"],
    \["{I/O customization variable}", "26_glo_i.htm\\#iSLo_customization_variable"],
    \["{identical}", "26_glo_i.htm\\#identical"],
    \["{identifier}", "26_glo_i.htm\\#identifier"],
    \["{immutable}", "26_glo_i.htm\\#immutable"],
    \["{implementation}", "26_glo_i.htm\\#implementation"],
    \["{implementation limit}", "26_glo_i.htm\\#implementation_limit"],
    \["{implementation-defined}", "26_glo_i.htm\\#implementation-defined"],
    \["{implementation-dependent}", "26_glo_i.htm\\#implementation-dependent"],
    \["{implementation-independent}", "26_glo_i.htm\\#implementation-independent"],
    \["{implicit block}", "26_glo_i.htm\\#implicit_block"],
    \["{implicit compilation}", "26_glo_i.htm\\#implicit_compilation"],
    \["{implicit progn}", "26_glo_i.htm\\#implicit_progn"],
    \["{implicit tagbody}", "26_glo_i.htm\\#implicit_tagbody"],
    \["{import}", "26_glo_i.htm\\#import"],
    \["{improper list}", "26_glo_i.htm\\#improper_list"],
    \["{inaccessible}", "26_glo_i.htm\\#inaccessible"],
    \["{indefinite extent}", "26_glo_i.htm\\#indefinite_extent"],
    \["{indefinite scope}", "26_glo_i.htm\\#indefinite_scope"],
    \["{indicator}", "26_glo_i.htm\\#indicator"],
    \["{indirect instance}", "26_glo_i.htm\\#indirect_instance"],
    \["{inherit}", "26_glo_i.htm\\#inherit"],
    \["{initial pprint dispatch table}", "26_glo_i.htm\\#initial_pprint_dispatch_table"],
    \["{initial readtable}", "26_glo_i.htm\\#initial_readtable"],
    \["{initialization argument list}", "26_glo_i.htm\\#initialization_argument_list"],
    \["{initialization form}", "26_glo_i.htm\\#initialization_form"],
    \["{input}", "26_glo_i.htm\\#input"],
    \["{instance}", "26_glo_i.htm\\#instance"],
    \["{integer}", "26_glo_i.htm\\#integer"],
    \["{interactive stream}", "26_glo_i.htm\\#interactive_stream"],
    \["{intern}", "26_glo_i.htm\\#intern"],
    \["{internal symbol}", "26_glo_i.htm\\#internal_symbol"],
    \["{internal time}", "26_glo_i.htm\\#internal_time"],
    \["{internal time unit}", "26_glo_i.htm\\#internal_time_unit"],
    \["{interned}", "26_glo_i.htm\\#interned"],
    \["{interpreted function}", "26_glo_i.htm\\#interpreted_function"],
    \["{interpreted implementation}", "26_glo_i.htm\\#interpreted_implementation"],
    \["{interval designator}", "26_glo_i.htm\\#interval_designator"],
    \["{invalid}", "26_glo_i.htm\\#invalid"],
    \["{iteration form}", "26_glo_i.htm\\#iteration_form"],
    \["{iteration variable}", "26_glo_i.htm\\#iteration_variable"],
    \["{key}", "26_glo_k.htm\\#key"],
    \["{keyword}", "26_glo_k.htm\\#keyword"],
    \["{keyword parameter}", "26_glo_k.htm\\#keyword_parameter"],
    \["{keyword/value pair}", "26_glo_k.htm\\#keywordSLvalue_pair"],
    \["{lambda combination}", "26_glo_l.htm\\#lambda_combination"],
    \["{lambda expression}", "26_glo_l.htm\\#lambda_expression"],
    \["{lambda form}", "26_glo_l.htm\\#lambda_form"],
    \["{lambda list}", "26_glo_l.htm\\#lambda_list"],
    \["{lambda list keyword}", "26_glo_l.htm\\#lambda_list_keyword"],
    \["{lambda variable}", "26_glo_l.htm\\#lambda_variable"],
    \["{leaf}", "26_glo_l.htm\\#leaf"],
    \["{leap seconds}", "26_glo_l.htm\\#leap_seconds"],
    \["{left-parenthesis}", "26_glo_l.htm\\#left-parenthesis"],
    \["{length}", "26_glo_l.htm\\#length"],
    \["{lexical binding}", "26_glo_l.htm\\#lexical_binding"],
    \["{lexical closure}", "26_glo_l.htm\\#lexical_closure"],
    \["{lexical environment}", "26_glo_l.htm\\#lexical_environment"],
    \["{lexical scope}", "26_glo_l.htm\\#lexical_scope"],
    \["{lexical variable}", "26_glo_l.htm\\#lexical_variable"],
    \["{lisp image}", "26_glo_l.htm\\#lisp_image"],
    \["{lisp printer}", "26_glo_l.htm\\#lisp_printer"],
    \["{lisp read-eval-print loop}", "26_glo_l.htm\\#lisp_read-eval-print_loop"],
    \["{lisp reader}", "26_glo_l.htm\\#lisp_reader"],
    \["{list}", "26_glo_l.htm\\#list"],
    \["{list designator}", "26_glo_l.htm\\#list_designator"],
    \["{list structure}", "26_glo_l.htm\\#list_structure"],
    \["{literal}", "26_glo_l.htm\\#literal"],
    \["{load}", "26_glo_l.htm\\#load"],
    \["{load time}", "26_glo_l.htm\\#load_time"],
    \["{load time value}", "26_glo_l.htm\\#load_time_value"],
    \["{loader}", "26_glo_l.htm\\#loader"],
    \["{local declaration}", "26_glo_l.htm\\#local_declaration"],
    \["{local precedence order}", "26_glo_l.htm\\#local_precedence_order"],
    \["{local slot}", "26_glo_l.htm\\#local_slot"],
    \["{logical block}", "26_glo_l.htm\\#logical_block"],
    \["{logical host}", "26_glo_l.htm\\#logical_host"],
    \["{logical host designator}", "26_glo_l.htm\\#logical_host_designator"],
    \["{logical pathname}", "26_glo_l.htm\\#logical_pathname"],
    \["{long float}", "26_glo_l.htm\\#long_float"],
    \["{loop keyword}", "26_glo_l.htm\\#loop_keyword"],
    \["{lowercase}", "26_glo_l.htm\\#lowercase"],
    \["{macro}", "26_glo_m.htm\\#macro"],
    \["{macro character}", "26_glo_m.htm\\#macro_character"],
    \["{macro expansion}", "26_glo_m.htm\\#macro_expansion"],
    \["{macro form}", "26_glo_m.htm\\#macro_form"],
    \["{macro function}", "26_glo_m.htm\\#macro_function"],
    \["{macro lambda list}", "26_glo_m.htm\\#macro_lambda_list"],
    \["{macro name}", "26_glo_m.htm\\#macro_name"],
    \["{macroexpand hook}", "26_glo_m.htm\\#macroexpand_hook"],
    \["{mapping}", "26_glo_m.htm\\#mapping"],
    \["{metaclass}", "26_glo_m.htm\\#metaclass"],
    \["{metaobject protocol}", "26_glo_m.htm\\#metaobject_protocol"],
    \["{method}", "26_glo_m.htm\\#method"],
    \["{method combination}", "26_glo_m.htm\\#method_combination"],
    \["{method-defining form}", "26_glo_m.htm\\#method-defining_form"],
    \["{method-defining operator}", "26_glo_m.htm\\#method-defining_operator"],
    \["{minimal compilation}", "26_glo_m.htm\\#minimal_compilation"],
    \["{modified lambda list}", "26_glo_m.htm\\#modified_lambda_list"],
    \["{most recent}", "26_glo_m.htm\\#most_recent"],
    \["{multiple escape}", "26_glo_m.htm\\#multiple_escape"],
    \["{multiple values}", "26_glo_m.htm\\#multiple_values"],
    \["{name}", "26_glo_n.htm\\#name"],
    \["{named constant}", "26_glo_n.htm\\#named_constant"],
    \["{namespace}", "26_glo_n.htm\\#namespace"],
    \["{namestring}", "26_glo_n.htm\\#namestring"],
    \["{newline}", "26_glo_n.htm\\#newline"],
    \["{next method}", "26_glo_n.htm\\#next_method"],
    \["{nickname}", "26_glo_n.htm\\#nickname"],
    \["{nil}", "26_glo_n.htm\\#nil"],
    \["{non-atomic}", "26_glo_n.htm\\#non-atomic"],
    \["{non-constant variable}", "26_glo_n.htm\\#non-constant_variable"],
    \["{non-correctable}", "26_glo_n.htm\\#non-correctable"],
    \["{non-empty}", "26_glo_n.htm\\#non-empty"],
    \["{non-generic function}", "26_glo_n.htm\\#non-generic_function"],
    \["{non-graphic}", "26_glo_n.htm\\#non-graphic"],
    \["{non-list}", "26_glo_n.htm\\#non-list"],
    \["{non-local exit}", "26_glo_n.htm\\#non-local_exit"],
    \["{non-nil}", "26_glo_n.htm\\#non-nil"],
    \["{non-null lexical environment}", "26_glo_n.htm\\#non-null_lexical_environment"],
    \["{non-simple}", "26_glo_n.htm\\#non-simple"],
    \["{non-terminating}", "26_glo_n.htm\\#non-terminating"],
    \["{non-top-level form}", "26_glo_n.htm\\#non-top-level_form"],
    \["{normal return}", "26_glo_n.htm\\#normal_return"],
    \["{normalized}", "26_glo_n.htm\\#normalized"],
    \["{null}", "26_glo_n.htm\\#null"],
    \["{null lexical environment}", "26_glo_n.htm\\#null_lexical_environment"],
    \["{number}", "26_glo_n.htm\\#number"],
    \["{numeric}", "26_glo_n.htm\\#numeric"],
    \["{object}", "26_glo_o.htm\\#object"],
    \["{object-traversing}", "26_glo_o.htm\\#object-traversing"],
    \["{open}", "26_glo_o.htm\\#open"],
    \["{operator}", "26_glo_o.htm\\#operator"],
    \["{optimize quality}", "26_glo_o.htm\\#optimize_quality"],
    \["{optional parameter}", "26_glo_o.htm\\#optional_parameter"],
    \["{ordinary function}", "26_glo_o.htm\\#ordinary_function"],
    \["{ordinary lambda list}", "26_glo_o.htm\\#ordinary_lambda_list"],
    \["{otherwise inaccessible part}", "26_glo_o.htm\\#otherwise_inaccessible_part"],
    \["{output}", "26_glo_o.htm\\#output"],
    \["{package}", "26_glo_p.htm\\#package"],
    \["{package cell}", "26_glo_p.htm\\#package_cell"],
    \["{package designator}", "26_glo_p.htm\\#package_designator"],
    \["{package marker}", "26_glo_p.htm\\#package_marker"],
    \["{package prefix}", "26_glo_p.htm\\#package_prefix"],
    \["{package registry}", "26_glo_p.htm\\#package_registry"],
    \["{pairwise}", "26_glo_p.htm\\#pairwise"],
    \["{parallel}", "26_glo_p.htm\\#parallel"],
    \["{parameter}", "26_glo_p.htm\\#parameter"],
    \["{parameter specializer}", "26_glo_p.htm\\#parameter_specializer"],
    \["{parameter specializer name}", "26_glo_p.htm\\#parameter_specializer_name"],
    \["{pathname}", "26_glo_p.htm\\#pathname"],
    \["{pathname designator}", "26_glo_p.htm\\#pathname_designator"],
    \["{physical pathname}", "26_glo_p.htm\\#physical_pathname"],
    \["{place}", "26_glo_p.htm\\#place"],
    \["{plist}", "26_glo_p.htm\\#plist"],
    \["{portable}", "26_glo_p.htm\\#portable"],
    \["{potential copy}", "26_glo_p.htm\\#potential_copy"],
    \["{potential number}", "26_glo_p.htm\\#potential_number"],
    \["{pprint dispatch table}", "26_glo_p.htm\\#pprint_dispatch_table"],
    \["{predicate}", "26_glo_p.htm\\#predicate"],
    \["{present}", "26_glo_p.htm\\#present"],
    \["{pretty print}", "26_glo_p.htm\\#pretty_print"],
    \["{pretty printer}", "26_glo_p.htm\\#pretty_printer"],
    \["{pretty printing stream}", "26_glo_p.htm\\#pretty_printing_stream"],
    \["{primary method}", "26_glo_p.htm\\#primary_method"],
    \["{primary value}", "26_glo_p.htm\\#primary_value"],
    \["{principal}", "26_glo_p.htm\\#principal"],
    \["{print name}", "26_glo_p.htm\\#print_name"],
    \["{printer control variable}", "26_glo_p.htm\\#printer_control_variable"],
    \["{printer escaping}", "26_glo_p.htm\\#printer_escaping"],
    \["{printing}", "26_glo_p.htm\\#printing"],
    \["{process}", "26_glo_p.htm\\#process"],
    \["{processor}", "26_glo_p.htm\\#processor"],
    \["{proclaim}", "26_glo_p.htm\\#proclaim"],
    \["{proclamation}", "26_glo_p.htm\\#proclamation"],
    \["{prog tag}", "26_glo_p.htm\\#prog_tag"],
    \["{program}", "26_glo_p.htm\\#program"],
    \["{programmer}", "26_glo_p.htm\\#programmer"],
    \["{programmer code}", "26_glo_p.htm\\#programmer_code"],
    \["{proper list}", "26_glo_p.htm\\#proper_list"],
    \["{proper name}", "26_glo_p.htm\\#proper_name"],
    \["{proper sequence}", "26_glo_p.htm\\#proper_sequence"],
    \["{proper subtype}", "26_glo_p.htm\\#proper_subtype"],
    \["{property}", "26_glo_p.htm\\#property"],
    \["{property indicator}", "26_glo_p.htm\\#property_indicator"],
    \["{property list}", "26_glo_p.htm\\#property_list"],
    \["{property value}", "26_glo_p.htm\\#property_value"],
    \["{purports to conform}", "26_glo_p.htm\\#purports_to_conform"],
    \["{qualified method}", "26_glo_q.htm\\#qualified_method"],
    \["{qualifier}", "26_glo_q.htm\\#qualifier"],
    \["{query I/O}", "26_glo_q.htm\\#query_iSLo"],
    \["{quoted object}", "26_glo_q.htm\\#quoted_object"],
    \["{radix}", "26_glo_r.htm\\#radix"],
    \["{random state}", "26_glo_r.htm\\#random_state"],
    \["{rank}", "26_glo_r.htm\\#rank"],
    \["{ratio}", "26_glo_r.htm\\#ratio"],
    \["{ratio marker}", "26_glo_r.htm\\#ratio_marker"],
    \["{rational}", "26_glo_r.htm\\#rational"],
    \["{read}", "26_glo_r.htm\\#read"],
    \["{readably}", "26_glo_r.htm\\#readably"],
    \["{reader}", "26_glo_r.htm\\#reader"],
    \["{reader macro}", "26_glo_r.htm\\#reader_macro"],
    \["{reader macro function}", "26_glo_r.htm\\#reader_macro_function"],
    \["{readtable}", "26_glo_r.htm\\#readtable"],
    \["{readtable case}", "26_glo_r.htm\\#readtable_case"],
    \["{readtable designator}", "26_glo_r.htm\\#readtable_designator"],
    \["{recognizable subtype}", "26_glo_r.htm\\#recognizable_subtype"],
    \["{reference}", "26_glo_r.htm\\#reference"],
    \["{registered package}", "26_glo_r.htm\\#registered_package"],
    \["{relative}", "26_glo_r.htm\\#relative"],
    \["{repertoire}", "26_glo_r.htm\\#repertoire"],
    \["{report}", "26_glo_r.htm\\#report"],
    \["{report message}", "26_glo_r.htm\\#report_message"],
    \["{required parameter}", "26_glo_r.htm\\#required_parameter"],
    \["{rest list}", "26_glo_r.htm\\#rest_list"],
    \["{rest parameter}", "26_glo_r.htm\\#rest_parameter"],
    \["{restart}", "26_glo_r.htm\\#restart"],
    \["{restart designator}", "26_glo_r.htm\\#restart_designator"],
    \["{restart function}", "26_glo_r.htm\\#restart_function"],
    \["{return}", "26_glo_r.htm\\#return"],
    \["{return value}", "26_glo_r.htm\\#return_value"],
    \["{right-parenthesis}", "26_glo_r.htm\\#right-parenthesis"],
    \["{run time}", "26_glo_r.htm\\#run_time"],
    \["{run-time compiler}", "26_glo_r.htm\\#run-time_compiler"],
    \["{run-time definition}", "26_glo_r.htm\\#run-time_definition"],
    \["{run-time environment}", "26_glo_r.htm\\#run-time_environment"],
    \["{safe}", "26_glo_s.htm\\#safe"],
    \["{safe call}", "26_glo_s.htm\\#safe_call"],
    \["{same}", "26_glo_s.htm\\#same"],
    \["{satisfy the test}", "26_glo_s.htm\\#satisfy_the_test"],
    \["{scope}", "26_glo_s.htm\\#scope"],
    \["{script}", "26_glo_s.htm\\#script"],
    \["{secondary value}", "26_glo_s.htm\\#secondary_value"],
    \["{section}", "26_glo_s.htm\\#section"],
    \["{self-evaluating object}", "26_glo_s.htm\\#self-evaluating_object"],
    \["{semi-standard}", "26_glo_s.htm\\#semi-standard"],
    \["{semicolon}", "26_glo_s.htm\\#semicolon"],
    \["{sequence}", "26_glo_s.htm\\#sequence"],
    \["{sequence function}", "26_glo_s.htm\\#sequence_function"],
    \["{sequential}", "26_glo_s.htm\\#sequential"],
    \["{sequentially}", "26_glo_s.htm\\#sequentially"],
    \["{serious condition}", "26_glo_s.htm\\#serious_condition"],
    \["{session}", "26_glo_s.htm\\#session"],
    \["{set}", "26_glo_s.htm\\#set"],
    \["{setf expander}", "26_glo_s.htm\\#setf_expander"],
    \["{setf expansion}", "26_glo_s.htm\\#setf_expansion"],
    \["{setf function}", "26_glo_s.htm\\#setf_function"],
    \["{setf function name}", "26_glo_s.htm\\#setf_function_name"],
    \["{shadow}", "26_glo_s.htm\\#shadow"],
    \["{shadowing symbol}", "26_glo_s.htm\\#shadowing_symbol"],
    \["{shadowing symbols list}", "26_glo_s.htm\\#shadowing_symbols_list"],
    \["{shared slot}", "26_glo_s.htm\\#shared_slot"],
    \["{sharpsign}", "26_glo_s.htm\\#sharpsign"],
    \["{short float}", "26_glo_s.htm\\#short_float"],
    \["{sign}", "26_glo_s.htm\\#sign"],
    \["{signal}", "26_glo_s.htm\\#signal"],
    \["{signature}", "26_glo_s.htm\\#signature"],
    \["{similar}", "26_glo_s.htm\\#similar"],
    \["{similarity}", "26_glo_s.htm\\#similarity"],
    \["{simple}", "26_glo_s.htm\\#simple"],
    \["{simple array}", "26_glo_s.htm\\#simple_array"],
    \["{simple bit array}", "26_glo_s.htm\\#simple_bit_array"],
    \["{simple bit vector}", "26_glo_s.htm\\#simple_bit_vector"],
    \["{simple condition}", "26_glo_s.htm\\#simple_condition"],
    \["{simple general vector}", "26_glo_s.htm\\#simple_general_vector"],
    \["{simple string}", "26_glo_s.htm\\#simple_string"],
    \["{simple vector}", "26_glo_s.htm\\#simple_vector"],
    \["{single escape}", "26_glo_s.htm\\#single_escape"],
    \["{single float}", "26_glo_s.htm\\#single_float"],
    \["{single-quote}", "26_glo_s.htm\\#single-quote"],
    \["{singleton}", "26_glo_s.htm\\#singleton"],
    \["{situation}", "26_glo_s.htm\\#situation"],
    \["{slash}", "26_glo_s.htm\\#slash"],
    \["{slot}", "26_glo_s.htm\\#slot"],
    \["{slot specifier}", "26_glo_s.htm\\#slot_specifier"],
    \["{source code}", "26_glo_s.htm\\#source_code"],
    \["{source file}", "26_glo_s.htm\\#source_file"],
    \["{space}", "26_glo_s.htm\\#space"],
    \["{special form}", "26_glo_s.htm\\#special_form"],
    \["{special operator}", "26_glo_s.htm\\#special_operator"],
    \["{special variable}", "26_glo_s.htm\\#special_variable"],
    \["{specialize}", "26_glo_s.htm\\#specialize"],
    \["{specialized}", "26_glo_s.htm\\#specialized"],
    \["{specialized lambda list}", "26_glo_s.htm\\#specialized_lambda_list"],
    \["{spreadable argument list designator}", "26_glo_s.htm\\#spreadable_argument_list_designator"],
    \["{stack allocate}", "26_glo_s.htm\\#stack_allocate"],
    \["{stack-allocated}", "26_glo_s.htm\\#stack-allocated"],
    \["{standard character}", "26_glo_s.htm\\#standard_character"],
    \["{standard class}", "26_glo_s.htm\\#standard_class"],
    \["{standard generic function}", "26_glo_s.htm\\#standard_generic_function"],
    \["{standard input}", "26_glo_s.htm\\#standard_input"],
    \["{standard method combination}", "26_glo_s.htm\\#standard_method_combination"],
    \["{standard object}", "26_glo_s.htm\\#standard_object"],
    \["{standard output}", "26_glo_s.htm\\#standard_output"],
    \["{standard pprint dispatch table}", "26_glo_s.htm\\#standard_pprint_dispatch_table"],
    \["{standard readtable}", "26_glo_s.htm\\#standard_readtable"],
    \["{standard syntax}", "26_glo_s.htm\\#standard_syntax"],
    \["{standardized}", "26_glo_s.htm\\#standardized"],
    \["{startup environment}", "26_glo_s.htm\\#startup_environment"],
    \["{step}", "26_glo_s.htm\\#step"],
    \["{stream}", "26_glo_s.htm\\#stream"],
    \["{stream associated with a file}", "26_glo_s.htm\\#stream_associated_with_a_file"],
    \["{stream designator}", "26_glo_s.htm\\#stream_designator"],
    \["{stream element type}", "26_glo_s.htm\\#stream_element_type"],
    \["{stream variable}", "26_glo_s.htm\\#stream_variable"],
    \["{stream variable designator}", "26_glo_s.htm\\#stream_variable_designator"],
    \["{string}", "26_glo_s.htm\\#string"],
    \["{string designator}", "26_glo_s.htm\\#string_designator"],
    \["{string equal}", "26_glo_s.htm\\#string_equal"],
    \["{string stream}", "26_glo_s.htm\\#string_stream"],
    \["{structure}", "26_glo_s.htm\\#structure"],
    \["{structure class}", "26_glo_s.htm\\#structure_class"],
    \["{structure name}", "26_glo_s.htm\\#structure_name"],
    \["{style warning}", "26_glo_s.htm\\#style_warning"],
    \["{subclass}", "26_glo_s.htm\\#subclass"],
    \["{subexpression}", "26_glo_s.htm\\#subexpression"],
    \["{subform}", "26_glo_s.htm\\#subform"],
    \["{subrepertoire}", "26_glo_s.htm\\#subrepertoire"],
    \["{subtype}", "26_glo_s.htm\\#subtype"],
    \["{superclass}", "26_glo_s.htm\\#superclass"],
    \["{supertype}", "26_glo_s.htm\\#supertype"],
    \["{supplied-p parameter}", "26_glo_s.htm\\#supplied-p_parameter"],
    \["{symbol}", "26_glo_s.htm\\#symbol"],
    \["{symbol macro}", "26_glo_s.htm\\#symbol_macro"],
    \["{synonym stream}", "26_glo_s.htm\\#synonym_stream"],
    \["{synonym stream symbol}", "26_glo_s.htm\\#synonym_stream_symbol"],
    \["{syntax type}", "26_glo_s.htm\\#syntax_type"],
    \["{system class}", "26_glo_s.htm\\#system_class"],
    \["{system code}", "26_glo_s.htm\\#system_code"],
    \["{t}", "26_glo_t.htm\\#t"],
    \["{tag}", "26_glo_t.htm\\#tag"],
    \["{tail}", "26_glo_t.htm\\#tail"],
    \["{target}", "26_glo_t.htm\\#target"],
    \["{terminal I/O}", "26_glo_t.htm\\#terminal_iSLo"],
    \["{terminating}", "26_glo_t.htm\\#terminating"],
    \["{tertiary value}", "26_glo_t.htm\\#tertiary_value"],
    \["{throw}", "26_glo_t.htm\\#throw"],
    \["{tilde}", "26_glo_t.htm\\#tilde"],
    \["{time}", "26_glo_t.htm\\#time"],
    \["{time zone}", "26_glo_t.htm\\#time_zone"],
    \["{token}", "26_glo_t.htm\\#token"],
    \["{top level form}", "26_glo_t.htm\\#top_level_form"],
    \["{trace output}", "26_glo_t.htm\\#trace_output"],
    \["{tree}", "26_glo_t.htm\\#tree"],
    \["{tree structure}", "26_glo_t.htm\\#tree_structure"],
    \["{true}", "26_glo_t.htm\\#true"],
    \["{truename}", "26_glo_t.htm\\#truename"],
    \["{two-way stream}", "26_glo_t.htm\\#two-way_stream"],
    \["{type}", "26_glo_t.htm\\#type"],
    \["{type declaration}", "26_glo_t.htm\\#type_declaration"],
    \["{type equivalent}", "26_glo_t.htm\\#type_equivalent"],
    \["{type expand}", "26_glo_t.htm\\#type_expand"],
    \["{type specifier}", "26_glo_t.htm\\#type_specifier"],
    \["{unbound}", "26_glo_u.htm\\#unbound"],
    \["{unbound variable}", "26_glo_u.htm\\#unbound_variable"],
    \["{undefined function}", "26_glo_u.htm\\#undefined_function"],
    \["{unintern}", "26_glo_u.htm\\#unintern"],
    \["{uninterned}", "26_glo_u.htm\\#uninterned"],
    \["{universal time}", "26_glo_u.htm\\#universal_time"],
    \["{unqualified method}", "26_glo_u.htm\\#unqualified_method"],
    \["{unregistered package}", "26_glo_u.htm\\#unregistered_package"],
    \["{unsafe}", "26_glo_u.htm\\#unsafe"],
    \["{unsafe call}", "26_glo_u.htm\\#unsafe_call"],
    \["{upgrade}", "26_glo_u.htm\\#upgrade"],
    \["{upgraded array element type}", "26_glo_u.htm\\#upgraded_array_element_type"],
    \["{upgraded complex part type}", "26_glo_u.htm\\#upgraded_complex_part_type"],
    \["{uppercase}", "26_glo_u.htm\\#uppercase"],
    \["{use}", "26_glo_u.htm\\#use"],
    \["{use list}", "26_glo_u.htm\\#use_list"],
    \["{user}", "26_glo_u.htm\\#user"],
    \["{valid array dimension}", "26_glo_v.htm\\#valid_array_dimension"],
    \["{valid array index}", "26_glo_v.htm\\#valid_array_index"],
    \["{valid array row-major index}", "26_glo_v.htm\\#valid_array_row-major_index"],
    \["{valid fill pointer}", "26_glo_v.htm\\#valid_fill_pointer"],
    \["{valid logical pathname host}", "26_glo_v.htm\\#valid_logical_pathname_host"],
    \["{valid pathname device}", "26_glo_v.htm\\#valid_pathname_device"],
    \["{valid pathname directory}", "26_glo_v.htm\\#valid_pathname_directory"],
    \["{valid pathname host}", "26_glo_v.htm\\#valid_pathname_host"],
    \["{valid pathname name}", "26_glo_v.htm\\#valid_pathname_name"],
    \["{valid pathname type}", "26_glo_v.htm\\#valid_pathname_type"],
    \["{valid pathname version}", "26_glo_v.htm\\#valid_pathname_version"],
    \["{valid physical pathname host}", "26_glo_v.htm\\#valid_physical_pathname_host"],
    \["{valid sequence index}", "26_glo_v.htm\\#valid_sequence_index"],
    \["{value}", "26_glo_v.htm\\#value"],
    \["{value cell}", "26_glo_v.htm\\#value_cell"],
    \["{variable}", "26_glo_v.htm\\#variable"],
    \["{vector}", "26_glo_v.htm\\#vector"],
    \["{vertical-bar}", "26_glo_v.htm\\#vertical-bar"],
    \["{whitespace}", "26_glo_w.htm\\#whitespace"],
    \["{wild}", "26_glo_w.htm\\#wild"],
    \["{write}", "26_glo_w.htm\\#write"],
    \["{writer}", "26_glo_w.htm\\#writer"],
    \["{yield}", "26_glo_y.htm\\#yield"]]
endif

