" slimv-cljapi.vim:
"               Clojure API lookup support for Slimv
" Version:      0.9.6
" Last Change:  12 Mar 2012
" Maintainer:   Tamas Kovacs <kovisoft at gmail dot com>
" License:      This file is placed in the public domain.
"               No warranty, express or implied.
"               *** ***   Use At-Your-Own-Risk!   *** ***
"
" =====================================================================
"
"  Load Once:
if &cp || exists( 'g:slimv_cljapi_loaded' )
    finish
endif

let g:slimv_cljapi_loaded = 1

" Root of the Clojure API
if !exists( 'g:slimv_cljapi_root' )
    let g:slimv_cljapi_root = 'http://clojure.github.com/clojure/'
endif
 
if !exists( 'g:slimv_cljapi_db' )
    let g:slimv_cljapi_db = [
    \["*", "clojure.core-api.html\\#clojure.core/*"],
    \["*'", "clojure.core-api.html\\#clojure.core/*'"],
    \["*1", "clojure.core-api.html\\#clojure.core/*1"],
    \["*2", "clojure.core-api.html\\#clojure.core/*2"],
    \["*3", "clojure.core-api.html\\#clojure.core/*3"],
    \["*agent*", "clojure.core-api.html\\#clojure.core/*agent*"],
    \["*clojure-version*", "clojure.core-api.html\\#clojure.core/*clojure-version*"],
    \["*command-line-args*", "clojure.core-api.html\\#clojure.core/*command-line-args*"],
    \["*compile-files*", "clojure.core-api.html\\#clojure.core/*compile-files*"],
    \["*compile-path*", "clojure.core-api.html\\#clojure.core/*compile-path*"],
    \["*e", "clojure.core-api.html\\#clojure.core/*e"],
    \["*err*", "clojure.core-api.html\\#clojure.core/*err*"],
    \["*file*", "clojure.core-api.html\\#clojure.core/*file*"],
    \["*flush-on-newline*", "clojure.core-api.html\\#clojure.core/*flush-on-newline*"],
    \["*in*", "clojure.core-api.html\\#clojure.core/*in*"],
    \["*ns*", "clojure.core-api.html\\#clojure.core/*ns*"],
    \["*out*", "clojure.core-api.html\\#clojure.core/*out*"],
    \["*print-dup*", "clojure.core-api.html\\#clojure.core/*print-dup*"],
    \["*print-length*", "clojure.core-api.html\\#clojure.core/*print-length*"],
    \["*print-level*", "clojure.core-api.html\\#clojure.core/*print-level*"],
    \["*print-meta*", "clojure.core-api.html\\#clojure.core/*print-meta*"],
    \["*print-readably*", "clojure.core-api.html\\#clojure.core/*print-readably*"],
    \["*read-eval*", "clojure.core-api.html\\#clojure.core/*read-eval*"],
    \["*unchecked-math*", "clojure.core-api.html\\#clojure.core/*unchecked-math*"],
    \["*warn-on-reflection*", "clojure.core-api.html\\#clojure.core/*warn-on-reflection*"],
    \["+", "clojure.core-api.html\\#clojure.core/+"],
    \["+'", "clojure.core-api.html\\#clojure.core/+'"],
    \["-", "clojure.core-api.html\\#clojure.core/-"],
    \["-'", "clojure.core-api.html\\#clojure.core/-'"],
    \["->", "clojure.core-api.html\\#clojure.core/->"],
    \["->>", "clojure.core-api.html\\#clojure.core/->>"],
    \["..", "clojure.core-api.html\\#clojure.core/.."],
    \["/", "clojure.core-api.html\\#clojure.core//"],
    \["<", "clojure.core-api.html\\#clojure.core/<"],
    \["<=", "clojure.core-api.html\\#clojure.core/<="],
    \["=", "clojure.core-api.html\\#clojure.core/="],
    \["==", "clojure.core-api.html\\#clojure.core/=="],
    \[">", "clojure.core-api.html\\#clojure.core/>"],
    \[">=", "clojure.core-api.html\\#clojure.core/>="],
    \["accessor", "clojure.core-api.html\\#clojure.core/accessor"],
    \["aclone", "clojure.core-api.html\\#clojure.core/aclone"],
    \["add-classpath", "clojure.core-api.html\\#clojure.core/add-classpath"],
    \["add-watch", "clojure.core-api.html\\#clojure.core/add-watch"],
    \["agent", "clojure.core-api.html\\#clojure.core/agent"],
    \["agent-error", "clojure.core-api.html\\#clojure.core/agent-error"],
    \["agent-errors", "clojure.core-api.html\\#clojure.core/agent-errors"],
    \["aget", "clojure.core-api.html\\#clojure.core/aget"],
    \["alength", "clojure.core-api.html\\#clojure.core/alength"],
    \["alias", "clojure.core-api.html\\#clojure.core/alias"],
    \["all-ns", "clojure.core-api.html\\#clojure.core/all-ns"],
    \["alter", "clojure.core-api.html\\#clojure.core/alter"],
    \["alter-meta!", "clojure.core-api.html\\#clojure.core/alter-meta!"],
    \["alter-var-root", "clojure.core-api.html\\#clojure.core/alter-var-root"],
    \["amap", "clojure.core-api.html\\#clojure.core/amap"],
    \["ancestors", "clojure.core-api.html\\#clojure.core/ancestors"],
    \["and", "clojure.core-api.html\\#clojure.core/and"],
    \["apply", "clojure.core-api.html\\#clojure.core/apply"],
    \["areduce", "clojure.core-api.html\\#clojure.core/areduce"],
    \["array-map", "clojure.core-api.html\\#clojure.core/array-map"],
    \["aset", "clojure.core-api.html\\#clojure.core/aset"],
    \["aset-boolean", "clojure.core-api.html\\#clojure.core/aset-boolean"],
    \["aset-byte", "clojure.core-api.html\\#clojure.core/aset-byte"],
    \["aset-char", "clojure.core-api.html\\#clojure.core/aset-char"],
    \["aset-double", "clojure.core-api.html\\#clojure.core/aset-double"],
    \["aset-float", "clojure.core-api.html\\#clojure.core/aset-float"],
    \["aset-int", "clojure.core-api.html\\#clojure.core/aset-int"],
    \["aset-long", "clojure.core-api.html\\#clojure.core/aset-long"],
    \["aset-short", "clojure.core-api.html\\#clojure.core/aset-short"],
    \["assert", "clojure.core-api.html\\#clojure.core/assert"],
    \["assoc", "clojure.core-api.html\\#clojure.core/assoc"],
    \["assoc!", "clojure.core-api.html\\#clojure.core/assoc!"],
    \["assoc-in", "clojure.core-api.html\\#clojure.core/assoc-in"],
    \["associative?", "clojure.core-api.html\\#clojure.core/associative?"],
    \["atom", "clojure.core-api.html\\#clojure.core/atom"],
    \["await", "clojure.core-api.html\\#clojure.core/await"],
    \["await-for", "clojure.core-api.html\\#clojure.core/await-for"],
    \["bases", "clojure.core-api.html\\#clojure.core/bases"],
    \["bean", "clojure.core-api.html\\#clojure.core/bean"],
    \["bigdec", "clojure.core-api.html\\#clojure.core/bigdec"],
    \["bigint", "clojure.core-api.html\\#clojure.core/bigint"],
    \["biginteger", "clojure.core-api.html\\#clojure.core/biginteger"],
    \["binding", "clojure.core-api.html\\#clojure.core/binding"],
    \["bit-and", "clojure.core-api.html\\#clojure.core/bit-and"],
    \["bit-and-not", "clojure.core-api.html\\#clojure.core/bit-and-not"],
    \["bit-clear", "clojure.core-api.html\\#clojure.core/bit-clear"],
    \["bit-flip", "clojure.core-api.html\\#clojure.core/bit-flip"],
    \["bit-not", "clojure.core-api.html\\#clojure.core/bit-not"],
    \["bit-or", "clojure.core-api.html\\#clojure.core/bit-or"],
    \["bit-set", "clojure.core-api.html\\#clojure.core/bit-set"],
    \["bit-shift-left", "clojure.core-api.html\\#clojure.core/bit-shift-left"],
    \["bit-shift-right", "clojure.core-api.html\\#clojure.core/bit-shift-right"],
    \["bit-test", "clojure.core-api.html\\#clojure.core/bit-test"],
    \["bit-xor", "clojure.core-api.html\\#clojure.core/bit-xor"],
    \["boolean", "clojure.core-api.html\\#clojure.core/boolean"],
    \["boolean-array", "clojure.core-api.html\\#clojure.core/boolean-array"],
    \["booleans", "clojure.core-api.html\\#clojure.core/booleans"],
    \["bound-fn", "clojure.core-api.html\\#clojure.core/bound-fn"],
    \["bound-fn*", "clojure.core-api.html\\#clojure.core/bound-fn*"],
    \["bound?", "clojure.core-api.html\\#clojure.core/bound?"],
    \["butlast", "clojure.core-api.html\\#clojure.core/butlast"],
    \["byte", "clojure.core-api.html\\#clojure.core/byte"],
    \["byte-array", "clojure.core-api.html\\#clojure.core/byte-array"],
    \["bytes", "clojure.core-api.html\\#clojure.core/bytes"],
    \["case", "clojure.core-api.html\\#clojure.core/case"],
    \["cast", "clojure.core-api.html\\#clojure.core/cast"],
    \["char", "clojure.core-api.html\\#clojure.core/char"],
    \["char-array", "clojure.core-api.html\\#clojure.core/char-array"],
    \["char-escape-string", "clojure.core-api.html\\#clojure.core/char-escape-string"],
    \["char-name-string", "clojure.core-api.html\\#clojure.core/char-name-string"],
    \["char?", "clojure.core-api.html\\#clojure.core/char?"],
    \["chars", "clojure.core-api.html\\#clojure.core/chars"],
    \["class", "clojure.core-api.html\\#clojure.core/class"],
    \["class?", "clojure.core-api.html\\#clojure.core/class?"],
    \["clear-agent-errors", "clojure.core-api.html\\#clojure.core/clear-agent-errors"],
    \["clojure-version", "clojure.core-api.html\\#clojure.core/clojure-version"],
    \["coll?", "clojure.core-api.html\\#clojure.core/coll?"],
    \["comment", "clojure.core-api.html\\#clojure.core/comment"],
    \["commute", "clojure.core-api.html\\#clojure.core/commute"],
    \["comp", "clojure.core-api.html\\#clojure.core/comp"],
    \["comparator", "clojure.core-api.html\\#clojure.core/comparator"],
    \["compare", "clojure.core-api.html\\#clojure.core/compare"],
    \["compare-and-set!", "clojure.core-api.html\\#clojure.core/compare-and-set!"],
    \["compile", "clojure.core-api.html\\#clojure.core/compile"],
    \["complement", "clojure.core-api.html\\#clojure.core/complement"],
    \["concat", "clojure.core-api.html\\#clojure.core/concat"],
    \["cond", "clojure.core-api.html\\#clojure.core/cond"],
    \["condp", "clojure.core-api.html\\#clojure.core/condp"],
    \["conj", "clojure.core-api.html\\#clojure.core/conj"],
    \["conj!", "clojure.core-api.html\\#clojure.core/conj!"],
    \["cons", "clojure.core-api.html\\#clojure.core/cons"],
    \["constantly", "clojure.core-api.html\\#clojure.core/constantly"],
    \["construct-proxy", "clojure.core-api.html\\#clojure.core/construct-proxy"],
    \["contains?", "clojure.core-api.html\\#clojure.core/contains?"],
    \["count", "clojure.core-api.html\\#clojure.core/count"],
    \["counted?", "clojure.core-api.html\\#clojure.core/counted?"],
    \["create-ns", "clojure.core-api.html\\#clojure.core/create-ns"],
    \["create-struct", "clojure.core-api.html\\#clojure.core/create-struct"],
    \["cycle", "clojure.core-api.html\\#clojure.core/cycle"],
    \["dec", "clojure.core-api.html\\#clojure.core/dec"],
    \["dec'", "clojure.core-api.html\\#clojure.core/dec'"],
    \["decimal?", "clojure.core-api.html\\#clojure.core/decimal?"],
    \["declare", "clojure.core-api.html\\#clojure.core/declare"],
    \["definline", "clojure.core-api.html\\#clojure.core/definline"],
    \["defmacro", "clojure.core-api.html\\#clojure.core/defmacro"],
    \["defmethod", "clojure.core-api.html\\#clojure.core/defmethod"],
    \["defmulti", "clojure.core-api.html\\#clojure.core/defmulti"],
    \["defn", "clojure.core-api.html\\#clojure.core/defn"],
    \["defn-", "clojure.core-api.html\\#clojure.core/defn-"],
    \["defonce", "clojure.core-api.html\\#clojure.core/defonce"],
    \["defprotocol", "clojure.core-api.html\\#clojure.core/defprotocol"],
    \["defrecord", "clojure.core-api.html\\#clojure.core/defrecord"],
    \["defstruct", "clojure.core-api.html\\#clojure.core/defstruct"],
    \["deftype", "clojure.core-api.html\\#clojure.core/deftype"],
    \["delay", "clojure.core-api.html\\#clojure.core/delay"],
    \["delay?", "clojure.core-api.html\\#clojure.core/delay?"],
    \["deliver", "clojure.core-api.html\\#clojure.core/deliver"],
    \["denominator", "clojure.core-api.html\\#clojure.core/denominator"],
    \["deref", "clojure.core-api.html\\#clojure.core/deref"],
    \["derive", "clojure.core-api.html\\#clojure.core/derive"],
    \["descendants", "clojure.core-api.html\\#clojure.core/descendants"],
    \["disj", "clojure.core-api.html\\#clojure.core/disj"],
    \["disj!", "clojure.core-api.html\\#clojure.core/disj!"],
    \["dissoc", "clojure.core-api.html\\#clojure.core/dissoc"],
    \["dissoc!", "clojure.core-api.html\\#clojure.core/dissoc!"],
    \["distinct", "clojure.core-api.html\\#clojure.core/distinct"],
    \["distinct?", "clojure.core-api.html\\#clojure.core/distinct?"],
    \["doall", "clojure.core-api.html\\#clojure.core/doall"],
    \["dorun", "clojure.core-api.html\\#clojure.core/dorun"],
    \["doseq", "clojure.core-api.html\\#clojure.core/doseq"],
    \["dosync", "clojure.core-api.html\\#clojure.core/dosync"],
    \["dotimes", "clojure.core-api.html\\#clojure.core/dotimes"],
    \["doto", "clojure.core-api.html\\#clojure.core/doto"],
    \["double", "clojure.core-api.html\\#clojure.core/double"],
    \["double-array", "clojure.core-api.html\\#clojure.core/double-array"],
    \["doubles", "clojure.core-api.html\\#clojure.core/doubles"],
    \["drop", "clojure.core-api.html\\#clojure.core/drop"],
    \["drop-last", "clojure.core-api.html\\#clojure.core/drop-last"],
    \["drop-while", "clojure.core-api.html\\#clojure.core/drop-while"],
    \["empty", "clojure.core-api.html\\#clojure.core/empty"],
    \["empty?", "clojure.core-api.html\\#clojure.core/empty?"],
    \["ensure", "clojure.core-api.html\\#clojure.core/ensure"],
    \["enumeration-seq", "clojure.core-api.html\\#clojure.core/enumeration-seq"],
    \["error-handler", "clojure.core-api.html\\#clojure.core/error-handler"],
    \["error-mode", "clojure.core-api.html\\#clojure.core/error-mode"],
    \["eval", "clojure.core-api.html\\#clojure.core/eval"],
    \["even?", "clojure.core-api.html\\#clojure.core/even?"],
    \["every-pred", "clojure.core-api.html\\#clojure.core/every-pred"],
    \["every?", "clojure.core-api.html\\#clojure.core/every?"],
    \["extend", "clojure.core-api.html\\#clojure.core/extend"],
    \["extend-protocol", "clojure.core-api.html\\#clojure.core/extend-protocol"],
    \["extend-type", "clojure.core-api.html\\#clojure.core/extend-type"],
    \["extenders", "clojure.core-api.html\\#clojure.core/extenders"],
    \["extends?", "clojure.core-api.html\\#clojure.core/extends?"],
    \["false?", "clojure.core-api.html\\#clojure.core/false?"],
    \["ffirst", "clojure.core-api.html\\#clojure.core/ffirst"],
    \["file-seq", "clojure.core-api.html\\#clojure.core/file-seq"],
    \["filter", "clojure.core-api.html\\#clojure.core/filter"],
    \["find", "clojure.core-api.html\\#clojure.core/find"],
    \["find-keyword", "clojure.core-api.html\\#clojure.core/find-keyword"],
    \["find-ns", "clojure.core-api.html\\#clojure.core/find-ns"],
    \["find-var", "clojure.core-api.html\\#clojure.core/find-var"],
    \["first", "clojure.core-api.html\\#clojure.core/first"],
    \["flatten", "clojure.core-api.html\\#clojure.core/flatten"],
    \["float", "clojure.core-api.html\\#clojure.core/float"],
    \["float-array", "clojure.core-api.html\\#clojure.core/float-array"],
    \["float?", "clojure.core-api.html\\#clojure.core/float?"],
    \["floats", "clojure.core-api.html\\#clojure.core/floats"],
    \["flush", "clojure.core-api.html\\#clojure.core/flush"],
    \["fn", "clojure.core-api.html\\#clojure.core/fn"],
    \["fn?", "clojure.core-api.html\\#clojure.core/fn?"],
    \["fnext", "clojure.core-api.html\\#clojure.core/fnext"],
    \["fnil", "clojure.core-api.html\\#clojure.core/fnil"],
    \["for", "clojure.core-api.html\\#clojure.core/for"],
    \["force", "clojure.core-api.html\\#clojure.core/force"],
    \["format", "clojure.core-api.html\\#clojure.core/format"],
    \["frequencies", "clojure.core-api.html\\#clojure.core/frequencies"],
    \["future", "clojure.core-api.html\\#clojure.core/future"],
    \["future-call", "clojure.core-api.html\\#clojure.core/future-call"],
    \["future-cancel", "clojure.core-api.html\\#clojure.core/future-cancel"],
    \["future-cancelled?", "clojure.core-api.html\\#clojure.core/future-cancelled?"],
    \["future-done?", "clojure.core-api.html\\#clojure.core/future-done?"],
    \["future?", "clojure.core-api.html\\#clojure.core/future?"],
    \["gen-class", "clojure.core-api.html\\#clojure.core/gen-class"],
    \["gen-interface", "clojure.core-api.html\\#clojure.core/gen-interface"],
    \["gensym", "clojure.core-api.html\\#clojure.core/gensym"],
    \["get", "clojure.core-api.html\\#clojure.core/get"],
    \["get-in", "clojure.core-api.html\\#clojure.core/get-in"],
    \["get-method", "clojure.core-api.html\\#clojure.core/get-method"],
    \["get-proxy-class", "clojure.core-api.html\\#clojure.core/get-proxy-class"],
    \["get-thread-bindings", "clojure.core-api.html\\#clojure.core/get-thread-bindings"],
    \["get-validator", "clojure.core-api.html\\#clojure.core/get-validator"],
    \["group-by", "clojure.core-api.html\\#clojure.core/group-by"],
    \["hash", "clojure.core-api.html\\#clojure.core/hash"],
    \["hash-map", "clojure.core-api.html\\#clojure.core/hash-map"],
    \["hash-set", "clojure.core-api.html\\#clojure.core/hash-set"],
    \["identical?", "clojure.core-api.html\\#clojure.core/identical?"],
    \["identity", "clojure.core-api.html\\#clojure.core/identity"],
    \["if-let", "clojure.core-api.html\\#clojure.core/if-let"],
    \["if-not", "clojure.core-api.html\\#clojure.core/if-not"],
    \["ifn?", "clojure.core-api.html\\#clojure.core/ifn?"],
    \["import", "clojure.core-api.html\\#clojure.core/import"],
    \["in-ns", "clojure.core-api.html\\#clojure.core/in-ns"],
    \["inc", "clojure.core-api.html\\#clojure.core/inc"],
    \["inc'", "clojure.core-api.html\\#clojure.core/inc'"],
    \["init-proxy", "clojure.core-api.html\\#clojure.core/init-proxy"],
    \["instance?", "clojure.core-api.html\\#clojure.core/instance?"],
    \["int", "clojure.core-api.html\\#clojure.core/int"],
    \["int-array", "clojure.core-api.html\\#clojure.core/int-array"],
    \["integer?", "clojure.core-api.html\\#clojure.core/integer?"],
    \["interleave", "clojure.core-api.html\\#clojure.core/interleave"],
    \["intern", "clojure.core-api.html\\#clojure.core/intern"],
    \["interpose", "clojure.core-api.html\\#clojure.core/interpose"],
    \["into", "clojure.core-api.html\\#clojure.core/into"],
    \["into-array", "clojure.core-api.html\\#clojure.core/into-array"],
    \["ints", "clojure.core-api.html\\#clojure.core/ints"],
    \["io!", "clojure.core-api.html\\#clojure.core/io!"],
    \["isa?", "clojure.core-api.html\\#clojure.core/isa?"],
    \["iterate", "clojure.core-api.html\\#clojure.core/iterate"],
    \["iterator-seq", "clojure.core-api.html\\#clojure.core/iterator-seq"],
    \["juxt", "clojure.core-api.html\\#clojure.core/juxt"],
    \["keep", "clojure.core-api.html\\#clojure.core/keep"],
    \["keep-indexed", "clojure.core-api.html\\#clojure.core/keep-indexed"],
    \["key", "clojure.core-api.html\\#clojure.core/key"],
    \["keys", "clojure.core-api.html\\#clojure.core/keys"],
    \["keyword", "clojure.core-api.html\\#clojure.core/keyword"],
    \["keyword?", "clojure.core-api.html\\#clojure.core/keyword?"],
    \["last", "clojure.core-api.html\\#clojure.core/last"],
    \["lazy-cat", "clojure.core-api.html\\#clojure.core/lazy-cat"],
    \["lazy-seq", "clojure.core-api.html\\#clojure.core/lazy-seq"],
    \["let", "clojure.core-api.html\\#clojure.core/let"],
    \["letfn", "clojure.core-api.html\\#clojure.core/letfn"],
    \["line-seq", "clojure.core-api.html\\#clojure.core/line-seq"],
    \["list", "clojure.core-api.html\\#clojure.core/list"],
    \["list*", "clojure.core-api.html\\#clojure.core/list*"],
    \["list?", "clojure.core-api.html\\#clojure.core/list?"],
    \["load", "clojure.core-api.html\\#clojure.core/load"],
    \["load-file", "clojure.core-api.html\\#clojure.core/load-file"],
    \["load-reader", "clojure.core-api.html\\#clojure.core/load-reader"],
    \["load-string", "clojure.core-api.html\\#clojure.core/load-string"],
    \["loaded-libs", "clojure.core-api.html\\#clojure.core/loaded-libs"],
    \["locking", "clojure.core-api.html\\#clojure.core/locking"],
    \["long", "clojure.core-api.html\\#clojure.core/long"],
    \["long-array", "clojure.core-api.html\\#clojure.core/long-array"],
    \["longs", "clojure.core-api.html\\#clojure.core/longs"],
    \["loop", "clojure.core-api.html\\#clojure.core/loop"],
    \["macroexpand", "clojure.core-api.html\\#clojure.core/macroexpand"],
    \["macroexpand-1", "clojure.core-api.html\\#clojure.core/macroexpand-1"],
    \["make-array", "clojure.core-api.html\\#clojure.core/make-array"],
    \["make-hierarchy", "clojure.core-api.html\\#clojure.core/make-hierarchy"],
    \["map", "clojure.core-api.html\\#clojure.core/map"],
    \["map-indexed", "clojure.core-api.html\\#clojure.core/map-indexed"],
    \["map?", "clojure.core-api.html\\#clojure.core/map?"],
    \["mapcat", "clojure.core-api.html\\#clojure.core/mapcat"],
    \["max", "clojure.core-api.html\\#clojure.core/max"],
    \["max-key", "clojure.core-api.html\\#clojure.core/max-key"],
    \["memfn", "clojure.core-api.html\\#clojure.core/memfn"],
    \["memoize", "clojure.core-api.html\\#clojure.core/memoize"],
    \["merge", "clojure.core-api.html\\#clojure.core/merge"],
    \["merge-with", "clojure.core-api.html\\#clojure.core/merge-with"],
    \["meta", "clojure.core-api.html\\#clojure.core/meta"],
    \["methods", "clojure.core-api.html\\#clojure.core/methods"],
    \["min", "clojure.core-api.html\\#clojure.core/min"],
    \["min-key", "clojure.core-api.html\\#clojure.core/min-key"],
    \["mod", "clojure.core-api.html\\#clojure.core/mod"],
    \["name", "clojure.core-api.html\\#clojure.core/name"],
    \["namespace", "clojure.core-api.html\\#clojure.core/namespace"],
    \["namespace-munge", "clojure.core-api.html\\#clojure.core/namespace-munge"],
    \["neg?", "clojure.core-api.html\\#clojure.core/neg?"],
    \["newline", "clojure.core-api.html\\#clojure.core/newline"],
    \["next", "clojure.core-api.html\\#clojure.core/next"],
    \["nfirst", "clojure.core-api.html\\#clojure.core/nfirst"],
    \["nil?", "clojure.core-api.html\\#clojure.core/nil?"],
    \["nnext", "clojure.core-api.html\\#clojure.core/nnext"],
    \["not", "clojure.core-api.html\\#clojure.core/not"],
    \["not-any?", "clojure.core-api.html\\#clojure.core/not-any?"],
    \["not-empty", "clojure.core-api.html\\#clojure.core/not-empty"],
    \["not-every?", "clojure.core-api.html\\#clojure.core/not-every?"],
    \["not=", "clojure.core-api.html\\#clojure.core/not="],
    \["ns", "clojure.core-api.html\\#clojure.core/ns"],
    \["ns-aliases", "clojure.core-api.html\\#clojure.core/ns-aliases"],
    \["ns-imports", "clojure.core-api.html\\#clojure.core/ns-imports"],
    \["ns-interns", "clojure.core-api.html\\#clojure.core/ns-interns"],
    \["ns-map", "clojure.core-api.html\\#clojure.core/ns-map"],
    \["ns-name", "clojure.core-api.html\\#clojure.core/ns-name"],
    \["ns-publics", "clojure.core-api.html\\#clojure.core/ns-publics"],
    \["ns-refers", "clojure.core-api.html\\#clojure.core/ns-refers"],
    \["ns-resolve", "clojure.core-api.html\\#clojure.core/ns-resolve"],
    \["ns-unalias", "clojure.core-api.html\\#clojure.core/ns-unalias"],
    \["ns-unmap", "clojure.core-api.html\\#clojure.core/ns-unmap"],
    \["nth", "clojure.core-api.html\\#clojure.core/nth"],
    \["nthnext", "clojure.core-api.html\\#clojure.core/nthnext"],
    \["nthrest", "clojure.core-api.html\\#clojure.core/nthrest"],
    \["num", "clojure.core-api.html\\#clojure.core/num"],
    \["number?", "clojure.core-api.html\\#clojure.core/number?"],
    \["numerator", "clojure.core-api.html\\#clojure.core/numerator"],
    \["object-array", "clojure.core-api.html\\#clojure.core/object-array"],
    \["odd?", "clojure.core-api.html\\#clojure.core/odd?"],
    \["or", "clojure.core-api.html\\#clojure.core/or"],
    \["parents", "clojure.core-api.html\\#clojure.core/parents"],
    \["partial", "clojure.core-api.html\\#clojure.core/partial"],
    \["partition", "clojure.core-api.html\\#clojure.core/partition"],
    \["partition-all", "clojure.core-api.html\\#clojure.core/partition-all"],
    \["partition-by", "clojure.core-api.html\\#clojure.core/partition-by"],
    \["pcalls", "clojure.core-api.html\\#clojure.core/pcalls"],
    \["peek", "clojure.core-api.html\\#clojure.core/peek"],
    \["persistent!", "clojure.core-api.html\\#clojure.core/persistent!"],
    \["pmap", "clojure.core-api.html\\#clojure.core/pmap"],
    \["pop", "clojure.core-api.html\\#clojure.core/pop"],
    \["pop!", "clojure.core-api.html\\#clojure.core/pop!"],
    \["pop-thread-bindings", "clojure.core-api.html\\#clojure.core/pop-thread-bindings"],
    \["pos?", "clojure.core-api.html\\#clojure.core/pos?"],
    \["pr", "clojure.core-api.html\\#clojure.core/pr"],
    \["pr-str", "clojure.core-api.html\\#clojure.core/pr-str"],
    \["prefer-method", "clojure.core-api.html\\#clojure.core/prefer-method"],
    \["prefers", "clojure.core-api.html\\#clojure.core/prefers"],
    \["print", "clojure.core-api.html\\#clojure.core/print"],
    \["print-str", "clojure.core-api.html\\#clojure.core/print-str"],
    \["printf", "clojure.core-api.html\\#clojure.core/printf"],
    \["println", "clojure.core-api.html\\#clojure.core/println"],
    \["println-str", "clojure.core-api.html\\#clojure.core/println-str"],
    \["prn", "clojure.core-api.html\\#clojure.core/prn"],
    \["prn-str", "clojure.core-api.html\\#clojure.core/prn-str"],
    \["promise", "clojure.core-api.html\\#clojure.core/promise"],
    \["proxy", "clojure.core-api.html\\#clojure.core/proxy"],
    \["proxy-mappings", "clojure.core-api.html\\#clojure.core/proxy-mappings"],
    \["proxy-super", "clojure.core-api.html\\#clojure.core/proxy-super"],
    \["push-thread-bindings", "clojure.core-api.html\\#clojure.core/push-thread-bindings"],
    \["pvalues", "clojure.core-api.html\\#clojure.core/pvalues"],
    \["quot", "clojure.core-api.html\\#clojure.core/quot"],
    \["rand", "clojure.core-api.html\\#clojure.core/rand"],
    \["rand-int", "clojure.core-api.html\\#clojure.core/rand-int"],
    \["rand-nth", "clojure.core-api.html\\#clojure.core/rand-nth"],
    \["range", "clojure.core-api.html\\#clojure.core/range"],
    \["ratio?", "clojure.core-api.html\\#clojure.core/ratio?"],
    \["rational?", "clojure.core-api.html\\#clojure.core/rational?"],
    \["rationalize", "clojure.core-api.html\\#clojure.core/rationalize"],
    \["re-find", "clojure.core-api.html\\#clojure.core/re-find"],
    \["re-groups", "clojure.core-api.html\\#clojure.core/re-groups"],
    \["re-matcher", "clojure.core-api.html\\#clojure.core/re-matcher"],
    \["re-matches", "clojure.core-api.html\\#clojure.core/re-matches"],
    \["re-pattern", "clojure.core-api.html\\#clojure.core/re-pattern"],
    \["re-seq", "clojure.core-api.html\\#clojure.core/re-seq"],
    \["read", "clojure.core-api.html\\#clojure.core/read"],
    \["read-line", "clojure.core-api.html\\#clojure.core/read-line"],
    \["read-string", "clojure.core-api.html\\#clojure.core/read-string"],
    \["realized?", "clojure.core-api.html\\#clojure.core/realized?"],
    \["reduce", "clojure.core-api.html\\#clojure.core/reduce"],
    \["reductions", "clojure.core-api.html\\#clojure.core/reductions"],
    \["ref", "clojure.core-api.html\\#clojure.core/ref"],
    \["ref-history-count", "clojure.core-api.html\\#clojure.core/ref-history-count"],
    \["ref-max-history", "clojure.core-api.html\\#clojure.core/ref-max-history"],
    \["ref-min-history", "clojure.core-api.html\\#clojure.core/ref-min-history"],
    \["ref-set", "clojure.core-api.html\\#clojure.core/ref-set"],
    \["refer", "clojure.core-api.html\\#clojure.core/refer"],
    \["refer-clojure", "clojure.core-api.html\\#clojure.core/refer-clojure"],
    \["reify", "clojure.core-api.html\\#clojure.core/reify"],
    \["release-pending-sends", "clojure.core-api.html\\#clojure.core/release-pending-sends"],
    \["rem", "clojure.core-api.html\\#clojure.core/rem"],
    \["remove", "clojure.core-api.html\\#clojure.core/remove"],
    \["remove-all-methods", "clojure.core-api.html\\#clojure.core/remove-all-methods"],
    \["remove-method", "clojure.core-api.html\\#clojure.core/remove-method"],
    \["remove-ns", "clojure.core-api.html\\#clojure.core/remove-ns"],
    \["remove-watch", "clojure.core-api.html\\#clojure.core/remove-watch"],
    \["repeat", "clojure.core-api.html\\#clojure.core/repeat"],
    \["repeatedly", "clojure.core-api.html\\#clojure.core/repeatedly"],
    \["replace", "clojure.core-api.html\\#clojure.core/replace"],
    \["replicate", "clojure.core-api.html\\#clojure.core/replicate"],
    \["require", "clojure.core-api.html\\#clojure.core/require"],
    \["reset!", "clojure.core-api.html\\#clojure.core/reset!"],
    \["reset-meta!", "clojure.core-api.html\\#clojure.core/reset-meta!"],
    \["resolve", "clojure.core-api.html\\#clojure.core/resolve"],
    \["rest", "clojure.core-api.html\\#clojure.core/rest"],
    \["restart-agent", "clojure.core-api.html\\#clojure.core/restart-agent"],
    \["resultset-seq", "clojure.core-api.html\\#clojure.core/resultset-seq"],
    \["reverse", "clojure.core-api.html\\#clojure.core/reverse"],
    \["reversible?", "clojure.core-api.html\\#clojure.core/reversible?"],
    \["rseq", "clojure.core-api.html\\#clojure.core/rseq"],
    \["rsubseq", "clojure.core-api.html\\#clojure.core/rsubseq"],
    \["satisfies?", "clojure.core-api.html\\#clojure.core/satisfies?"],
    \["second", "clojure.core-api.html\\#clojure.core/second"],
    \["select-keys", "clojure.core-api.html\\#clojure.core/select-keys"],
    \["send", "clojure.core-api.html\\#clojure.core/send"],
    \["send-off", "clojure.core-api.html\\#clojure.core/send-off"],
    \["seq", "clojure.core-api.html\\#clojure.core/seq"],
    \["seq?", "clojure.core-api.html\\#clojure.core/seq?"],
    \["seque", "clojure.core-api.html\\#clojure.core/seque"],
    \["sequence", "clojure.core-api.html\\#clojure.core/sequence"],
    \["sequential?", "clojure.core-api.html\\#clojure.core/sequential?"],
    \["set", "clojure.core-api.html\\#clojure.core/set"],
    \["set-error-handler!", "clojure.core-api.html\\#clojure.core/set-error-handler!"],
    \["set-error-mode!", "clojure.core-api.html\\#clojure.core/set-error-mode!"],
    \["set-validator!", "clojure.core-api.html\\#clojure.core/set-validator!"],
    \["set?", "clojure.core-api.html\\#clojure.core/set?"],
    \["short", "clojure.core-api.html\\#clojure.core/short"],
    \["short-array", "clojure.core-api.html\\#clojure.core/short-array"],
    \["shorts", "clojure.core-api.html\\#clojure.core/shorts"],
    \["shuffle", "clojure.core-api.html\\#clojure.core/shuffle"],
    \["shutdown-agents", "clojure.core-api.html\\#clojure.core/shutdown-agents"],
    \["slurp", "clojure.core-api.html\\#clojure.core/slurp"],
    \["some", "clojure.core-api.html\\#clojure.core/some"],
    \["some-fn", "clojure.core-api.html\\#clojure.core/some-fn"],
    \["sort", "clojure.core-api.html\\#clojure.core/sort"],
    \["sort-by", "clojure.core-api.html\\#clojure.core/sort-by"],
    \["sorted-map", "clojure.core-api.html\\#clojure.core/sorted-map"],
    \["sorted-map-by", "clojure.core-api.html\\#clojure.core/sorted-map-by"],
    \["sorted-set", "clojure.core-api.html\\#clojure.core/sorted-set"],
    \["sorted-set-by", "clojure.core-api.html\\#clojure.core/sorted-set-by"],
    \["sorted?", "clojure.core-api.html\\#clojure.core/sorted?"],
    \["special-symbol?", "clojure.core-api.html\\#clojure.core/special-symbol?"],
    \["spit", "clojure.core-api.html\\#clojure.core/spit"],
    \["split-at", "clojure.core-api.html\\#clojure.core/split-at"],
    \["split-with", "clojure.core-api.html\\#clojure.core/split-with"],
    \["str", "clojure.core-api.html\\#clojure.core/str"],
    \["string?", "clojure.core-api.html\\#clojure.core/string?"],
    \["struct", "clojure.core-api.html\\#clojure.core/struct"],
    \["struct-map", "clojure.core-api.html\\#clojure.core/struct-map"],
    \["subs", "clojure.core-api.html\\#clojure.core/subs"],
    \["subseq", "clojure.core-api.html\\#clojure.core/subseq"],
    \["subvec", "clojure.core-api.html\\#clojure.core/subvec"],
    \["supers", "clojure.core-api.html\\#clojure.core/supers"],
    \["swap!", "clojure.core-api.html\\#clojure.core/swap!"],
    \["symbol", "clojure.core-api.html\\#clojure.core/symbol"],
    \["symbol?", "clojure.core-api.html\\#clojure.core/symbol?"],
    \["sync", "clojure.core-api.html\\#clojure.core/sync"],
    \["take", "clojure.core-api.html\\#clojure.core/take"],
    \["take-last", "clojure.core-api.html\\#clojure.core/take-last"],
    \["take-nth", "clojure.core-api.html\\#clojure.core/take-nth"],
    \["take-while", "clojure.core-api.html\\#clojure.core/take-while"],
    \["test", "clojure.core-api.html\\#clojure.core/test"],
    \["the-ns", "clojure.core-api.html\\#clojure.core/the-ns"],
    \["thread-bound?", "clojure.core-api.html\\#clojure.core/thread-bound?"],
    \["time", "clojure.core-api.html\\#clojure.core/time"],
    \["to-array", "clojure.core-api.html\\#clojure.core/to-array"],
    \["to-array-2d", "clojure.core-api.html\\#clojure.core/to-array-2d"],
    \["trampoline", "clojure.core-api.html\\#clojure.core/trampoline"],
    \["transient", "clojure.core-api.html\\#clojure.core/transient"],
    \["tree-seq", "clojure.core-api.html\\#clojure.core/tree-seq"],
    \["true?", "clojure.core-api.html\\#clojure.core/true?"],
    \["type", "clojure.core-api.html\\#clojure.core/type"],
    \["unchecked-add", "clojure.core-api.html\\#clojure.core/unchecked-add"],
    \["unchecked-add-int", "clojure.core-api.html\\#clojure.core/unchecked-add-int"],
    \["unchecked-byte", "clojure.core-api.html\\#clojure.core/unchecked-byte"],
    \["unchecked-char", "clojure.core-api.html\\#clojure.core/unchecked-char"],
    \["unchecked-dec", "clojure.core-api.html\\#clojure.core/unchecked-dec"],
    \["unchecked-dec-int", "clojure.core-api.html\\#clojure.core/unchecked-dec-int"],
    \["unchecked-divide-int", "clojure.core-api.html\\#clojure.core/unchecked-divide-int"],
    \["unchecked-double", "clojure.core-api.html\\#clojure.core/unchecked-double"],
    \["unchecked-float", "clojure.core-api.html\\#clojure.core/unchecked-float"],
    \["unchecked-inc", "clojure.core-api.html\\#clojure.core/unchecked-inc"],
    \["unchecked-inc-int", "clojure.core-api.html\\#clojure.core/unchecked-inc-int"],
    \["unchecked-int", "clojure.core-api.html\\#clojure.core/unchecked-int"],
    \["unchecked-long", "clojure.core-api.html\\#clojure.core/unchecked-long"],
    \["unchecked-multiply", "clojure.core-api.html\\#clojure.core/unchecked-multiply"],
    \["unchecked-multiply-int", "clojure.core-api.html\\#clojure.core/unchecked-multiply-int"],
    \["unchecked-negate", "clojure.core-api.html\\#clojure.core/unchecked-negate"],
    \["unchecked-negate-int", "clojure.core-api.html\\#clojure.core/unchecked-negate-int"],
    \["unchecked-remainder-int", "clojure.core-api.html\\#clojure.core/unchecked-remainder-int"],
    \["unchecked-short", "clojure.core-api.html\\#clojure.core/unchecked-short"],
    \["unchecked-subtract", "clojure.core-api.html\\#clojure.core/unchecked-subtract"],
    \["unchecked-subtract-int", "clojure.core-api.html\\#clojure.core/unchecked-subtract-int"],
    \["underive", "clojure.core-api.html\\#clojure.core/underive"],
    \["update-in", "clojure.core-api.html\\#clojure.core/update-in"],
    \["update-proxy", "clojure.core-api.html\\#clojure.core/update-proxy"],
    \["use", "clojure.core-api.html\\#clojure.core/use"],
    \["val", "clojure.core-api.html\\#clojure.core/val"],
    \["vals", "clojure.core-api.html\\#clojure.core/vals"],
    \["var-get", "clojure.core-api.html\\#clojure.core/var-get"],
    \["var-set", "clojure.core-api.html\\#clojure.core/var-set"],
    \["var?", "clojure.core-api.html\\#clojure.core/var?"],
    \["vary-meta", "clojure.core-api.html\\#clojure.core/vary-meta"],
    \["vec", "clojure.core-api.html\\#clojure.core/vec"],
    \["vector", "clojure.core-api.html\\#clojure.core/vector"],
    \["vector-of", "clojure.core-api.html\\#clojure.core/vector-of"],
    \["vector?", "clojure.core-api.html\\#clojure.core/vector?"],
    \["when", "clojure.core-api.html\\#clojure.core/when"],
    \["when-first", "clojure.core-api.html\\#clojure.core/when-first"],
    \["when-let", "clojure.core-api.html\\#clojure.core/when-let"],
    \["when-not", "clojure.core-api.html\\#clojure.core/when-not"],
    \["while", "clojure.core-api.html\\#clojure.core/while"],
    \["with-bindings", "clojure.core-api.html\\#clojure.core/with-bindings"],
    \["with-bindings*", "clojure.core-api.html\\#clojure.core/with-bindings*"],
    \["with-in-str", "clojure.core-api.html\\#clojure.core/with-in-str"],
    \["with-local-vars", "clojure.core-api.html\\#clojure.core/with-local-vars"],
    \["with-meta", "clojure.core-api.html\\#clojure.core/with-meta"],
    \["with-open", "clojure.core-api.html\\#clojure.core/with-open"],
    \["with-out-str", "clojure.core-api.html\\#clojure.core/with-out-str"],
    \["with-precision", "clojure.core-api.html\\#clojure.core/with-precision"],
    \["with-redefs", "clojure.core-api.html\\#clojure.core/with-redefs"],
    \["with-redefs-fn", "clojure.core-api.html\\#clojure.core/with-redefs-fn"],
    \["xml-seq", "clojure.core-api.html\\#clojure.core/xml-seq"],
    \["zero?", "clojure.core-api.html\\#clojure.core/zero?"],
    \["zipmap", "clojure.core-api.html\\#clojure.core/zipmap"],
    \["Diff", "clojure.data-api.html\\#clojure.data/Diff"],
    \["EqualityPartition", "clojure.data-api.html\\#clojure.data/EqualityPartition"],
    \["diff", "clojure.data-api.html\\#clojure.data/diff"],
    \["diff-similar", "clojure.data-api.html\\#clojure.data/diff-similar"],
    \["equality-partition", "clojure.data-api.html\\#clojure.data/equality-partition"],
    \["inspect", "clojure.inspector-api.html\\#clojure.inspector/inspect"],
    \["inspect-table", "clojure.inspector-api.html\\#clojure.inspector/inspect-table"],
    \["inspect-tree", "clojure.inspector-api.html\\#clojure.inspector/inspect-tree"],
    \["browse-url", "clojure.java.browse-api.html\\#clojure.java.browse/browse-url"],
    \["Coercions", "clojure.java.io-api.html\\#clojure.java.io/Coercions"],
    \["IOFactory", "clojure.java.io-api.html\\#clojure.java.io/IOFactory"],
    \["as-file", "clojure.java.io-api.html\\#clojure.java.io/as-file"],
    \["as-relative-path", "clojure.java.io-api.html\\#clojure.java.io/as-relative-path"],
    \["as-url", "clojure.java.io-api.html\\#clojure.java.io/as-url"],
    \["copy", "clojure.java.io-api.html\\#clojure.java.io/copy"],
    \["delete-file", "clojure.java.io-api.html\\#clojure.java.io/delete-file"],
    \["file", "clojure.java.io-api.html\\#clojure.java.io/file"],
    \["input-stream", "clojure.java.io-api.html\\#clojure.java.io/input-stream"],
    \["make-input-stream", "clojure.java.io-api.html\\#clojure.java.io/make-input-stream"],
    \["make-output-stream", "clojure.java.io-api.html\\#clojure.java.io/make-output-stream"],
    \["make-parents", "clojure.java.io-api.html\\#clojure.java.io/make-parents"],
    \["make-reader", "clojure.java.io-api.html\\#clojure.java.io/make-reader"],
    \["make-writer", "clojure.java.io-api.html\\#clojure.java.io/make-writer"],
    \["output-stream", "clojure.java.io-api.html\\#clojure.java.io/output-stream"],
    \["reader", "clojure.java.io-api.html\\#clojure.java.io/reader"],
    \["resource", "clojure.java.io-api.html\\#clojure.java.io/resource"],
    \["writer", "clojure.java.io-api.html\\#clojure.java.io/writer"],
    \["add-local-javadoc", "clojure.java.javadoc-api.html\\#clojure.java.javadoc/add-local-javadoc"],
    \["add-remote-javadoc", "clojure.java.javadoc-api.html\\#clojure.java.javadoc/add-remote-javadoc"],
    \["javadoc", "clojure.java.javadoc-api.html\\#clojure.java.javadoc/javadoc"],
    \["sh", "clojure.java.shell-api.html\\#clojure.java.shell/sh"],
    \["with-sh-dir", "clojure.java.shell-api.html\\#clojure.java.shell/with-sh-dir"],
    \["with-sh-env", "clojure.java.shell-api.html\\#clojure.java.shell/with-sh-env"],
    \["demunge", "clojure.main-api.html\\#clojure.main/demunge"],
    \["load-script", "clojure.main-api.html\\#clojure.main/load-script"],
    \["main", "clojure.main-api.html\\#clojure.main/main"],
    \["repl", "clojure.main-api.html\\#clojure.main/repl"],
    \["repl-caught", "clojure.main-api.html\\#clojure.main/repl-caught"],
    \["repl-exception", "clojure.main-api.html\\#clojure.main/repl-exception"],
    \["repl-prompt", "clojure.main-api.html\\#clojure.main/repl-prompt"],
    \["repl-read", "clojure.main-api.html\\#clojure.main/repl-read"],
    \["root-cause", "clojure.main-api.html\\#clojure.main/root-cause"],
    \["skip-if-eol", "clojure.main-api.html\\#clojure.main/skip-if-eol"],
    \["skip-whitespace", "clojure.main-api.html\\#clojure.main/skip-whitespace"],
    \["stack-element-str", "clojure.main-api.html\\#clojure.main/stack-element-str"],
    \["with-bindings", "clojure.main-api.html\\#clojure.main/with-bindings"],
    \["*print-base*", "clojure.pprint-api.html\\#clojure.pprint/*print-base*"],
    \["*print-miser-width*", "clojure.pprint-api.html\\#clojure.pprint/*print-miser-width*"],
    \["*print-pprint-dispatch*", "clojure.pprint-api.html\\#clojure.pprint/*print-pprint-dispatch*"],
    \["*print-pretty*", "clojure.pprint-api.html\\#clojure.pprint/*print-pretty*"],
    \["*print-radix*", "clojure.pprint-api.html\\#clojure.pprint/*print-radix*"],
    \["*print-right-margin*", "clojure.pprint-api.html\\#clojure.pprint/*print-right-margin*"],
    \["*print-suppress-namespaces*", "clojure.pprint-api.html\\#clojure.pprint/*print-suppress-namespaces*"],
    \["cl-format", "clojure.pprint-api.html\\#clojure.pprint/cl-format"],
    \["formatter", "clojure.pprint-api.html\\#clojure.pprint/formatter"],
    \["formatter-out", "clojure.pprint-api.html\\#clojure.pprint/formatter-out"],
    \["fresh-line", "clojure.pprint-api.html\\#clojure.pprint/fresh-line"],
    \["get-pretty-writer", "clojure.pprint-api.html\\#clojure.pprint/get-pretty-writer"],
    \["pp", "clojure.pprint-api.html\\#clojure.pprint/pp"],
    \["pprint", "clojure.pprint-api.html\\#clojure.pprint/pprint"],
    \["pprint-indent", "clojure.pprint-api.html\\#clojure.pprint/pprint-indent"],
    \["pprint-logical-block", "clojure.pprint-api.html\\#clojure.pprint/pprint-logical-block"],
    \["pprint-newline", "clojure.pprint-api.html\\#clojure.pprint/pprint-newline"],
    \["pprint-tab", "clojure.pprint-api.html\\#clojure.pprint/pprint-tab"],
    \["print-length-loop", "clojure.pprint-api.html\\#clojure.pprint/print-length-loop"],
    \["print-table", "clojure.pprint-api.html\\#clojure.pprint/print-table"],
    \["set-pprint-dispatch", "clojure.pprint-api.html\\#clojure.pprint/set-pprint-dispatch"],
    \["with-pprint-dispatch", "clojure.pprint-api.html\\#clojure.pprint/with-pprint-dispatch"],
    \["write", "clojure.pprint-api.html\\#clojure.pprint/write"],
    \["write-out", "clojure.pprint-api.html\\#clojure.pprint/write-out"],
    \["TypeReference", "clojure.reflect-api.html\\#clojure.reflect/TypeReference"],
    \["flag-descriptors", "clojure.reflect-api.html\\#clojure.reflect/flag-descriptors"],
    \["reflect", "clojure.reflect-api.html\\#clojure.reflect/reflect"],
    \["resolve-class", "clojure.reflect-api.html\\#clojure.reflect/resolve-class"],
    \["type-reflect", "clojure.reflect-api.html\\#clojure.reflect/type-reflect"],
    \["typename", "clojure.reflect-api.html\\#clojure.reflect/typename"],
    \["apropos", "clojure.repl-api.html\\#clojure.repl/apropos"],
    \["demunge", "clojure.repl-api.html\\#clojure.repl/demunge"],
    \["dir", "clojure.repl-api.html\\#clojure.repl/dir"],
    \["dir-fn", "clojure.repl-api.html\\#clojure.repl/dir-fn"],
    \["doc", "clojure.repl-api.html\\#clojure.repl/doc"],
    \["find-doc", "clojure.repl-api.html\\#clojure.repl/find-doc"],
    \["pst", "clojure.repl-api.html\\#clojure.repl/pst"],
    \["root-cause", "clojure.repl-api.html\\#clojure.repl/root-cause"],
    \["set-break-handler!", "clojure.repl-api.html\\#clojure.repl/set-break-handler!"],
    \["source", "clojure.repl-api.html\\#clojure.repl/source"],
    \["source-fn", "clojure.repl-api.html\\#clojure.repl/source-fn"],
    \["stack-element-str", "clojure.repl-api.html\\#clojure.repl/stack-element-str"],
    \["thread-stopper", "clojure.repl-api.html\\#clojure.repl/thread-stopper"],
    \["difference", "clojure.set-api.html\\#clojure.set/difference"],
    \["index", "clojure.set-api.html\\#clojure.set/index"],
    \["intersection", "clojure.set-api.html\\#clojure.set/intersection"],
    \["join", "clojure.set-api.html\\#clojure.set/join"],
    \["map-invert", "clojure.set-api.html\\#clojure.set/map-invert"],
    \["project", "clojure.set-api.html\\#clojure.set/project"],
    \["rename", "clojure.set-api.html\\#clojure.set/rename"],
    \["rename-keys", "clojure.set-api.html\\#clojure.set/rename-keys"],
    \["select", "clojure.set-api.html\\#clojure.set/select"],
    \["subset?", "clojure.set-api.html\\#clojure.set/subset?"],
    \["superset?", "clojure.set-api.html\\#clojure.set/superset?"],
    \["union", "clojure.set-api.html\\#clojure.set/union"],
    \["e", "clojure.stacktrace-api.html\\#clojure.stacktrace/e"],
    \["print-cause-trace", "clojure.stacktrace-api.html\\#clojure.stacktrace/print-cause-trace"],
    \["print-stack-trace", "clojure.stacktrace-api.html\\#clojure.stacktrace/print-stack-trace"],
    \["print-throwable", "clojure.stacktrace-api.html\\#clojure.stacktrace/print-throwable"],
    \["print-trace-element", "clojure.stacktrace-api.html\\#clojure.stacktrace/print-trace-element"],
    \["root-cause", "clojure.stacktrace-api.html\\#clojure.stacktrace/root-cause"],
    \["blank?", "clojure.string-api.html\\#clojure.string/blank?"],
    \["capitalize", "clojure.string-api.html\\#clojure.string/capitalize"],
    \["escape", "clojure.string-api.html\\#clojure.string/escape"],
    \["join", "clojure.string-api.html\\#clojure.string/join"],
    \["lower-case", "clojure.string-api.html\\#clojure.string/lower-case"],
    \["replace", "clojure.string-api.html\\#clojure.string/replace"],
    \["replace-first", "clojure.string-api.html\\#clojure.string/replace-first"],
    \["reverse", "clojure.string-api.html\\#clojure.string/reverse"],
    \["split", "clojure.string-api.html\\#clojure.string/split"],
    \["split-lines", "clojure.string-api.html\\#clojure.string/split-lines"],
    \["trim", "clojure.string-api.html\\#clojure.string/trim"],
    \["trim-newline", "clojure.string-api.html\\#clojure.string/trim-newline"],
    \["triml", "clojure.string-api.html\\#clojure.string/triml"],
    \["trimr", "clojure.string-api.html\\#clojure.string/trimr"],
    \["upper-case", "clojure.string-api.html\\#clojure.string/upper-case"],
    \["apply-template", "clojure.template-api.html\\#clojure.template/apply-template"],
    \["do-template", "clojure.template-api.html\\#clojure.template/do-template"],
    \["*load-tests*", "clojure.test-api.html\\#clojure.test/*load-tests*"],
    \["*stack-trace-depth*", "clojure.test-api.html\\#clojure.test/*stack-trace-depth*"],
    \["are", "clojure.test-api.html\\#clojure.test/are"],
    \["assert-any", "clojure.test-api.html\\#clojure.test/assert-any"],
    \["assert-predicate", "clojure.test-api.html\\#clojure.test/assert-predicate"],
    \["compose-fixtures", "clojure.test-api.html\\#clojure.test/compose-fixtures"],
    \["deftest", "clojure.test-api.html\\#clojure.test/deftest"],
    \["deftest-", "clojure.test-api.html\\#clojure.test/deftest-"],
    \["do-report", "clojure.test-api.html\\#clojure.test/do-report"],
    \["file-position", "clojure.test-api.html\\#clojure.test/file-position"],
    \["function?", "clojure.test-api.html\\#clojure.test/function?"],
    \["get-possibly-unbound-var", "clojure.test-api.html\\#clojure.test/get-possibly-unbound-var"],
    \["inc-report-counter", "clojure.test-api.html\\#clojure.test/inc-report-counter"],
    \["is", "clojure.test-api.html\\#clojure.test/is"],
    \["join-fixtures", "clojure.test-api.html\\#clojure.test/join-fixtures"],
    \["report", "clojure.test-api.html\\#clojure.test/report"],
    \["run-all-tests", "clojure.test-api.html\\#clojure.test/run-all-tests"],
    \["run-tests", "clojure.test-api.html\\#clojure.test/run-tests"],
    \["set-test", "clojure.test-api.html\\#clojure.test/set-test"],
    \["successful?", "clojure.test-api.html\\#clojure.test/successful?"],
    \["test-all-vars", "clojure.test-api.html\\#clojure.test/test-all-vars"],
    \["test-ns", "clojure.test-api.html\\#clojure.test/test-ns"],
    \["test-var", "clojure.test-api.html\\#clojure.test/test-var"],
    \["testing", "clojure.test-api.html\\#clojure.test/testing"],
    \["testing-contexts-str", "clojure.test-api.html\\#clojure.test/testing-contexts-str"],
    \["testing-vars-str", "clojure.test-api.html\\#clojure.test/testing-vars-str"],
    \["try-expr", "clojure.test-api.html\\#clojure.test/try-expr"],
    \["with-test", "clojure.test-api.html\\#clojure.test/with-test"],
    \["with-test-out", "clojure.test-api.html\\#clojure.test/with-test-out"],
    \["clojure.test.junit", "clojure.test-api.html\\#clojure.test.junit"],
    \["with-junit-output", "clojure.test-api.html\\#clojure.test.junit/with-junit-output"],
    \["clojure.test.tap", "clojure.test-api.html\\#clojure.test.tap"],
    \["print-tap-diagnostic", "clojure.test-api.html\\#clojure.test.tap/print-tap-diagnostic"],
    \["print-tap-fail", "clojure.test-api.html\\#clojure.test.tap/print-tap-fail"],
    \["print-tap-pass", "clojure.test-api.html\\#clojure.test.tap/print-tap-pass"],
    \["print-tap-plan", "clojure.test-api.html\\#clojure.test.tap/print-tap-plan"],
    \["with-tap-output", "clojure.test-api.html\\#clojure.test.tap/with-tap-output"],
    \["keywordize-keys", "clojure.walk-api.html\\#clojure.walk/keywordize-keys"],
    \["macroexpand-all", "clojure.walk-api.html\\#clojure.walk/macroexpand-all"],
    \["postwalk", "clojure.walk-api.html\\#clojure.walk/postwalk"],
    \["postwalk-demo", "clojure.walk-api.html\\#clojure.walk/postwalk-demo"],
    \["postwalk-replace", "clojure.walk-api.html\\#clojure.walk/postwalk-replace"],
    \["prewalk", "clojure.walk-api.html\\#clojure.walk/prewalk"],
    \["prewalk-demo", "clojure.walk-api.html\\#clojure.walk/prewalk-demo"],
    \["prewalk-replace", "clojure.walk-api.html\\#clojure.walk/prewalk-replace"],
    \["stringify-keys", "clojure.walk-api.html\\#clojure.walk/stringify-keys"],
    \["walk", "clojure.walk-api.html\\#clojure.walk/walk"],
    \["parse", "clojure.xml-api.html\\#clojure.xml/parse"],
    \["append-child", "clojure.zip-api.html\\#clojure.zip/append-child"],
    \["branch?", "clojure.zip-api.html\\#clojure.zip/branch?"],
    \["children", "clojure.zip-api.html\\#clojure.zip/children"],
    \["down", "clojure.zip-api.html\\#clojure.zip/down"],
    \["edit", "clojure.zip-api.html\\#clojure.zip/edit"],
    \["end?", "clojure.zip-api.html\\#clojure.zip/end?"],
    \["insert-child", "clojure.zip-api.html\\#clojure.zip/insert-child"],
    \["insert-left", "clojure.zip-api.html\\#clojure.zip/insert-left"],
    \["insert-right", "clojure.zip-api.html\\#clojure.zip/insert-right"],
    \["left", "clojure.zip-api.html\\#clojure.zip/left"],
    \["leftmost", "clojure.zip-api.html\\#clojure.zip/leftmost"],
    \["lefts", "clojure.zip-api.html\\#clojure.zip/lefts"],
    \["make-node", "clojure.zip-api.html\\#clojure.zip/make-node"],
    \["next", "clojure.zip-api.html\\#clojure.zip/next"],
    \["node", "clojure.zip-api.html\\#clojure.zip/node"],
    \["path", "clojure.zip-api.html\\#clojure.zip/path"],
    \["prev", "clojure.zip-api.html\\#clojure.zip/prev"],
    \["remove", "clojure.zip-api.html\\#clojure.zip/remove"],
    \["replace", "clojure.zip-api.html\\#clojure.zip/replace"],
    \["right", "clojure.zip-api.html\\#clojure.zip/right"],
    \["rightmost", "clojure.zip-api.html\\#clojure.zip/rightmost"],
    \["rights", "clojure.zip-api.html\\#clojure.zip/rights"],
    \["root", "clojure.zip-api.html\\#clojure.zip/root"],
    \["seq-zip", "clojure.zip-api.html\\#clojure.zip/seq-zip"],
    \["up", "clojure.zip-api.html\\#clojure.zip/up"],
    \["vector-zip", "clojure.zip-api.html\\#clojure.zip/vector-zip"],
    \["xml-zip", "clojure.zip-api.html\\#clojure.zip/xml-zip"],
    \["zipper", "clojure.zip-api.html\\#clojure.zip/zipper"]]
endif

