local function prompt(str, opts)
  return vim.tbl_deep_extend("keep", opts or {}, { prompt = str .. "> " })
end
return {
  desc                 = "defaults using prompt for picker info",
  winopts              = { title_pos = "center", preview = { title_pos = "center" } },
  -- Uses `cwd_prompt` by default
  -- files                = prompt("Files"),
  global               = prompt("Global"),
  buffers              = prompt("Buffers"),
  tabs                 = prompt("Tabs"),
  lines                = prompt("Lines"),
  blines               = prompt("BLines"),
  treesitter           = prompt("Treesitter"),
  grep                 = prompt("Grep"),
  grep_curbuf          = prompt("BGrep"),
  git                  = {
    files    = prompt("GitFiles"),
    status   = prompt("GitStatus"),
    commits  = prompt("GitCommits"),
    bcommits = prompt("GitBCommits"),
    blame    = prompt("GitBlame"),
    branches = prompt("GitBranches"),
    stash    = prompt("GitStash"),
  },
  args                 = prompt("Args"),
  oldfiles             = prompt("Oldfiles"),
  quickfix             = prompt("Quickfix"),
  quickfix_stack       = prompt("Quickfix Stack"),
  loclist              = prompt("Location"),
  loclist_stack        = prompt("Location Stack"),
  tags                 = prompt("Tags"),
  btags                = prompt("BTags"),
  colorschemes         = prompt("Colorschemes"),
  awesome_colorschemes = prompt("Awesome Colorschemes"),
  highlights           = prompt("Highlights"),
  helptags             = prompt("Help"),
  manpages             = prompt("Man"),
  lsp                  = {
    prompt_postfix = "> ",
    symbols        = { prompt_postfix = "> " },
    finder         = prompt("LSP Finder"),
    code_actions   = prompt("Code Actions"),
  },
  diagnostics          = prompt("Diagnostics"),
  builtin              = prompt("Builtin"),
  profiles             = prompt("Profiles"),
  marks                = prompt("Marks"),
  jumps                = prompt("Jumps"),
  tagstack             = prompt("Tagstack"),
  commands             = prompt("Commands"),
  autocmds             = prompt("Autocmds"),
  command_history      = prompt("Command history"),
  search_history       = prompt("Search history"),
  registers            = prompt("Registers"),
  keymaps              = prompt("Keymaps"),
  nvim_options         = prompt("Nvim Options"),
  spell_suggest        = prompt("Spell Suggestions"),
  filetypes            = prompt("Filetypes"),
  packadd              = prompt("Packadd"),
  menus                = prompt("Menus"),
  tmux                 = prompt("Tmux Buffers"),
  dap                  = {
    commands       = prompt("DAP Commands"),
    configurations = prompt("DAP Configurations"),
    variables      = prompt("DAP Variables"),
    frames         = prompt("DAP Frames"),
    breakpoints    = prompt("DAP Breakpoints"),
  },
}
