local Runner = require("tests.indent.common").Runner

local run = Runner:new(it, "tests/indent/gleam", {
  tabstop = 2,
  shiftwidth = 2,
  softtabstop = 2,
  expandtab = true,
})

describe("indent Gleam:", function()
  describe("whole file:", function()
    run:whole_file "."
  end)
  describe("new line:", function()
    run:new_line("type.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("type.gleam", { on_line = 2, text = "//", indent = 2 })
    run:new_line("type.gleam", { on_line = 3, text = "//", indent = 0 })
    run:new_line("type.gleam", { on_line = 4, text = "//", indent = 0 })
    run:new_line("type.gleam", { on_line = 5, text = "//", indent = 2 })
    run:new_line("type.gleam", { on_line = 6, text = "//", indent = 2 })
    run:new_line("type.gleam", { on_line = 7, text = "//", indent = 2 })
    run:new_line("type.gleam", { on_line = 8, text = "//", indent = 0 })
    run:new_line("type.gleam", { on_line = 9, text = "//", indent = 0 })
    run:new_line("type.gleam", { on_line = 10, text = "//", indent = 2 })
    run:new_line("type.gleam", { on_line = 11, text = "//", indent = 2 })
    run:new_line("type.gleam", { on_line = 12, text = "//", indent = 0 })
    run:new_line("type.gleam", { on_line = 13, text = "//", indent = 0 })
    run:new_line("type.gleam", { on_line = 14, text = "//", indent = 2 })
    run:new_line("type.gleam", { on_line = 15, text = "//", indent = 0 })
    run:new_line("type.gleam", { on_line = 16, text = "//", indent = 0 })
    run:new_line("type.gleam", { on_line = 17, text = "//", indent = 2 })
    run:new_line("type.gleam", { on_line = 18, text = "//", indent = 0 })

    run:new_line("function.gleam", { on_line = 1, text = "//", indent = 0 })
    run:new_line("function.gleam", { on_line = 2, text = "//", indent = 0 })
    run:new_line("function.gleam", { on_line = 3, text = "//", indent = 2 })
    run:new_line("function.gleam", { on_line = 4, text = "//", indent = 2 })
    run:new_line("function.gleam", { on_line = 5, text = "//", indent = 0 })
    run:new_line("function.gleam", { on_line = 6, text = "//", indent = 0 })
    run:new_line("function.gleam", { on_line = 7, text = "//", indent = 2 })
    run:new_line("function.gleam", { on_line = 8, text = "//", indent = 2 })
    run:new_line("function.gleam", { on_line = 9, text = "//", indent = 0 })
    run:new_line("function.gleam", { on_line = 10, text = "//", indent = 0 })
    run:new_line("function.gleam", { on_line = 11, text = "//", indent = 2 })
    run:new_line("function.gleam", { on_line = 12, text = "//", indent = 2 })
    run:new_line("function.gleam", { on_line = 13, text = "//", indent = 2 })
    run:new_line("function.gleam", { on_line = 14, text = "//", indent = 2 })
    run:new_line("function.gleam", { on_line = 15, text = "//", indent = 2 })

    run:new_line("list.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("list.gleam", { on_line = 2, text = "//", indent = 4 })
    run:new_line("list.gleam", { on_line = 3, text = "//", indent = 4 })
    run:new_line("list.gleam", { on_line = 4, text = "//", indent = 6 })
    run:new_line("list.gleam", { on_line = 5, text = "//", indent = 6 })
    run:new_line("list.gleam", { on_line = 6, text = "//", indent = 8 })
    run:new_line("list.gleam", { on_line = 7, text = "//", indent = 8 })
    run:new_line("list.gleam", { on_line = 8, text = "//", indent = 6 })
    run:new_line("list.gleam", { on_line = 9, text = "//", indent = 4 })
    run:new_line("list.gleam", { on_line = 10, text = "//", indent = 2 })
    run:new_line("list.gleam", { on_line = 11, text = "//", indent = 0 })

    run:new_line("tuple.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("tuple.gleam", { on_line = 2, text = "//", indent = 4 })
    run:new_line("tuple.gleam", { on_line = 3, text = "//", indent = 4 })
    run:new_line("tuple.gleam", { on_line = 4, text = "//", indent = 6 })
    run:new_line("tuple.gleam", { on_line = 5, text = "//", indent = 6 })
    run:new_line("tuple.gleam", { on_line = 6, text = "//", indent = 8 })
    run:new_line("tuple.gleam", { on_line = 7, text = "//", indent = 8 })
    run:new_line("tuple.gleam", { on_line = 8, text = "//", indent = 6 })
    run:new_line("tuple.gleam", { on_line = 9, text = "//", indent = 4 })
    run:new_line("tuple.gleam", { on_line = 10, text = "//", indent = 2 })
    run:new_line("tuple.gleam", { on_line = 11, text = "//", indent = 0 })

    run:new_line("case.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("case.gleam", { on_line = 2, text = "//", indent = 4 })
    run:new_line("case.gleam", { on_line = 3, text = "//", indent = 4 })
    run:new_line("case.gleam", { on_line = 4, text = "//", indent = 6 })
    run:new_line("case.gleam", { on_line = 5, text = "//", indent = 8 })
    run:new_line("case.gleam", { on_line = 6, text = "//", indent = 8 })
    run:new_line("case.gleam", { on_line = 7, text = "//", indent = 6 })
    run:new_line("case.gleam", { on_line = 8, text = "//", indent = 4 })
    run:new_line("case.gleam", { on_line = 9, text = "//", indent = 2 })
    run:new_line("case.gleam", { on_line = 10, text = "//", indent = 0 })

    run:new_line("let.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("let.gleam", { on_line = 2, text = "//", indent = 4 })
    run:new_line("let.gleam", { on_line = 3, text = "//", indent = 4 })
    run:new_line("let.gleam", { on_line = 4, text = "//", indent = 0 })

    run:new_line("pipe.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("pipe.gleam", { on_line = 2, text = "//", indent = 2 })
    run:new_line("pipe.gleam", { on_line = 3, text = "//", indent = 2 })
    run:new_line("pipe.gleam", { on_line = 4, text = "//", indent = 0 })

    run:new_line("binary_expression.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("binary_expression.gleam", { on_line = 2, text = "//", indent = 4 })
    run:new_line("binary_expression.gleam", { on_line = 3, text = "//", indent = 4 })
    run:new_line("binary_expression.gleam", { on_line = 4, text = "//", indent = 0 })

    run:new_line("import.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("import.gleam", { on_line = 2, text = "//", indent = 2 })
    run:new_line("import.gleam", { on_line = 3, text = "//", indent = 2 })
    run:new_line("import.gleam", { on_line = 4, text = "//", indent = 0 })

    run:new_line("constant.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("constant.gleam", { on_line = 2, text = "//", indent = 2 })

    run:new_line("assert.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("assert.gleam", { on_line = 2, text = "//", indent = 4 })
    run:new_line("assert.gleam", { on_line = 3, text = "//", indent = 2 })
    run:new_line("assert.gleam", { on_line = 4, text = "//", indent = 0 })

    run:new_line("todo.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("todo.gleam", { on_line = 2, text = "//", indent = 4 })
    run:new_line("todo.gleam", { on_line = 3, text = "//", indent = 4 })
    run:new_line("todo.gleam", { on_line = 4, text = "//", indent = 2 })
    run:new_line("todo.gleam", { on_line = 5, text = "//", indent = 0 })

    run:new_line("anonymous_function.gleam", { on_line = 1, text = "//", indent = 2 })
    run:new_line("anonymous_function.gleam", { on_line = 2, text = "//", indent = 4 })
    run:new_line("anonymous_function.gleam", { on_line = 3, text = "//", indent = 6 })
    run:new_line("anonymous_function.gleam", { on_line = 4, text = "//", indent = 6 })
    run:new_line("anonymous_function.gleam", { on_line = 5, text = "//", indent = 4 })
    run:new_line("anonymous_function.gleam", { on_line = 6, text = "//", indent = 2 })
    run:new_line("anonymous_function.gleam", { on_line = 7, text = "//", indent = 0 })
  end)
end)
