if &compatible || exists('g:loaded_lesspipe') | finish | endif

if exists('g:lesspipe_cmd')
  let s:lesspipe_cmd = g:lesspipe_cmd
elseif executable('lesspipe.sh')
  let s:lesspipe_cmd = 'LESSQUIET=1 lesspipe.sh'
elseif executable('lesspipe')
  let s:lesspipe_cmd = 'lesspipe'
elseif executable('run-mailcap')
  let s:lesspipe_cmd = 'run-mailcap --action=cat'
endif

" Require a usable lesspipe command.
if !exists('s:lesspipe_cmd') || !executable('file') | finish | endif

" Optional upper bound to avoid expensive conversions; override as needed.
if !exists('g:lesspipe_max_bytes')
  let g:lesspipe_max_bytes = 20 * 1024 * 1024  " 20 MiB
endif

function! s:Lesspipe() abort
  if exists('b:lesspipe_done') | return | endif
  if !empty(&l:buftype) || &l:binary | return | endif

  let abs = resolve(expand('%:p'))
  if getftype(abs) !=# 'file' | return | endif
  if !filereadable(abs) | return | endif
  if abs =~# '^\w\+://' | return | endif

  if (!empty(&l:filetype) || did_filetype()) && !exists('b:lesspipe_force') | return | endif

  let sz = getfsize(abs)
  if sz >= 0 && sz > g:lesspipe_max_bytes | return | endif

  let mime = trim(system('file -b --mime-type ' .. shellescape(abs)))
  if v:shell_error == 0 && mime =~# '^text/' | return | endif

  try
    execute 'silent keepjumps keepmarks %!' s:lesspipe_cmd shellescape(abs)
    setlocal filetype=text buftype=nowrite bufhidden=hide noswapfile readonly nomodifiable
    let b:lesspipe_done = 1
  catch /.*/
  endtry
endfunction

augroup lesspipe
  autocmd!
  autocmd BufReadPost *   call s:Lesspipe()
  autocmd Filetype    pdf let b:lesspipe_force = 1 | doautocmd lesspipe BufReadPost
augroup END
