# vim: noai:ts=2:

export LANG="fr_FR.UTF-8"
export XDG_CONFIG_HOME="$HOME/.config"
export XDG_CACHE_HOME="$HOME/.cache"
export XDG_DATA_HOME="$HOME/.local/share"
export XDG_STATE_HOME="$HOME/.local/state"

# export LESSOPEN="|/opt/homebrew/bin/lesspipe.sh %s"
# export PKG_CONFIG_PATH=/opt/homebrew/lib/pkgconfig
export CABAL_DIR="$HOME/.cabal"
export CHICKEN_DOC_REPOSITORY=$HOME/.local/lib/scheme/chicken-doc
export CHICKEN_EGG_CACHE=$XDG_CACHE/chicken
export CHICKEN_INSTALL_REPOSITORY=$HOME/.local/lib/scheme/chicken
export CL_SOURCE_REGISTRY=$HOME/cwd/common-lisp
export GNUPGHOME=$XDG_CONFIG_HOME/gnupg
export HOMEBREW_NO_AUTO_UPDATE=1
export HOMEBREW_NO_EMOJI=1
export IPYTHONDIR=$XDG_CONFIG_HOME/ipython
export JUPYTER_CONFIG_DIR=$XDG_CONFIG_HOME/jupyter
export LEIN_HOME=$XDG_CONFIG_HOME/leiningen
export LESSHISTFILE=$XDG_STATE_HOME/less_history
export MPLCONFIGDIR=$XDG_CONFIG_HOME/matplotlib
export MYPY_CACHE_DIR=$XDG_CACHE/.mypy_cache
export NCFTPDIR=$XDG_CONFIG_HOME/ncftp
export PANDOC_HOME=$XDG_DATA_HOME/pandoc
export PYTHON_HISTORY=$XDG_STATE_HOME/python_history
export QUARTO_PYTHON=/opt/homebrew/Cellar/jupyterlab/4.4.6/libexec/bin/python
export SQLITE_HISTORY=$XDG_STATE_HOME/sqlite_history
export TERMINFO=/usr/share/terminfo/
export W3M_DIR=$XDG_CONFIG_HOME/w3m

# export GPG_TTY=$(tty)
# export CPPFLAGS="-I/opt/homebrew/include $CPPFLAGS"
# export LDFLAGS="-L/opt/homebrew/lib $LDFLAGS"

# Fix API server issue with Podman
# https://github.com/containers/podman/issues/13468#issuecomment-1062764637
# export DOCKER_HOST="unix:$XDG_RUNTIME_DIR/podman/podman.sock"

# Homebrew
eval "$(/opt/homebrew/bin/brew shellenv)"

# Java
export JAVA_HOME=$(/usr/libexec/java_home)

# Julia
[ -d "$HOME/.juliaup" ] && PATH="$PATH:$HOME/.juliaup/bin"

# Python
# [ -d "$HOME/.local/lib/jupyter" ] && PATH="$PATH:$HOME/.local/lib/jupyter/bin"

# Lisp
[ -d "$HOME/.roswell" ] && PATH="$HOME/.roswell/bin:$PATH"

# Go
if [ -d "/opt/homebrew/opt/go" ]; then
  export GOPATH="$HOME"/.local/lib/go
  PATH="$GOPATH/bin:$PATH"
fi

# Weka
export WEKA_HOME="$HOME"/.cache/wekafiles

# Node
# npm root -g
export NPM_CONFIG_USERCONFIG="$HOME/.config/npm/npmrc"
[ -d "$HOME/.local/share/npm" ] && PATH="$PATH:$HOME/.local/share/npm/bin"

# Deno
[ -d "$HOME/.deno" ] && PATH="$HOME/.deno/bin:$PATH"

# Rust
[ -d "$HOME/.cargo" ] && source "$HOME/.cargo/env"

# Haskell
# NOTE: https://ghcup.readthedocs.io/en/latest/guide/#xdg-support
[ -f "$HOME/.ghcup/env" ] && source "$HOME/.ghcup/env"

# global and user's local systems
[ -d "/usr/local/sbin" ] && PATH="$PATH":/usr/local/sbin
[ -d "/opt/bin" ] && PATH="$PATH":/opt/bin
[ -d "$HOME/bin" ] && PATH="$HOME/bin:$PATH"
[ -d "$HOME/.local/bin" ] && PATH="$HOME/.local/bin:$PATH"
