# FZF
if command -v fzf >/dev/null 2>&1; then
  if [ -n "$ZSH_VERSION" ]; then
     source /opt/homebrew/opt/fzf/shell/key-bindings.zsh
     source /opt/homebrew/opt/fzf/shell/completion.zsh
  fi
  if [ -n "$BASH_VERSION" ]; then
     source /opt/homebrew/opt/fzf/shell/key-bindings.bash
     source /opt/homebrew/opt/fzf/shell/completion.bash
  fi
  export FZF_DEFAULT_COMMAND="$((command -v fd >/dev/null 2>&1 && printf 'fd --type f --hidden --follow --exclude .git --exclude node_modules --strip-cwd-prefix') || \
    (command -v fdfind >/dev/null 2>&1 && printf 'fdfind --type f --hidden --follow --exclude .git --exclude node_modules --strip-cwd-prefix') || \
    (command -v rg >/dev/null 2>&1 && printf 'rg --files') || \
    (command -v ag >/dev/null 2>&1 && printf 'ag -g ""'))"
  export FZF_DEFAULT_OPTS="--bind='F4:toggle-preview,ctrl-a:select-all,ctrl-z:deselect-all,ctrl-t:toggle-all,ctrl-d:preview-page-down,ctrl-u:preview-page-up' --no-mouse --height 20% --layout=reverse --info=inline --color=bw"
  export FZF_CTRL_R_OPTS="--layout=reverse-list --height 100%"
  export FZF_CTRL_T_OPTS="--layout=reverse-list --info=default --height 20% --preview='head {}' --preview-window right:50%"
  export FZF_CTRL_T_COMMAND="$FZF_DEFAULT_COMMAND"
fi

if [[ "$(uname -s)" == "Darwin" ]]; then
  val=$(defaults read -g AppleInterfaceStyle 2>/dev/null)
  if [[ $val == "Dark" ]]; then
    osascript -e 'tell application "Terminal"
      set current settings of tabs of windows to settings set "Nord"
    end tell'
  else
    osascript -e 'tell application "Terminal"
      set current settings of tabs of windows to settings set "Papercolor"
    end tell'
  fi
fi

if [[ -z $TMUX ]]; then
  sessions=$(tmux ls 2>/dev/null | awk '! /attached/ { sub(":", "", $1); print $1; }' | xargs echo)
  [[ -n "$(tmux ls 2>/dev/null)"  && $sessions ]] && echo -e "\033[0;33m[INFO] Local session(s) available:\033[0;32m $sessions\033[0m"
  mail=$(cat ~/.local/state/mail)
  if [[ $mail -gt 0 ]]; then
      echo -e "\033[0;33m[INFO] Today unread mail(s):\033[0;32m $mail\033[0m"
  fi
fi

