# Listing dir
alias ls="ls -F"
alias la="ls -FA"
alias ll="ls -lh"
alias lsk="ls -lhSp"
alias lsr="ls -t| head -n 10"

# cd'ing stuff
alias ~='cd ~'
alias ..='cd ..'
alias ...=' cd ../../'
alias ....=' cd ../../../'
alias cd..='cd ../'

# Default programs
alias ghci="ghci -ghci-script ~/.config/ghci/config"
alias R="R --no-save --no-restore"
alias bc="bc -lq"
alias mutt=neomutt
# alias cmus='LC_ALL="C" cmus'
alias news=newsboat
alias vim=nvim
alias irssi="irssi --home=$XDG_CONFIG_HOME/irssi"
# HACK: https://github.com/sharkdp/fd/issues/1031
alias fd="LS_COLORS='' fd"
alias w3m="w3m -config ~/.config/w3m/config"
alias yt-dlp="yt-dlp --config-locations ~/.config/yt-dlp/config"
alias beet="source ~/.local/lib/beets/bin/activate && beet"
alias yt="source ~/.local/lib/yt/bin/activate && yt"
alias ctags="/opt/homebrew/opt/universal-ctags/bin/ctags"
alias mvi="mpv -profile image"
alias qcat="qlmanage -p"
alias python="/opt/homebrew/bin/python3"
alias ipython="/opt/homebrew/Cellar/jupyterlab/*/libexec/bin/ipython"
alias zutil="cat ~/.config/zsh/functions.txt"

# Git
alias gc="git commit -m"
alias gd="git d"
alias ga="git add --all ."
alias gg="git status -s -b"

# Misc
alias -g ':+'=" | wc -l"
alias -g '::'=" | less -R"
alias -g '??'=" | grep -E"
alias -g ':?'=" | grep -vE"
alias zconvert='noglob zconvert'
alias dua='du -had 1 | sort -rh'
alias tree="tree -NC"
alias perms="stat -c '%A %a %n'"
alias cx="chmod +x"
alias optipng-max="optipng -f0-5 -zc6-9 -i0 -zm6-9"
alias nonascii="LC_CTYPE=C grep --color='auto' -n -P '[\x80-\xFF]'"
alias notes='rg "TODO|NOTE|FIXME"'
alias p2x1="pdfnup --nup 2x1 --landscape --suffix '2x1' --batch "
alias pdfcat='gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=_merged.pdf'
alias orphans="ps -elf | head -1; ps -elf | awk '{if (\$5 == 1 && \$3 != \"root\") {print \$0}}' | head"
alias week='date +%V'
alias localip="ipconfig getifaddr en0"
alias ips="ifconfig -a | grep -o 'inet6\? \(addr:\)\?\s\?\(\(\([0-9]\+\.\)\{3\}[0-9]\+\)\|[a-fA-F0-9:]\+\)' | awk '{ sub(/inet6? (addr:)? ?/, \"\"); print }'"
alias path='echo -e ${PATH//:/\\n}'
alias f="fdfind --type f --hidden --exclude .git | fzf-tmux -p 75,25 --reverse | xargs nvim"
