autoload -U compinit && compinit

source ~/.local/share/zsh/zsh-autosuggestions/zsh-autosuggestions.zsh
ZSH_AUTOSUGGEST_HIGHLIGHT_STYLE="fg=8"
ZSH_AUTOSUGGEST_STRATEGY=history
# ZSH_AUTOSUGGEST_HISTORY_IGNORE="(git|ls|less|rm|vim|mxn) *"
ZSH_AUTOSUGGEST_USE_ASYNC=1

zstyle ':completion:*' auto-description 'specify: %d'
zstyle ':completion:*' completer _expand _complete _correct _approximate
# zstyle ':completion:*' format 'Completing %d'
zstyle ':completion:*' group-name ''
zstyle ':completion:*' menu select
# zstyle ':completion:*' menu select=long
zstyle ':completion:*' use-cache on
zstyle ':completion:*' cache-path "$XDG_CACHE_HOME/zsh/.zcompcache"

# eval "$(dircolors -b)"
zstyle ':completion:*:default' list-colors ${(s.:.)LS_COLORS}
zstyle ':completion:*' list-colors ''
zstyle ':completion:*' list-prompt %SAt %p: Hit TAB for more, or the character to insert%s
zstyle ':completion:*' matcher-list '' 'm:{a-z}={A-Z}' 'm:{a-zA-Z}={A-Za-z}' 'r:|[._-]=* r:|=* l:|=*'
zstyle ':completion:*' select-prompt %SScrolling active: current selection at %p%s
zstyle ':completion:*' use-compctl false
zstyle ':completion:*' verbose true
zstyle ':completion:*:*:kill:*:processes' list-colors '=(#b) #([0-9]#)*=0=01;31'
zstyle ':completion:*:kill:*' command 'ps -u $USER -o pid,%cpu,tty,cputime,cmd'
zstyle ':completion:*' complete-options true
zstyle ':completion:*:less:*' file-patterns '*~*.pdf'
zstyle ':completion:*:(kill|diff):*' ignore-line yes

zle -C hist-complete complete-word _generic
bindkey '^N'  hist-complete
zstyle ':completion:hist-complete:*' completer _history
zstyle ':completion:hist-complete:*' sort false # newest match first
zstyle ':completion:hist-complete:*' range 12000:8000
zstyle ':completion:hist-complete:*' matcher-list 'b:=*'
zstyle ':completion:hist-complete:*' remove-all-dups yes

zstyle ':completion:*:*:*:*:descriptions' format '%F{blue}-- %d --%f'
zstyle ':completion:*:*:*:*:corrections' format '%F{yellow}-- %d (errors: %e) --%f'
zstyle ':completion:*:messages' format ' %F{yellow}-- %d --%f'
zstyle ':completion:*:warnings' format ' %F{red}-- no matches found --%f'

__tmux-sessions() {
  local expl
  local -a sessions
  sessions=( $(mx) )
  _describe -t sessions 'sessions' sessions "$@"
}
compdef __tmux-sessions mx

__ssh_hosts() {
  local expl
  local -a hosts
  hosts=( $(grep -w -i "Host" ~/.ssh/config | sed 's/Host//') )
  _describe -t hosts 'hosts' hosts "$@"
}
compdef __ssh_hosts ssh

