function zman() {
    MANPAGER="col -b | vim -c 'set ft=man ts=8 nomod nolist nonu noma' +/'^       $1' -" man zshall
}

function zconvert() {
  zparseopts -D n=n
  zmv -vf -W -p convert $n "-o ${*[1,-3]}" "$@[-2]" "$@[-1]"
}

function glog() {
  local out shas sha q k
  while out=$(
      git log --graph --color=always \
          --format="%C(auto)%h%d %s %C(black)%C(bold)%cr" "$@" |
      fzf --ansi --multi --no-sort --reverse --query="$q" --tiebreak=index \
          --print-query --expect=ctrl-d --toggle-sort=\`); do
    q=$(head -1 <<< "$out")
    k=$(head -2 <<< "$out" | tail -1)
    shas=$(sed '1,2d;s/^[^a-z0-9]*//;/^$/d' <<< "$out" | awk '{print $1}')
    [ -z "$shas" ] && continue
    if [ "$k" = 'ctrl-d' ]; then
      git diff --color=always $shas | less -R
    else
      for sha in $shas; do
        git show --color=always $sha | less -R
      done
    fi
  done
}

function vf() {
	RG_PREFIX="rg -i --files-with-matches"
	local files
	files="$(
		FZF_DEFAULT_COMMAND_DEFAULT_COMMAND="$RG_PREFIX '$1'" \
			fzf --multi 10 --print0 --sort --preview="[[ ! -z {} ]] && rg --pretty --ignore-case --context 5 {q} {}" \
				--phony -i -q "$1" \
				--bind "change:reload:$RG_PREFIX {q}" \
				--preview-window="70%:wrap" \
				--bind 'ctrl-a:select-all'
	)"
	[[ "$files" ]] && nvim $(echo $files | tr \\0 " ")
}

# function vimgrep() {
#   rg --vimgrep "$1" "$2" | vim -c cb -
# }

function dud() {
  du -sh ./* | sort -h
  ## FIXME: check return code
  # rc=$(du -chs .[^.]* |tail -1 |cut -f 1)
  # printf '%s\t *hidden* files\n' "$rc"
}

function extract_urls () {
  cat "$1" | grep -o '<a .*href=.*>' | sed -e 's/<a /\n<a /g' | sed -e 's/<a .*href=['"'"'"]//' -e 's/["'"'"'].*$//' -e '/^$/ d'
}

function dict () {
  db=$([ -n "$2" ] && echo -n ":$2" || echo -n "")
  term=$(echo -n "$1" | jq -Rr @uri)
  curl "dict://dict.org/d:$term$db"
}

function translate () {
  dict "$1" fd-fra-eng
}

function gz() {
  local origsize=$(wc -c < "$1");
  local gzipsize=$(gzip -c "$1" | wc -c);
  local ratio=$(echo "$gzipsize * 100 / $origsize" | bc -l);
  printf "orig: %d bytes\n" "$origsize";
  printf "gzip: %d bytes (%2.2f%%)\n" "$gzipsize" "$ratio";
}

function mxw {
  tmux split-window -dh "$*"
}

function mkd() {
  mkdir -p "$@" && cd "$_";
}

function ltime() {
  fc -liDI 1 | tail -n ${1:-10}
}

function 256colors() {
  for i in {0..255}; do
    printf "\033[48;5;%dm\033[38;5;15m %03d " $i $i
    printf "\033[33;5;0m\033[38;5;%dm %03d " $i $i

  done
}

function nu() {
  perl -e '$l=length(@L = <>); printf "%*d %s",$l,++$i,$_ for @L;' -- "$@"
}

function tre() {
  tree -aC -I '.git|node_modules|bower_components' --dirsfirst "$@" | less -FRNX;
}

function bpaste() {
  curl -F "file=@${1:--}" https://0x0.st
}

function shorten() {
  curl -F "shorten=$*" https://0x0.st
}

function transfer() {
  curl --progress-bar --upload-file "$1" https://transfer.sh/$(basename "$1") | tee /dev/null;
  echo
}

function despace() {
  for f in *\ *; do mv "$f" "${f// /_}"; done
}

function serve() {
  local port=${1:-8000}
  local ip=$(ipconfig getifaddr en0)
  echo "Serving on ${ip}:${port} ..."
  python3 -m SimpleHTTPServer ${port}
}

function spinner() {
  while
  do
    for i in "-" "\\" "|" "/"
    do
      echo -n " $i \r\r"
      sleep .1
    done
  done
}

function bkp() {
  cp -a "${1}" "${1}_(date +'%Y-%m-%d')"
}

function digga() {
  dig +nocmd "$1" any +multiline +noall +answer;
}

function snif() {
  sudo lsof -iTCP -sTCP:LISTEN -P -n
}

function enc64() {
  openssl base64 -in "${1}" | awk -v ext=(get_ext ${1}) '{ str1=str1 $0 }END{ print "background:url(data:image/"ext";base64,"str1");" }'|pbcopy
  echo "${1} encoded to clipboard"
}

function webmp4() {
  if [ -z "$(command -v ffmpeg)" ]; then
    printf "%s\n" "ffmpeg is not installed" >&2
    return 1
  fi
  while [ $# -ne 0 ]; do
    ffmpeg -i "$1" "${1%.*}.mp4"
    shift
  done
}
